/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.stats.CounterStat;
import com.facebook.presto.hive.CacheQuotaRequirement;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileSplit;
import com.facebook.presto.hive.HivePartitionHandle;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveSplitLoader;
import com.facebook.presto.hive.HiveSplitWeightProvider;
import com.facebook.presto.hive.InternalHiveSplit;
import com.facebook.presto.hive.util.AsyncQueue;
import com.facebook.presto.hive.util.SizeBasedSplitWeightProvider;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.facebook.presto.spi.connector.NotPartitionedPartitionHandle;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.units.DataSize;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.concurrent.GuardedBy;

class HiveSplitSource
implements ConnectorSplitSource {
    private static final Logger log = Logger.get(HiveSplit.class);
    private final String queryId;
    private final String databaseName;
    private final String tableName;
    private final CacheQuotaRequirement cacheQuotaRequirement;
    private final PerBucket queues;
    private final AtomicInteger bufferedInternalSplitCount = new AtomicInteger();
    private final long maxOutstandingSplitsBytes;
    private final DataSize maxSplitSize;
    private final DataSize maxInitialSplitSize;
    private final boolean useRewindableSplitSource;
    private final AtomicInteger remainingInitialSplits;
    private final HiveSplitLoader splitLoader;
    private final AtomicReference<State> stateReference = new AtomicReference<State>(State.initial());
    private final AtomicLong estimatedSplitSizeInBytes = new AtomicLong();
    private final CounterStat highMemorySplitSourceCounter;
    private final AtomicBoolean loggedHighMemoryWarning = new AtomicBoolean();
    private final HiveSplitWeightProvider splitWeightProvider;
    private final double splitScanRatio;

    private HiveSplitSource(ConnectorSession session, String databaseName, String tableName, CacheQuotaRequirement cacheQuotaRequirement, PerBucket queues, int maxInitialSplits, DataSize maxOutstandingSplitsSize, HiveSplitLoader splitLoader, CounterStat highMemorySplitSourceCounter, boolean useRewindableSplitSource, double splitScanRatio) {
        Objects.requireNonNull(session, "session is null");
        this.queryId = session.getQueryId();
        this.databaseName = Objects.requireNonNull(databaseName, "databaseName is null");
        this.cacheQuotaRequirement = Objects.requireNonNull(cacheQuotaRequirement, "cacheQuotaRequirement is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.queues = Objects.requireNonNull(queues, "queues is null");
        this.maxOutstandingSplitsBytes = Objects.requireNonNull(maxOutstandingSplitsSize, "maxOutstandingSplitsSize is null").toBytes();
        this.splitLoader = Objects.requireNonNull(splitLoader, "splitLoader is null");
        this.highMemorySplitSourceCounter = Objects.requireNonNull(highMemorySplitSourceCounter, "highMemorySplitSourceCounter is null");
        this.maxSplitSize = HiveSessionProperties.getMaxSplitSize(session);
        this.maxInitialSplitSize = HiveSessionProperties.getMaxInitialSplitSize(session);
        this.useRewindableSplitSource = useRewindableSplitSource;
        this.remainingInitialSplits = new AtomicInteger(maxInitialSplits);
        HiveSplitWeightProvider hiveSplitWeightProvider = this.splitWeightProvider = HiveSessionProperties.isSizeBasedSplitWeightsEnabled(session) ? new SizeBasedSplitWeightProvider(HiveSessionProperties.getMinimumAssignedSplitWeight(session), this.maxSplitSize) : HiveSplitWeightProvider.uniformStandardWeightProvider();
        if (!Double.isFinite(splitScanRatio)) {
            splitScanRatio = 1.0;
        }
        this.splitScanRatio = Math.max(Math.min(splitScanRatio, 1.0), 0.1);
    }

    public static HiveSplitSource allAtOnce(ConnectorSession session, String databaseName, String tableName, CacheQuotaRequirement cacheQuotaRequirement, int maxInitialSplits, final int maxOutstandingSplits, DataSize maxOutstandingSplitsSize, HiveSplitLoader splitLoader, final Executor executor, CounterStat highMemorySplitSourceCounter, double splitScanRatio) {
        return new HiveSplitSource(session, databaseName, tableName, cacheQuotaRequirement, new PerBucket(){
            private final AsyncQueue<InternalHiveSplit> queue;
            {
                this.queue = new AsyncQueue(maxOutstandingSplits, executor);
            }

            @Override
            public ListenableFuture<?> offer(OptionalInt bucketNumber, InternalHiveSplit connectorSplit) {
                return this.queue.offer(connectorSplit);
            }

            @Override
            public ListenableFuture<List<ConnectorSplit>> borrowBatchAsync(OptionalInt bucketNumber, int maxSize, Function<List<InternalHiveSplit>, AsyncQueue.BorrowResult<InternalHiveSplit, List<ConnectorSplit>>> function) {
                Preconditions.checkArgument((!bucketNumber.isPresent() ? 1 : 0) != 0);
                return this.queue.borrowBatchAsync(maxSize, function);
            }

            @Override
            public void noMoreSplits() {
                this.queue.finish();
            }

            @Override
            public boolean isFinished(OptionalInt bucketNumber) {
                Preconditions.checkArgument((!bucketNumber.isPresent() ? 1 : 0) != 0);
                return this.queue.isFinished();
            }

            @Override
            public int rewind(OptionalInt bucketNumber) {
                throw new UnsupportedOperationException("rewind is not supported for non bucketed split source");
            }
        }, maxInitialSplits, maxOutstandingSplitsSize, splitLoader, highMemorySplitSourceCounter, false, splitScanRatio);
    }

    public static HiveSplitSource bucketed(ConnectorSession session, String databaseName, String tableName, CacheQuotaRequirement cacheQuotaRequirement, int maxInitialSplits, final int estimatedOutstandingSplitsPerBucket, DataSize maxOutstandingSplitsSize, HiveSplitLoader splitLoader, final Executor executor, CounterStat highMemorySplitSourceCounter, double splitScanRatio) {
        return new HiveSplitSource(session, databaseName, tableName, cacheQuotaRequirement, new PerBucket(){
            private final Map<Integer, AsyncQueue<InternalHiveSplit>> queues = new ConcurrentHashMap<Integer, AsyncQueue<InternalHiveSplit>>();
            private final AtomicBoolean finished = new AtomicBoolean();

            @Override
            public ListenableFuture<?> offer(OptionalInt bucketNumber, InternalHiveSplit connectorSplit) {
                AsyncQueue<InternalHiveSplit> queue = this.queueFor(bucketNumber);
                queue.offer(connectorSplit);
                return Futures.immediateFuture(null);
            }

            @Override
            public ListenableFuture<List<ConnectorSplit>> borrowBatchAsync(OptionalInt bucketNumber, int maxSize, Function<List<InternalHiveSplit>, AsyncQueue.BorrowResult<InternalHiveSplit, List<ConnectorSplit>>> function) {
                return this.queueFor(bucketNumber).borrowBatchAsync(maxSize, function);
            }

            @Override
            public void noMoreSplits() {
                if (this.finished.compareAndSet(false, true)) {
                    this.queues.values().forEach(AsyncQueue::finish);
                }
            }

            @Override
            public boolean isFinished(OptionalInt bucketNumber) {
                return this.queueFor(bucketNumber).isFinished();
            }

            @Override
            public int rewind(OptionalInt bucketNumber) {
                throw new UnsupportedOperationException("rewind is not supported for unrewindable split source");
            }

            private AsyncQueue<InternalHiveSplit> queueFor(OptionalInt bucketNumber) {
                Preconditions.checkArgument((boolean)bucketNumber.isPresent());
                AtomicBoolean isNew = new AtomicBoolean();
                AsyncQueue queue = this.queues.computeIfAbsent(bucketNumber.getAsInt(), ignored -> {
                    isNew.set(true);
                    return new AsyncQueue(estimatedOutstandingSplitsPerBucket, executor);
                });
                if (isNew.get() && this.finished.get()) {
                    queue.finish();
                }
                return queue;
            }
        }, maxInitialSplits, maxOutstandingSplitsSize, splitLoader, highMemorySplitSourceCounter, false, splitScanRatio);
    }

    public static HiveSplitSource bucketedRewindable(ConnectorSession session, String databaseName, String tableName, CacheQuotaRequirement cacheQuotaRequirement, int maxInitialSplits, DataSize maxOutstandingSplitsSize, HiveSplitLoader splitLoader, final Executor executor, CounterStat highMemorySplitSourceCounter, double splitScanRatio) {
        return new HiveSplitSource(session, databaseName, tableName, cacheQuotaRequirement, new PerBucket(){
            @GuardedBy(value="this")
            private final Map<Integer, List<InternalHiveSplit>> splits = new HashMap<Integer, List<InternalHiveSplit>>();
            private final SettableFuture<?> allSplitLoaded = SettableFuture.create();

            @Override
            public synchronized ListenableFuture<?> offer(OptionalInt bucketNumber, InternalHiveSplit connectorSplit) {
                Preconditions.checkArgument((boolean)bucketNumber.isPresent(), (Object)"bucketNumber must be present");
                this.splits.computeIfAbsent(bucketNumber.getAsInt(), ignored -> new ArrayList()).add(connectorSplit);
                return Futures.immediateFuture(null);
            }

            @Override
            public synchronized ListenableFuture<List<ConnectorSplit>> borrowBatchAsync(OptionalInt bucketNumber, int maxSize, Function<List<InternalHiveSplit>, AsyncQueue.BorrowResult<InternalHiveSplit, List<ConnectorSplit>>> function) {
                Preconditions.checkArgument((boolean)bucketNumber.isPresent(), (Object)"bucketNumber must be present");
                if (!this.allSplitLoaded.isDone()) {
                    return this.allSplitLoaded.transform(ignored -> ImmutableList.of(), executor);
                }
                return Futures.immediateFuture(function.apply(this.getSplits(bucketNumber.getAsInt(), maxSize)).getResult());
            }

            private List<InternalHiveSplit> getSplits(int bucketNumber, int batchSize) {
                return (List)this.splits.getOrDefault(bucketNumber, (List<InternalHiveSplit>)ImmutableList.of()).stream().filter(split -> !split.isDone()).limit(batchSize).collect(ImmutableList.toImmutableList());
            }

            @Override
            public void noMoreSplits() {
                this.allSplitLoaded.set(null);
            }

            @Override
            public boolean isFinished(OptionalInt bucketNumber) {
                Preconditions.checkArgument((boolean)bucketNumber.isPresent(), (Object)"bucketNumber must be present");
                return this.allSplitLoaded.isDone() && (!this.splits.containsKey(bucketNumber.getAsInt()) || this.splits.get(bucketNumber.getAsInt()).stream().allMatch(InternalHiveSplit::isDone));
            }

            @Override
            public synchronized int rewind(OptionalInt bucketNumber) {
                Preconditions.checkArgument((boolean)bucketNumber.isPresent(), (Object)"bucketNumber must be present");
                Preconditions.checkState((boolean)this.allSplitLoaded.isDone(), (Object)"splits cannot be rewound before splits enumeration is finished");
                int revivedSplitCount = 0;
                for (InternalHiveSplit split : this.splits.getOrDefault(bucketNumber.getAsInt(), (List<InternalHiveSplit>)ImmutableList.of())) {
                    if (split.isDone()) {
                        ++revivedSplitCount;
                    }
                    split.reset();
                }
                return revivedSplitCount;
            }

            @Override
            public int decrementAndGetPartitionReferences(InternalHiveSplit split) {
                throw new UnsupportedOperationException("decrementPartitionReferences is not supported for rewindable split sources");
            }
        }, maxInitialSplits, maxOutstandingSplitsSize, splitLoader, highMemorySplitSourceCounter, true, splitScanRatio);
    }

    @VisibleForTesting
    int getBufferedInternalSplitCount() {
        return this.bufferedInternalSplitCount.get();
    }

    ListenableFuture<?> addToQueue(List<? extends InternalHiveSplit> splits) {
        ListenableFuture<?> lastResult = Futures.immediateFuture(null);
        for (InternalHiveSplit internalHiveSplit : splits) {
            lastResult = this.addToQueue(internalHiveSplit);
        }
        return lastResult;
    }

    ListenableFuture<?> addToQueue(InternalHiveSplit split) {
        if (this.stateReference.get().getKind() != StateKind.INITIAL) {
            return Futures.immediateFuture(null);
        }
        if (split.getPartitionInfo().incrementAndGetReferences() == 1) {
            this.estimatedSplitSizeInBytes.addAndGet(split.getPartitionInfo().getEstimatedSizeInBytes());
        }
        if (this.estimatedSplitSizeInBytes.addAndGet(split.getEstimatedSizeInBytes()) > this.maxOutstandingSplitsBytes) {
            if (this.loggedHighMemoryWarning.compareAndSet(false, true)) {
                this.highMemorySplitSourceCounter.update(1L);
                log.warn("Split buffering for %s.%s in query %s exceeded memory limit (%s). %s splits are buffered.", new Object[]{this.databaseName, this.tableName, this.queryId, DataSize.succinctBytes((long)this.maxOutstandingSplitsBytes), this.getBufferedInternalSplitCount()});
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_EXCEEDED_SPLIT_BUFFERING_LIMIT, String.format("Split buffering for %s.%s exceeded memory limit (%s). %s splits are buffered.", this.databaseName, this.tableName, DataSize.succinctBytes((long)this.maxOutstandingSplitsBytes), this.getBufferedInternalSplitCount()));
        }
        this.bufferedInternalSplitCount.incrementAndGet();
        OptionalInt bucketNumber = split.getReadBucketNumber();
        return this.queues.offer(bucketNumber, split);
    }

    void noMoreSplits() {
        if (HiveSplitSource.setIf(this.stateReference, State.noMoreSplits(), state -> state.getKind() == StateKind.INITIAL)) {
            this.splitLoader.stop();
            this.queues.noMoreSplits();
        }
    }

    void fail(Throwable e) {
        if (HiveSplitSource.setIf(this.stateReference, State.failed(e), state -> state.getKind() == StateKind.INITIAL)) {
            this.splitLoader.stop();
            this.queues.noMoreSplits();
        }
    }

    public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, int maxSize) {
        boolean noMoreSplits;
        State state = this.stateReference.get();
        switch (state.getKind()) {
            case INITIAL: {
                noMoreSplits = false;
                break;
            }
            case NO_MORE_SPLITS: {
                noMoreSplits = true;
                break;
            }
            case FAILED: {
                return MoreFutures.failedFuture((Throwable)state.getThrowable());
            }
            case CLOSED: {
                throw new IllegalStateException("HiveSplitSource is already closed");
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        OptionalInt bucketNumber = HiveSplitSource.toBucketNumber(partitionHandle);
        ListenableFuture<List<ConnectorSplit>> future = this.queues.borrowBatchAsync(bucketNumber, maxSize, internalSplits -> {
            ImmutableList.Builder splitsToInsertBuilder = ImmutableList.builder();
            ImmutableList.Builder resultBuilder = ImmutableList.builder();
            int removedEstimatedSizeInBytes = 0;
            for (InternalHiveSplit internalSplit : internalSplits) {
                long remainingBlockBytes;
                long maxSplitBytes = this.maxSplitSize.toBytes();
                if (this.remainingInitialSplits.get() > 0 && this.remainingInitialSplits.getAndDecrement() > 0) {
                    maxSplitBytes = this.maxInitialSplitSize.toBytes();
                }
                maxSplitBytes = (long)((double)maxSplitBytes / this.splitScanRatio);
                InternalHiveSplit.InternalHiveBlock block = internalSplit.currentBlock();
                long splitBytes = internalSplit.isSplittable() ? ((remainingBlockBytes = block.getEnd() - internalSplit.getStart()) <= maxSplitBytes ? remainingBlockBytes : (maxSplitBytes * 2L >= remainingBlockBytes ? remainingBlockBytes / 2L : maxSplitBytes)) : internalSplit.getEnd() - internalSplit.getStart();
                HiveFileSplit fileSplit = new HiveFileSplit(internalSplit.getPath(), internalSplit.getStart(), splitBytes, internalSplit.getFileSize(), internalSplit.getFileModifiedTime(), internalSplit.getExtraFileInfo(), internalSplit.getCustomSplitInfo());
                resultBuilder.add((Object)new HiveSplit(fileSplit, this.databaseName, this.tableName, internalSplit.getPartitionName(), internalSplit.getPartitionInfo().getStorage(), internalSplit.getPartitionKeys(), block.getAddresses(), internalSplit.getReadBucketNumber(), internalSplit.getTableBucketNumber(), internalSplit.getNodeSelectionStrategy(), internalSplit.getPartitionInfo().getPartitionDataColumnCount(), internalSplit.getTableToPartitionMapping(), internalSplit.getBucketConversion(), internalSplit.isS3SelectPushdownEnabled(), this.cacheQuotaRequirement, internalSplit.getEncryptionInformation(), internalSplit.getPartitionInfo().getRedundantColumnDomains(), this.splitWeightProvider.weightForSplitSizeInBytes(splitBytes), internalSplit.getPartitionInfo().getRowIdPartitionComponent()));
                internalSplit.increaseStart(splitBytes);
                if (internalSplit.isDone()) {
                    removedEstimatedSizeInBytes += internalSplit.getEstimatedSizeInBytes();
                    if (this.useRewindableSplitSource || this.queues.decrementAndGetPartitionReferences(internalSplit) != 0) continue;
                    removedEstimatedSizeInBytes += internalSplit.getPartitionInfo().getEstimatedSizeInBytes();
                    continue;
                }
                splitsToInsertBuilder.add((Object)internalSplit);
            }
            if (!this.useRewindableSplitSource) {
                this.estimatedSplitSizeInBytes.addAndGet(-removedEstimatedSizeInBytes);
            }
            ImmutableList splitsToInsert = splitsToInsertBuilder.build();
            ImmutableList result = resultBuilder.build();
            this.bufferedInternalSplitCount.addAndGet(splitsToInsert.size() - result.size());
            return new AsyncQueue.BorrowResult(splitsToInsert, result);
        });
        ListenableFuture transform = Futures.transform(future, splits -> {
            Objects.requireNonNull(splits, "splits is null");
            if (noMoreSplits) {
                return new ConnectorSplitSource.ConnectorSplitBatch(splits, splits.isEmpty() && this.queues.isFinished(bucketNumber));
            }
            return new ConnectorSplitSource.ConnectorSplitBatch(splits, false);
        }, (Executor)MoreExecutors.directExecutor());
        return MoreFutures.toCompletableFuture((ListenableFuture)transform);
    }

    public void rewind(ConnectorPartitionHandle partitionHandle) {
        this.bufferedInternalSplitCount.addAndGet(this.queues.rewind(HiveSplitSource.toBucketNumber(partitionHandle)));
    }

    public boolean isFinished() {
        State state = this.stateReference.get();
        switch (state.getKind()) {
            case INITIAL: {
                return false;
            }
            case NO_MORE_SPLITS: {
                return this.bufferedInternalSplitCount.get() == 0;
            }
            case FAILED: {
                throw HiveSplitSource.propagatePrestoException(state.getThrowable());
            }
            case CLOSED: {
                throw new IllegalStateException("HiveSplitSource is already closed");
            }
        }
        throw new UnsupportedOperationException();
    }

    public void close() {
        if (HiveSplitSource.setIf(this.stateReference, State.closed(), state -> state.getKind() == StateKind.INITIAL || state.getKind() == StateKind.NO_MORE_SPLITS)) {
            this.splitLoader.stop();
            this.queues.noMoreSplits();
        }
    }

    private static OptionalInt toBucketNumber(ConnectorPartitionHandle partitionHandle) {
        if (partitionHandle == NotPartitionedPartitionHandle.NOT_PARTITIONED) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(((HivePartitionHandle)partitionHandle).getBucket());
    }

    private static <T> boolean setIf(AtomicReference<T> atomicReference, T newValue, Predicate<T> predicate) {
        T current;
        do {
            if (predicate.test(current = atomicReference.get())) continue;
            return false;
        } while (!atomicReference.compareAndSet(current, newValue));
        return true;
    }

    private static RuntimeException propagatePrestoException(Throwable throwable) {
        if (throwable instanceof PrestoException) {
            throw (PrestoException)throwable;
        }
        if (throwable instanceof FileNotFoundException) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILE_NOT_FOUND, throwable);
        }
        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_ERROR, throwable);
    }

    static enum StateKind {
        INITIAL,
        NO_MORE_SPLITS,
        FAILED,
        CLOSED;

    }

    static class State {
        private final StateKind kind;
        private final Throwable throwable;

        private State(StateKind kind, Throwable throwable) {
            this.kind = kind;
            this.throwable = throwable;
        }

        public StateKind getKind() {
            return this.kind;
        }

        public Throwable getThrowable() {
            Preconditions.checkState((this.throwable != null ? 1 : 0) != 0);
            return this.throwable;
        }

        public static State initial() {
            return new State(StateKind.INITIAL, null);
        }

        public static State noMoreSplits() {
            return new State(StateKind.NO_MORE_SPLITS, null);
        }

        public static State failed(Throwable throwable) {
            return new State(StateKind.FAILED, throwable);
        }

        public static State closed() {
            return new State(StateKind.CLOSED, null);
        }
    }

    static interface PerBucket {
        public ListenableFuture<?> offer(OptionalInt var1, InternalHiveSplit var2);

        public ListenableFuture<List<ConnectorSplit>> borrowBatchAsync(OptionalInt var1, int var2, Function<List<InternalHiveSplit>, AsyncQueue.BorrowResult<InternalHiveSplit, List<ConnectorSplit>>> var3);

        public void noMoreSplits();

        public boolean isFinished(OptionalInt var1);

        public int rewind(OptionalInt var1);

        default public int decrementAndGetPartitionReferences(InternalHiveSplit split) {
            return split.getPartitionInfo().decrementAndGetReferences();
        }
    }
}

