/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.configuration.Config;
import com.facebook.presto.parquet.writer.ParquetWriterOptions;
import io.airlift.units.DataSize;
import org.apache.parquet.column.ParquetProperties;

public class ParquetFileWriterConfig {
    private boolean parquetOptimizedWriterEnabled;
    private DataSize blockSize = new DataSize(1.34217728E8, DataSize.Unit.BYTE);
    private DataSize pageSize = new DataSize(1048576.0, DataSize.Unit.BYTE);
    private ParquetProperties.WriterVersion writerVersion = ParquetWriterOptions.DEFAULT_WRITER_VERSION;

    public DataSize getBlockSize() {
        return this.blockSize;
    }

    @Config(value="hive.parquet.writer.block-size")
    public ParquetFileWriterConfig setBlockSize(DataSize blockSize) {
        this.blockSize = blockSize;
        return this;
    }

    public DataSize getPageSize() {
        return this.pageSize;
    }

    @Config(value="hive.parquet.writer.page-size")
    public ParquetFileWriterConfig setPageSize(DataSize pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public ParquetProperties.WriterVersion getWriterVersion() {
        return this.writerVersion;
    }

    @Config(value="hive.parquet.writer.version")
    public ParquetFileWriterConfig setWriterVersion(ParquetProperties.WriterVersion writerVersion) {
        this.writerVersion = writerVersion;
        return this;
    }

    public boolean isParquetOptimizedWriterEnabled() {
        return this.parquetOptimizedWriterEnabled;
    }

    @Config(value="hive.parquet.optimized-writer.enabled")
    public ParquetFileWriterConfig setParquetOptimizedWriterEnabled(boolean parquetOptimizedWriterEnabled) {
        this.parquetOptimizedWriterEnabled = parquetOptimizedWriterEnabled;
        return this;
    }
}

