/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.BaseHiveColumnHandle;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HivePartitionMetadata;
import com.facebook.presto.hive.HiveSplitSource;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class PartitionLoader {
    public abstract ListenableFuture<?> loadPartition(HivePartitionMetadata var1, HiveSplitSource var2, boolean var3) throws IOException;

    public List<HivePartitionKey> getPartitionKeys(Table table, Optional<Partition> partition, String partitionName) {
        if (!partition.isPresent()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder partitionKeys = ImmutableList.builder();
        List keys = table.getPartitionColumns();
        List<HiveColumnHandle> partitionColumns = HiveUtil.getPartitionKeyColumnHandles(table);
        List partitionColumnNames = partitionColumns.stream().map(BaseHiveColumnHandle::getName).collect(Collectors.toList());
        List values = MetastoreUtil.extractPartitionValues((String)partitionName, Optional.of(partitionColumnNames));
        MetastoreUtil.checkCondition((keys.size() == values.size() ? 1 : 0) != 0, (ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, (String)"Expected %s partition key values, but got %s", (Object[])new Object[]{keys.size(), values.size()});
        for (int i = 0; i < keys.size(); ++i) {
            String name = ((Column)keys.get(i)).getName();
            HiveType hiveType = ((Column)keys.get(i)).getType();
            if (!hiveType.isSupportedType()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type %s found in partition keys of table %s.%s", hiveType, table.getDatabaseName(), table.getTableName()));
            }
            String value = (String)values.get(i);
            MetastoreUtil.checkCondition((value != null ? 1 : 0) != 0, (ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, (String)"partition key value cannot be null for field: %s", (Object[])new Object[]{name});
            partitionKeys.add((Object)new HivePartitionKey(name, "__HIVE_DEFAULT_PARTITION__".equals(value) ? Optional.empty() : Optional.of(value)));
        }
        return partitionKeys.build();
    }
}

