/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.predicate.TupleDomainFilter;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.hive.HiveCoercer;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slices;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

class RowIDCoercer
implements HiveCoercer {
    private final byte[] rowIDPartitionComponent;
    private final byte[] rowGroupID;

    RowIDCoercer(byte[] rowIDPartitionComponent, String rowGroupID) {
        this.rowIDPartitionComponent = Objects.requireNonNull(rowIDPartitionComponent);
        this.rowGroupID = rowGroupID.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public TupleDomainFilter toCoercingFilter(TupleDomainFilter filter, Subfield subfield) {
        Preconditions.checkArgument((boolean)subfield.getPath().isEmpty(), (Object)"Subfields on primitive types are not allowed");
        return filter;
    }

    @Override
    public Type getToType() {
        return VarbinaryType.VARBINARY;
    }

    @Override
    public Block apply(Block in) {
        BlockBuilder out = VarbinaryType.VARBINARY.createBlockBuilder(null, in.getPositionCount());
        for (int i = 0; i < in.getPositionCount(); ++i) {
            if (in.isNull(i)) {
                out.appendNull();
                continue;
            }
            long rowNumber = BigintType.BIGINT.getLong(in, i);
            ByteBuffer rowID = ByteBuffer.allocateDirect(this.rowIDPartitionComponent.length + this.rowGroupID.length + 8).order(ByteOrder.LITTLE_ENDIAN);
            rowID.putLong(rowNumber);
            rowID.put(this.rowGroupID);
            rowID.put(this.rowIDPartitionComponent);
            rowID.flip();
            VarbinaryType.VARBINARY.writeSlice(out, Slices.wrappedBuffer((ByteBuffer)rowID));
        }
        return out.build();
    }
}

