/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.orc;

import com.facebook.hive.orc.OrcSerde;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveAggregatedPageSourceFactory;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.hive.HiveFileSplit;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.orc.OrcAggregatedPageSourceFactory;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.StripeMetadataSourceFactory;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;

public class DwrfAggregatedPageSourceFactory
implements HiveAggregatedPageSourceFactory {
    private final TypeManager typeManager;
    private final StandardFunctionResolution functionResolution;
    private final boolean useOrcColumnNames;
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats stats;
    private final OrcFileTailSource orcFileTailSource;
    private final StripeMetadataSourceFactory stripeMetadataSourceFactory;

    @Inject
    public DwrfAggregatedPageSourceFactory(TypeManager typeManager, StandardFunctionResolution functionResolution, HiveClientConfig config, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats, OrcFileTailSource orcFileTailSource, StripeMetadataSourceFactory stripeMetadataSourceFactory) {
        this(typeManager, functionResolution, Objects.requireNonNull(config, "hiveClientConfig is null").isUseOrcColumnNames(), hdfsEnvironment, stats, orcFileTailSource, stripeMetadataSourceFactory);
    }

    public DwrfAggregatedPageSourceFactory(TypeManager typeManager, StandardFunctionResolution functionResolution, boolean useOrcColumnNames, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats, OrcFileTailSource orcFileTailSource, StripeMetadataSourceFactory stripeMetadataSourceFactory) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
        this.useOrcColumnNames = useOrcColumnNames;
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.orcFileTailSource = Objects.requireNonNull(orcFileTailSource, "orcFileTailCache is null");
        this.stripeMetadataSourceFactory = Objects.requireNonNull(stripeMetadataSourceFactory, "stripeMetadataSourceFactory is null");
    }

    @Override
    public Optional<? extends ConnectorPageSource> createPageSource(Configuration configuration, ConnectorSession session, HiveFileSplit fileSplit, Storage storage, List<HiveColumnHandle> columns, HiveFileContext hiveFileContext, Optional<EncryptionInformation> encryptionInformation, boolean appendRowNumberEnabled) {
        if (!OrcSerde.class.getName().equals(storage.getStorageFormat().getSerDe())) {
            return Optional.empty();
        }
        if (fileSplit.getFileSize() == 0L) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, "ORC file is empty: " + fileSplit.getPath());
        }
        return Optional.of(OrcAggregatedPageSourceFactory.createOrcPageSource(session, OrcEncoding.DWRF, this.hdfsEnvironment, configuration, fileSplit, columns, this.useOrcColumnNames, this.typeManager, this.functionResolution, this.stats, this.orcFileTailSource, this.stripeMetadataSourceFactory, hiveFileContext, encryptionInformation, DwrfEncryptionProvider.NO_ENCRYPTION, appendRowNumberEnabled));
    }
}

