/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.orc;

import com.facebook.hive.orc.OrcSerde;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBatchPageSourceFactory;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveCommonSessionProperties;
import com.facebook.presto.hive.HiveDwrfEncryptionProvider;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.hive.HiveFileSplit;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.orc.OrcBatchPageSourceFactory;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcReaderOptions;
import com.facebook.presto.orc.StripeMetadataSourceFactory;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.joda.time.DateTimeZone;

public class DwrfBatchPageSourceFactory
implements HiveBatchPageSourceFactory {
    private final TypeManager typeManager;
    private final StandardFunctionResolution functionResolution;
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats stats;
    private final int domainCompactionThreshold;
    private final OrcFileTailSource orcFileTailSource;
    private final StripeMetadataSourceFactory stripeMetadataSourceFactory;
    private final DwrfEncryptionProvider dwrfEncryptionProvider;

    @Inject
    public DwrfBatchPageSourceFactory(TypeManager typeManager, StandardFunctionResolution functionResolution, HiveClientConfig config, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats, OrcFileTailSource orcFileTailSource, StripeMetadataSourceFactory stripeMetadataSourceFactory, HiveDwrfEncryptionProvider dwrfEncryptionProvider) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.domainCompactionThreshold = Objects.requireNonNull(config, "config is null").getDomainCompactionThreshold();
        this.orcFileTailSource = Objects.requireNonNull(orcFileTailSource, "orcFileTailSource is null");
        this.stripeMetadataSourceFactory = Objects.requireNonNull(stripeMetadataSourceFactory, "stripeMetadataSourceFactory is null");
        this.dwrfEncryptionProvider = Objects.requireNonNull(dwrfEncryptionProvider, "dwrfEncryptionProvider is null").toDwrfEncryptionProvider();
    }

    @Override
    public Optional<? extends ConnectorPageSource> createPageSource(Configuration configuration, ConnectorSession session, HiveFileSplit fileSplit, Storage storage, SchemaTableName tableName, Map<String, String> tableParameters, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone, HiveFileContext hiveFileContext, Optional<EncryptionInformation> encryptionInformation) {
        if (!OrcSerde.class.getName().equals(storage.getStorageFormat().getSerDe())) {
            return Optional.empty();
        }
        if (fileSplit.getFileSize() == 0L) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, "ORC file is empty: " + fileSplit.getPath());
        }
        return Optional.of(OrcBatchPageSourceFactory.createOrcPageSource(OrcEncoding.DWRF, this.hdfsEnvironment, configuration, fileSplit, columns, false, effectivePredicate, hiveStorageTimeZone, this.typeManager, false, this.stats, this.domainCompactionThreshold, this.orcFileTailSource, this.stripeMetadataSourceFactory, hiveFileContext, OrcReaderOptions.builder().withMaxMergeDistance(HiveCommonSessionProperties.getOrcMaxMergeDistance((ConnectorSession)session)).withTinyStripeThreshold(HiveCommonSessionProperties.getOrcTinyStripeThreshold((ConnectorSession)session)).withMaxBlockSize(HiveCommonSessionProperties.getOrcMaxReadBlockSize((ConnectorSession)session)).withZstdJniDecompressionEnabled(HiveCommonSessionProperties.isOrcZstdJniDecompressionEnabled((ConnectorSession)session)).build(), encryptionInformation, this.dwrfEncryptionProvider, session));
    }
}

