/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.orc;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.predicate.FilterFunction;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.predicate.TupleDomainFilter;
import com.facebook.presto.common.relation.Predicate;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.expressions.DefaultRowExpressionTraversalVisitor;
import com.facebook.presto.expressions.DynamicFilters;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.expressions.RowExpressionNodeInliner;
import com.facebook.presto.hive.BaseHiveColumnHandle;
import com.facebook.presto.hive.BucketAdaptation;
import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveCoercer;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveCommonSessionProperties;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.hive.HiveFileSplit;
import com.facebook.presto.hive.HiveOrcAggregatedMemoryContext;
import com.facebook.presto.hive.HiveSelectivePageSourceFactory;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.SubfieldExtractor;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.orc.HdfsOrcDataSource;
import com.facebook.presto.hive.orc.OrcPageSourceFactoryUtils;
import com.facebook.presto.hive.orc.OrcSelectivePageSource;
import com.facebook.presto.hive.orc.TupleDomainFilterCache;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcReaderOptions;
import com.facebook.presto.orc.OrcSelectiveRecordReader;
import com.facebook.presto.orc.StripeMetadataSourceFactory;
import com.facebook.presto.orc.TupleDomainOrcPredicate;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.FixedPageSource;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.PredicateCompiler;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.joda.time.DateTimeZone;

public class OrcSelectivePageSourceFactory
implements HiveSelectivePageSourceFactory {
    private final TypeManager typeManager;
    private final StandardFunctionResolution functionResolution;
    private final RowExpressionService rowExpressionService;
    private final boolean useOrcColumnNames;
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats stats;
    private final int domainCompactionThreshold;
    private final OrcFileTailSource orcFileTailSource;
    private final StripeMetadataSourceFactory stripeMetadataSourceFactory;
    private final TupleDomainFilterCache tupleDomainFilterCache;

    @Inject
    public OrcSelectivePageSourceFactory(TypeManager typeManager, StandardFunctionResolution functionResolution, RowExpressionService rowExpressionService, HiveClientConfig config, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats, OrcFileTailSource orcFileTailSource, StripeMetadataSourceFactory stripeMetadataSourceFactory, TupleDomainFilterCache tupleDomainFilterCache) {
        this(typeManager, functionResolution, rowExpressionService, Objects.requireNonNull(config, "hiveClientConfig is null").isUseOrcColumnNames(), hdfsEnvironment, stats, config.getDomainCompactionThreshold(), orcFileTailSource, stripeMetadataSourceFactory, tupleDomainFilterCache);
    }

    public OrcSelectivePageSourceFactory(TypeManager typeManager, StandardFunctionResolution functionResolution, RowExpressionService rowExpressionService, boolean useOrcColumnNames, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats, int domainCompactionThreshold, OrcFileTailSource orcFileTailSource, StripeMetadataSourceFactory stripeMetadataSourceFactory, TupleDomainFilterCache tupleDomainFilterCache) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
        this.rowExpressionService = Objects.requireNonNull(rowExpressionService, "rowExpressionService is null");
        this.useOrcColumnNames = useOrcColumnNames;
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.domainCompactionThreshold = domainCompactionThreshold;
        this.orcFileTailSource = Objects.requireNonNull(orcFileTailSource, "orcFileTailCache is null");
        this.stripeMetadataSourceFactory = Objects.requireNonNull(stripeMetadataSourceFactory, "stripeMetadataSourceFactory is null");
        this.tupleDomainFilterCache = Objects.requireNonNull(tupleDomainFilterCache, "tupleDomainFilterCache is null");
    }

    @Override
    public Optional<? extends ConnectorPageSource> createPageSource(Configuration configuration, ConnectorSession session, HiveFileSplit fileSplit, Storage storage, List<HiveColumnHandle> columns, Map<Integer, String> prefilledValues, Map<Integer, HiveCoercer> coercers, Optional<BucketAdaptation> bucketAdaptation, List<Integer> outputColumns, TupleDomain<Subfield> domainPredicate, RowExpression remainingPredicate, DateTimeZone hiveStorageTimeZone, HiveFileContext hiveFileContext, Optional<EncryptionInformation> encryptionInformation, boolean appendRowNumberEnabled) {
        if (!OrcSerde.class.getName().equals(storage.getStorageFormat().getSerDe())) {
            return Optional.empty();
        }
        if (fileSplit.getFileSize() == 0L) {
            return Optional.of(new FixedPageSource((Iterable)ImmutableList.of()));
        }
        return Optional.of(OrcSelectivePageSourceFactory.createOrcPageSource(session, OrcEncoding.ORC, this.hdfsEnvironment, configuration, fileSplit, columns, prefilledValues, coercers, bucketAdaptation, outputColumns, domainPredicate, remainingPredicate, this.useOrcColumnNames, hiveStorageTimeZone, this.typeManager, this.functionResolution, this.rowExpressionService, HiveCommonSessionProperties.isOrcBloomFiltersEnabled((ConnectorSession)session), this.stats, this.domainCompactionThreshold, this.orcFileTailSource, this.stripeMetadataSourceFactory, hiveFileContext, this.tupleDomainFilterCache, encryptionInformation, DwrfEncryptionProvider.NO_ENCRYPTION, appendRowNumberEnabled));
    }

    public static ConnectorPageSource createOrcPageSource(ConnectorSession session, OrcEncoding orcEncoding, HdfsEnvironment hdfsEnvironment, Configuration configuration, HiveFileSplit fileSplit, List<HiveColumnHandle> columns, Map<Integer, String> prefilledValues, Map<Integer, HiveCoercer> coercers, Optional<BucketAdaptation> bucketAdaptation, List<Integer> outputColumns, TupleDomain<Subfield> domainPredicate, RowExpression remainingPredicate, boolean useOrcColumnNames, DateTimeZone hiveStorageTimeZone, TypeManager typeManager, StandardFunctionResolution functionResolution, RowExpressionService rowExpressionService, boolean orcBloomFiltersEnabled, FileFormatDataSourceStats stats, int domainCompactionThreshold, OrcFileTailSource orcFileTailSource, StripeMetadataSourceFactory stripeMetadataSourceFactory, HiveFileContext hiveFileContext, TupleDomainFilterCache tupleDomainFilterCache, Optional<EncryptionInformation> encryptionInformation, DwrfEncryptionProvider dwrfEncryptionProvider, boolean appendRowNumberEnabled) {
        Preconditions.checkArgument((domainCompactionThreshold >= 1 ? 1 : 0) != 0, (Object)"domainCompactionThreshold must be at least 1");
        HdfsOrcDataSource orcDataSource = OrcPageSourceFactoryUtils.getOrcDataSource(session, fileSplit, hdfsEnvironment, configuration, hiveFileContext, stats);
        Path path = new Path(fileSplit.getPath());
        DataSize maxMergeDistance = HiveCommonSessionProperties.getOrcMaxMergeDistance((ConnectorSession)session);
        DataSize tinyStripeThreshold = HiveCommonSessionProperties.getOrcTinyStripeThreshold((ConnectorSession)session);
        DataSize maxReadBlockSize = HiveCommonSessionProperties.getOrcMaxReadBlockSize((ConnectorSession)session);
        OrcReaderOptions orcReaderOptions = OrcReaderOptions.builder().withMaxMergeDistance(maxMergeDistance).withTinyStripeThreshold(tinyStripeThreshold).withMaxBlockSize(maxReadBlockSize).withZstdJniDecompressionEnabled(HiveCommonSessionProperties.isOrcZstdJniDecompressionEnabled((ConnectorSession)session)).withAppendRowNumber(appendRowNumberEnabled).build();
        HiveOrcAggregatedMemoryContext systemMemoryUsage = new HiveOrcAggregatedMemoryContext();
        try {
            Preconditions.checkArgument((!domainPredicate.isNone() ? 1 : 0) != 0, (Object)"Unexpected NONE domain");
            OrcReader reader = OrcPageSourceFactoryUtils.getOrcReader(orcEncoding, columns, useOrcColumnNames, orcFileTailSource, stripeMetadataSourceFactory, hiveFileContext, orcReaderOptions, encryptionInformation, dwrfEncryptionProvider, (OrcDataSource)orcDataSource, path);
            List<HiveColumnHandle> physicalColumns = HiveUtil.getPhysicalHiveColumnHandles(columns, useOrcColumnNames, reader.getTypes(), path);
            Map indexMapping = (Map)IntStream.range(0, columns.size()).boxed().collect(ImmutableMap.toImmutableMap(i -> ((HiveColumnHandle)((Object)((Object)columns.get((int)i)))).getHiveColumnIndex(), i -> ((HiveColumnHandle)((Object)((Object)physicalColumns.get((int)i)))).getHiveColumnIndex()));
            Map columnNames = (Map)physicalColumns.stream().collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getHiveColumnIndex, BaseHiveColumnHandle::getName));
            Map mappedCoercers = (Map)coercers.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> (Integer)indexMapping.get(entry.getKey()), Map.Entry::getValue));
            OrcPredicate orcPredicate = OrcSelectivePageSourceFactory.toOrcPredicate(domainPredicate, physicalColumns, mappedCoercers, typeManager, domainCompactionThreshold, orcBloomFiltersEnabled);
            ImmutableBiMap columnIndices = ImmutableBiMap.copyOf((Map)columnNames).inverse();
            Map<Integer, Map<Subfield, TupleDomainFilter>> tupleDomainFilters = OrcSelectivePageSourceFactory.toTupleDomainFilters(domainPredicate, (Map<String, Integer>)columnIndices, mappedCoercers, tupleDomainFilterCache);
            List outputIndices = (List)outputColumns.stream().map(indexMapping::get).collect(ImmutableList.toImmutableList());
            Map<Integer, List<Subfield>> requiredSubfields = OrcSelectivePageSourceFactory.collectRequiredSubfields(physicalColumns, outputIndices, tupleDomainFilters, remainingPredicate, (Map<String, Integer>)columnIndices, functionResolution, rowExpressionService, session);
            Map columnTypes = (Map)physicalColumns.stream().collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getHiveColumnIndex, column -> typeManager.getType(column.getTypeSignature())));
            Map typedPrefilledValues = Maps.transformEntries((Map)((Map)prefilledValues.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> (Integer)indexMapping.get(entry.getKey()), Map.Entry::getValue))), (hiveColumnIndex, value) -> HiveUtil.typedPartitionKey(value, (Type)columnTypes.get(hiveColumnIndex), (String)columnNames.get(hiveColumnIndex), hiveStorageTimeZone));
            BiMap inputs = (BiMap)IntStream.range(0, physicalColumns.size()).boxed().collect(ImmutableBiMap.toImmutableBiMap(i -> ((HiveColumnHandle)((Object)((Object)physicalColumns.get((int)i)))).getHiveColumnIndex(), Function.identity()));
            Map variableToInput = (Map)columnNames.keySet().stream().collect(ImmutableMap.toImmutableMap(hiveColumnIndex -> new VariableReferenceExpression(Optional.empty(), (String)columnNames.get(hiveColumnIndex), OrcSelectivePageSourceFactory.getColumnTypeFromTableSchema(coercers, columnTypes, hiveColumnIndex)), hiveColumnIndex -> new InputReferenceExpression(Optional.empty(), ((Integer)inputs.get(hiveColumnIndex)).intValue(), OrcSelectivePageSourceFactory.getColumnTypeFromTableSchema(coercers, columnTypes, hiveColumnIndex))));
            Optional<BucketAdapter> bucketAdapter = bucketAdaptation.map(adaptation -> new BucketAdapter(Arrays.stream(adaptation.getBucketColumnIndices()).map(indexMapping::get).map(arg_0 -> inputs.get(arg_0)).toArray(), adaptation.getBucketColumnHiveTypes(), adaptation.getTableBucketCount(), adaptation.getPartitionBucketCount(), adaptation.getBucketToKeep()));
            List<FilterFunction> filterFunctions = OrcSelectivePageSourceFactory.toFilterFunctions(RowExpressionNodeInliner.replaceExpression((RowExpression)remainingPredicate, (Map)variableToInput), bucketAdapter, session, rowExpressionService.getDeterminismEvaluator(), rowExpressionService.getPredicateCompiler());
            OrcSelectiveRecordReader recordReader = reader.createSelectiveRecordReader(columnTypes, outputIndices, tupleDomainFilters, filterFunctions, (Map)inputs.inverse(), requiredSubfields, typedPrefilledValues, Maps.transformValues((Map)mappedCoercers, Function.class::cast), orcPredicate, fileSplit.getStart(), fileSplit.getLength(), hiveStorageTimeZone, (OrcAggregatedMemoryContext)systemMemoryUsage, Optional.empty(), 1);
            return new OrcSelectivePageSource(recordReader, reader.getOrcDataSource(), systemMemoryUsage, stats, hiveFileContext.getStats());
        }
        catch (Exception e) {
            try {
                orcDataSource.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw OrcPageSourceFactoryUtils.mapToPrestoException(e, path, fileSplit);
        }
    }

    private static Type getColumnTypeFromTableSchema(Map<Integer, HiveCoercer> coercers, Map<Integer, Type> columnTypes, int hiveColumnIndex) {
        return coercers.containsKey(hiveColumnIndex) ? coercers.get(hiveColumnIndex).getToType() : columnTypes.get(hiveColumnIndex);
    }

    private static Map<Integer, List<Subfield>> collectRequiredSubfields(List<HiveColumnHandle> physicalColumns, List<Integer> outputColumns, Map<Integer, Map<Subfield, TupleDomainFilter>> tupleDomainFilters, RowExpression remainingPredicate, Map<String, Integer> columnIndices, StandardFunctionResolution functionResolution, RowExpressionService rowExpressionService, ConnectorSession session) {
        List<Subfield> prunedSubfields;
        int columnIndex;
        HashMap outputSubfields = new HashMap();
        physicalColumns.stream().filter(column -> outputColumns.contains(column.getHiveColumnIndex())).forEach(column -> {
            Set cfr_ignored_0 = outputSubfields.put(column.getHiveColumnIndex(), new HashSet(column.getRequiredSubfields()));
        });
        HashMap<Integer, Set> predicateSubfields = new HashMap<Integer, Set>();
        SubfieldExtractor subfieldExtractor = new SubfieldExtractor(functionResolution, rowExpressionService.getExpressionOptimizer(), session);
        remainingPredicate.accept((RowExpressionVisitor)new RequiredSubfieldsExtractor(subfieldExtractor), subfield -> predicateSubfields.computeIfAbsent((Integer)columnIndices.get(subfield.getRootName()), v -> new HashSet()).add(subfield));
        for (Map.Entry<Integer, Map<Subfield, TupleDomainFilter>> entry : tupleDomainFilters.entrySet()) {
            predicateSubfields.computeIfAbsent(entry.getKey(), v -> new HashSet()).addAll(entry.getValue().keySet());
        }
        HashMap<Integer, List<Subfield>> allSubfields = new HashMap<Integer, List<Subfield>>();
        for (Map.Entry entry : outputSubfields.entrySet()) {
            columnIndex = (Integer)entry.getKey();
            if (((Set)entry.getValue()).isEmpty()) continue;
            if (!predicateSubfields.containsKey(columnIndex)) {
                allSubfields.put(columnIndex, (List<Subfield>)ImmutableList.copyOf((Collection)((Collection)entry.getValue())));
                continue;
            }
            prunedSubfields = OrcSelectivePageSourceFactory.pruneSubfields((Set<Subfield>)ImmutableSet.builder().addAll((Iterable)entry.getValue()).addAll((Iterable)predicateSubfields.get(columnIndex)).build());
            if (prunedSubfields.size() == 1 && OrcSelectivePageSourceFactory.isEntireColumn(prunedSubfields.get(0))) continue;
            allSubfields.put(columnIndex, prunedSubfields);
        }
        for (Map.Entry entry : predicateSubfields.entrySet()) {
            columnIndex = (Integer)entry.getKey();
            if (outputSubfields.containsKey(columnIndex) || (prunedSubfields = OrcSelectivePageSourceFactory.pruneSubfields((Set)entry.getValue())).size() == 1 && OrcSelectivePageSourceFactory.isEntireColumn(prunedSubfields.get(0))) continue;
            allSubfields.put(columnIndex, prunedSubfields);
        }
        return allSubfields;
    }

    private static List<Subfield> pruneSubfields(Set<Subfield> subfields) {
        Verify.verify((!subfields.isEmpty() ? 1 : 0) != 0);
        return (List)subfields.stream().filter(subfield -> !OrcSelectivePageSourceFactory.prefixExists(subfield, subfields)).collect(ImmutableList.toImmutableList());
    }

    private static boolean prefixExists(Subfield subfield, Collection<Subfield> subfields) {
        return subfields.stream().anyMatch(path -> path.isPrefix(subfield));
    }

    private static Map<Integer, Map<Subfield, TupleDomainFilter>> toTupleDomainFilters(TupleDomain<Subfield> domainPredicate, Map<String, Integer> columnIndices, Map<Integer, HiveCoercer> coercers, TupleDomainFilterCache tupleDomainFilterCache) {
        Map filtersBySubfield = Maps.transformValues((Map)((Map)domainPredicate.getDomains().get()), tupleDomainFilterCache::getFilter);
        HashMap<Integer, Map> filtersByColumn = new HashMap<Integer, Map>();
        for (Map.Entry entry : filtersBySubfield.entrySet()) {
            Subfield subfield = (Subfield)entry.getKey();
            int columnIndex = columnIndices.get(subfield.getRootName());
            TupleDomainFilter filter = (TupleDomainFilter)entry.getValue();
            if (coercers.containsKey(columnIndex)) {
                filter = coercers.get(columnIndex).toCoercingFilter(filter, subfield);
            }
            filtersByColumn.computeIfAbsent(columnIndex, k -> new HashMap()).put(subfield, filter);
        }
        return ImmutableMap.copyOf(filtersByColumn);
    }

    private static boolean isEntireColumn(Subfield subfield) {
        return subfield.getPath().isEmpty();
    }

    private static OrcPredicate toOrcPredicate(TupleDomain<Subfield> domainPredicate, List<HiveColumnHandle> physicalColumns, Map<Integer, HiveCoercer> coercers, TypeManager typeManager, int domainCompactionThreshold, boolean orcBloomFiltersEnabled) {
        ImmutableList.Builder columnReferences = ImmutableList.builder();
        for (HiveColumnHandle column2 : physicalColumns) {
            if (column2.getColumnType() != BaseHiveColumnHandle.ColumnType.REGULAR) continue;
            Type type = typeManager.getType(column2.getTypeSignature());
            columnReferences.add((Object)new TupleDomainOrcPredicate.ColumnReference((Object)column2, column2.getHiveColumnIndex(), type));
        }
        ImmutableMap columnsByName = Maps.uniqueIndex(physicalColumns, BaseHiveColumnHandle::getName);
        TupleDomain entireColumnDomains = domainPredicate.transform(arg_0 -> OrcSelectivePageSourceFactory.lambda$toOrcPredicate$18((Map)columnsByName, arg_0)).transform(column -> coercers.containsKey(column.getHiveColumnIndex()) ? null : column);
        return new TupleDomainOrcPredicate(entireColumnDomains, (List)columnReferences.build(), orcBloomFiltersEnabled, Optional.of(domainCompactionThreshold));
    }

    private static List<FilterFunction> toFilterFunctions(RowExpression filter, Optional<BucketAdapter> bucketAdapter, ConnectorSession session, DeterminismEvaluator determinismEvaluator, PredicateCompiler predicateCompiler) {
        ImmutableList.Builder filterFunctions = ImmutableList.builder();
        bucketAdapter.map(predicate -> new FilterFunction(session.getSqlFunctionProperties(), true, (Predicate)predicate)).ifPresent(arg_0 -> ((ImmutableList.Builder)filterFunctions).add(arg_0));
        if (LogicalRowExpressions.TRUE_CONSTANT.equals((Object)filter)) {
            return filterFunctions.build();
        }
        DynamicFilters.DynamicFilterExtractResult extractDynamicFilterResult = DynamicFilters.extractDynamicFilters((RowExpression)filter);
        filter = LogicalRowExpressions.and((Collection)extractDynamicFilterResult.getStaticConjuncts());
        if (!HiveSessionProperties.isAdaptiveFilterReorderingEnabled(session)) {
            filterFunctions.add((Object)new FilterFunction(session.getSqlFunctionProperties(), determinismEvaluator.isDeterministic(filter), (Predicate)predicateCompiler.compilePredicate(session.getSqlFunctionProperties(), session.getSessionFunctions(), filter).get()));
            return filterFunctions.build();
        }
        List conjuncts = LogicalRowExpressions.extractConjuncts((RowExpression)filter);
        if (conjuncts.size() == 1) {
            filterFunctions.add((Object)new FilterFunction(session.getSqlFunctionProperties(), determinismEvaluator.isDeterministic(filter), (Predicate)predicateCompiler.compilePredicate(session.getSqlFunctionProperties(), session.getSessionFunctions(), filter).get()));
            return filterFunctions.build();
        }
        LinkedHashMap<Set, List> inputsToConjuncts = new LinkedHashMap<Set, List>();
        for (RowExpression conjunct : conjuncts) {
            inputsToConjuncts.computeIfAbsent(OrcSelectivePageSourceFactory.extractInputs(conjunct), k -> new ArrayList()).add(conjunct);
        }
        inputsToConjuncts.values().stream().map(expressions -> LogicalRowExpressions.binaryExpression((SpecialFormExpression.Form)SpecialFormExpression.Form.AND, (Collection)expressions)).map(predicate -> new FilterFunction(session.getSqlFunctionProperties(), determinismEvaluator.isDeterministic(predicate), (Predicate)predicateCompiler.compilePredicate(session.getSqlFunctionProperties(), session.getSessionFunctions(), predicate).get())).forEach(arg_0 -> ((ImmutableList.Builder)filterFunctions).add(arg_0));
        return filterFunctions.build();
    }

    private static Set<Integer> extractInputs(RowExpression expression) {
        ImmutableSet.Builder inputs = ImmutableSet.builder();
        expression.accept((RowExpressionVisitor)new InputReferenceBuilderVisitor(), (Object)inputs);
        return inputs.build();
    }

    private static String splitError(Throwable t, Path path, long start, long length) {
        return String.format("Error opening Hive split %s (offset=%s, length=%s): %s", path, start, length, t.getMessage());
    }

    private static /* synthetic */ HiveColumnHandle lambda$toOrcPredicate$18(Map columnsByName, Subfield subfield) {
        return OrcSelectivePageSourceFactory.isEntireColumn(subfield) ? (HiveColumnHandle)((Object)columnsByName.get(subfield.getRootName())) : null;
    }

    private static class BucketAdapter
    implements Predicate {
        public final int[] bucketColumns;
        public final int bucketToKeep;
        public final int tableBucketCount;
        public final int partitionBucketCount;
        private final List<TypeInfo> typeInfoList;

        public BucketAdapter(int[] bucketColumnIndices, List<HiveType> bucketColumnHiveTypes, int tableBucketCount, int partitionBucketCount, int bucketToKeep) {
            this.bucketColumns = Objects.requireNonNull(bucketColumnIndices, "bucketColumnIndices is null");
            this.bucketToKeep = bucketToKeep;
            this.typeInfoList = (List)Objects.requireNonNull(bucketColumnHiveTypes, "bucketColumnHiveTypes is null").stream().map(HiveType::getTypeInfo).collect(ImmutableList.toImmutableList());
            this.tableBucketCount = tableBucketCount;
            this.partitionBucketCount = partitionBucketCount;
        }

        public int[] getInputChannels() {
            return this.bucketColumns;
        }

        public boolean evaluate(SqlFunctionProperties properties, Page page, int position) {
            int bucket = HiveBucketing.getHiveBucket(this.tableBucketCount, this.typeInfoList, page, position);
            if ((bucket - this.bucketToKeep) % this.partitionBucketCount != 0) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("A row that is supposed to be in bucket %s is encountered. Only rows in bucket %s (modulo %s) are expected", bucket, this.bucketToKeep % this.partitionBucketCount, this.partitionBucketCount));
            }
            return bucket == this.bucketToKeep;
        }
    }

    private static class InputReferenceBuilderVisitor
    extends DefaultRowExpressionTraversalVisitor<ImmutableSet.Builder<Integer>> {
        private InputReferenceBuilderVisitor() {
        }

        public Void visitInputReference(InputReferenceExpression input, ImmutableSet.Builder<Integer> builder) {
            builder.add((Object)input.getField());
            return null;
        }
    }

    private static final class RequiredSubfieldsExtractor
    extends DefaultRowExpressionTraversalVisitor<Consumer<Subfield>> {
        private final SubfieldExtractor subfieldExtractor;

        public RequiredSubfieldsExtractor(SubfieldExtractor subfieldExtractor) {
            this.subfieldExtractor = Objects.requireNonNull(subfieldExtractor, "subfieldExtractor is null");
        }

        public Void visitCall(CallExpression call, Consumer<Subfield> context) {
            Optional subfield = this.subfieldExtractor.extract((RowExpression)call);
            if (subfield.isPresent()) {
                context.accept((Subfield)subfield.get());
                return null;
            }
            call.getArguments().forEach(argument -> {
                Void cfr_ignored_0 = (Void)argument.accept((RowExpressionVisitor)this, (Object)context);
            });
            return null;
        }

        public Void visitSpecialForm(SpecialFormExpression specialForm, Consumer<Subfield> context) {
            Optional subfield = this.subfieldExtractor.extract((RowExpression)specialForm);
            if (subfield.isPresent()) {
                context.accept((Subfield)subfield.get());
                return null;
            }
            specialForm.getArguments().forEach(argument -> {
                Void cfr_ignored_0 = (Void)argument.accept((RowExpressionVisitor)this, (Object)context);
            });
            return null;
        }

        public Void visitVariableReference(VariableReferenceExpression reference, Consumer<Subfield> context) {
            Optional subfield = this.subfieldExtractor.extract((RowExpression)reference);
            if (subfield.isPresent()) {
                context.accept((Subfield)subfield.get());
                return null;
            }
            return null;
        }
    }
}

