/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet;

import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveAggregatedPageSourceFactory;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveCommonSessionProperties;
import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.hive.HiveFileSplit;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.parquet.AggregatedParquetPageSource;
import com.facebook.presto.hive.parquet.HdfsParquetDataSource;
import com.facebook.presto.hive.parquet.ParquetPageSourceFactory;
import com.facebook.presto.hive.parquet.ParquetPageSourceFactoryUtils;
import com.facebook.presto.parquet.ParquetDataSource;
import com.facebook.presto.parquet.cache.ParquetMetadataSource;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.crypto.InternalFileDecryptor;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;

public class ParquetAggregatedPageSourceFactory
implements HiveAggregatedPageSourceFactory {
    private static final Set<String> PARQUET_SERDE_CLASS_NAMES = ImmutableSet.builder().add((Object)"org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe").add((Object)"parquet.hive.serde.ParquetHiveSerDe").build();
    private final TypeManager typeManager;
    private final StandardFunctionResolution functionResolution;
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats stats;
    private final ParquetMetadataSource parquetMetadataSource;

    @Inject
    public ParquetAggregatedPageSourceFactory(TypeManager typeManager, StandardFunctionResolution functionResolution, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats, ParquetMetadataSource parquetMetadataSource) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.parquetMetadataSource = Objects.requireNonNull(parquetMetadataSource, "parquetMetadataSource is null");
    }

    @Override
    public Optional<? extends ConnectorPageSource> createPageSource(Configuration configuration, ConnectorSession session, HiveFileSplit fileSplit, Storage storage, List<HiveColumnHandle> columns, HiveFileContext hiveFileContext, Optional<EncryptionInformation> encryptionInformation, boolean appendRowNumberEnabled) {
        if (!PARQUET_SERDE_CLASS_NAMES.contains(storage.getStorageFormat().getSerDe())) {
            return Optional.empty();
        }
        return Optional.of(ParquetAggregatedPageSourceFactory.createParquetPageSource(this.hdfsEnvironment, session, configuration, fileSplit, columns, this.typeManager, this.functionResolution, this.stats, hiveFileContext, this.parquetMetadataSource));
    }

    public static ConnectorPageSource createParquetPageSource(HdfsEnvironment hdfsEnvironment, ConnectorSession session, Configuration configuration, HiveFileSplit fileSplit, List<HiveColumnHandle> columns, TypeManager typeManager, StandardFunctionResolution functionResolution, FileFormatDataSourceStats stats, HiveFileContext hiveFileContext, ParquetMetadataSource parquetMetadataSource) {
        String user = session.getUser();
        boolean readMaskedValue = HiveCommonSessionProperties.getReadNullMaskedParquetEncryptedValue((ConnectorSession)session);
        HdfsParquetDataSource dataSource = null;
        Path path = new Path(fileSplit.getPath());
        try {
            HdfsParquetDataSource parquetDataSource;
            FSDataInputStream inputStream = hdfsEnvironment.getFileSystem(user, path, configuration).openFile(path, hiveFileContext);
            dataSource = parquetDataSource = HdfsParquetDataSource.buildHdfsParquetDataSource(inputStream, path, stats);
            Optional<InternalFileDecryptor> fileDecryptor = ParquetPageSourceFactory.createDecryptor(configuration, path);
            ParquetMetadata parquetMetadata = (ParquetMetadata)hdfsEnvironment.doAs(user, () -> ParquetAggregatedPageSourceFactory.lambda$createParquetPageSource$0(parquetMetadataSource, (ParquetDataSource)parquetDataSource, fileSplit, hiveFileContext, fileDecryptor, readMaskedValue));
            AggregatedParquetPageSource aggregatedParquetPageSource = new AggregatedParquetPageSource(columns, parquetMetadata, typeManager, functionResolution);
            return aggregatedParquetPageSource;
        }
        catch (Exception e) {
            throw ParquetPageSourceFactoryUtils.mapToPrestoException(e, path, fileSplit);
        }
        finally {
            try {
                if (dataSource != null) {
                    dataSource.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static /* synthetic */ ParquetMetadata lambda$createParquetPageSource$0(ParquetMetadataSource parquetMetadataSource, ParquetDataSource parquetDataSource, HiveFileSplit fileSplit, HiveFileContext hiveFileContext, Optional fileDecryptor, boolean readMaskedValue) throws IOException {
        return parquetMetadataSource.getParquetMetadata(parquetDataSource, fileSplit.getFileSize(), hiveFileContext.isCacheable(), hiveFileContext.getModificationTime(), fileDecryptor, readMaskedValue).getParquetMetadata();
    }
}

