/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet;

import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileSplit;
import com.facebook.presto.parquet.ParquetCorruptionException;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Strings;
import java.io.FileNotFoundException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.AccessControlException;
import org.apache.parquet.crypto.HiddenColumnException;

public class ParquetPageSourceFactoryUtils {
    private ParquetPageSourceFactoryUtils() {
    }

    public static PrestoException mapToPrestoException(Exception e, Path path, HiveFileSplit fileSplit) {
        if (e instanceof PrestoException) {
            throw (PrestoException)((Object)e);
        }
        if (e instanceof ParquetCorruptionException) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, (Throwable)e);
        }
        if (e instanceof AccessControlException) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, e.getMessage(), (Throwable)e);
        }
        if (Strings.nullToEmpty((String)e.getMessage()).trim().equals("Filesystem closed") || e instanceof FileNotFoundException) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, (Throwable)e);
        }
        String message = String.format("Error opening Hive split %s (offset=%s, length=%s): %s", path, fileSplit.getStart(), fileSplit.getLength(), e.getMessage());
        if (e.getClass().getSimpleName().equals("BlockMissingException")) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_MISSING_DATA, message, (Throwable)e);
        }
        if (e instanceof HiddenColumnException) {
            message = String.format("User does not have access to encryption key for encrypted column = %s. If returning 'null' for encrypted columns is acceptable to your query, please add 'set session hive.read_null_masked_parquet_encrypted_value_enabled=true' before your query", ((HiddenColumnException)e).getColumn());
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, message, (Throwable)e);
        }
        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, message, (Throwable)e);
    }
}

