/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.rule;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.BaseHiveColumnHandle;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveMetadata;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveTableProperties;
import com.facebook.presto.hive.HiveTransactionManager;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.TransactionalMetadata;
import com.facebook.presto.parquet.rule.ParquetDereferencePushDown;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class HiveParquetDereferencePushDown
extends ParquetDereferencePushDown {
    private final HiveTransactionManager transactionManager;

    public HiveParquetDereferencePushDown(HiveTransactionManager transactionManager, RowExpressionService rowExpressionService) {
        super(rowExpressionService);
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
    }

    protected boolean isParquetDereferenceEnabled(ConnectorSession session, TableHandle tableHandle) {
        Preconditions.checkArgument((boolean)(tableHandle.getConnectorHandle() instanceof HiveTableHandle), (Object)"Dereference pushdown into reader is not supported on a non-hive TableHandle");
        if (!HiveSessionProperties.isParquetDereferencePushdownEnabled(session)) {
            return false;
        }
        TransactionalMetadata metadata = this.transactionManager.get(tableHandle.getTransaction());
        Preconditions.checkState((boolean)(metadata instanceof HiveMetadata), (Object)"metadata must be HiveMetadata");
        return HiveStorageFormat.PARQUET == HiveTableProperties.getHiveStorageFormat(metadata.getTableMetadata(session, tableHandle.getConnectorHandle()).getProperties());
    }

    protected String getColumnName(ColumnHandle columnHandle) {
        return ((HiveColumnHandle)columnHandle).getName();
    }

    protected ColumnHandle createSubfieldColumnHandle(ColumnHandle baseColumnHandle, Subfield subfield, Type subfieldDataType, String subfieldColumnName) {
        if (baseColumnHandle == null) {
            throw new IllegalArgumentException("nested column [" + subfield + "]'s base column " + subfield.getRootName() + " is not present in table scan output");
        }
        HiveColumnHandle hiveBaseColumnHandle = (HiveColumnHandle)baseColumnHandle;
        Optional nestedColumnHiveType = hiveBaseColumnHandle.getHiveType().findChildType(subfield.getPath().stream().map(p -> ((Subfield.NestedField)p).getName()).collect(Collectors.toList()));
        if (!nestedColumnHiveType.isPresent()) {
            throw new IllegalArgumentException("nested column [" + subfield + "] type is not present in Hive column type");
        }
        return new HiveColumnHandle(subfieldColumnName, (HiveType)nestedColumnHiveType.get(), subfieldDataType.getTypeSignature(), -1, BaseHiveColumnHandle.ColumnType.SYNTHESIZED, Optional.of("nested column pushdown"), (List<Subfield>)ImmutableList.of((Object)subfield), Optional.empty());
    }
}

