/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.statistics;

import com.facebook.airlift.concurrent.BoundedExecutor;
import com.facebook.airlift.concurrent.ThreadPoolExecutorMBean;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.stats.DistributionStat;
import com.facebook.airlift.stats.TimeStat;
import com.facebook.presto.common.RuntimeUnit;
import com.facebook.presto.hive.CacheQuota;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.hive.HiveFileInfo;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.PartitionNameWithVersion;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.parquet.ParquetPageSourceFactory;
import com.facebook.presto.hive.statistics.ColumnQuickStats;
import com.facebook.presto.hive.statistics.PartitionQuickStats;
import com.facebook.presto.hive.statistics.QuickStatsBuilder;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.SchemaTableName;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.statistics.DoubleStatistics;
import org.apache.parquet.column.statistics.FloatStatistics;
import org.apache.parquet.column.statistics.IntStatistics;
import org.apache.parquet.column.statistics.LongStatistics;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class ParquetQuickStatsBuilder
implements QuickStatsBuilder {
    public static final Logger log = Logger.get(ParquetQuickStatsBuilder.class);
    private final Executor footerFetchExecutor;
    private final ThreadPoolExecutorMBean footerFetchExecutorMBean;
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats stats;
    private final long footerFetchTimeoutMillis;
    private final TimeStat footerFetchDuration = new TimeStat(TimeUnit.MILLISECONDS);
    private final DistributionStat fileCountPerPartition = new DistributionStat();
    private final DistributionStat footerByteSizeDistribution = new DistributionStat();

    public ParquetQuickStatsBuilder(FileFormatDataSourceStats stats, HdfsEnvironment hdfsEnvironment, HiveClientConfig hiveClientConfig) {
        this.stats = stats;
        this.hdfsEnvironment = hdfsEnvironment;
        this.footerFetchTimeoutMillis = hiveClientConfig.getParquetQuickStatsFileMetadataFetchTimeout().roundTo(TimeUnit.MILLISECONDS);
        ExecutorService coreExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"parquet-quick-stats-bg-fetch-%s"));
        this.footerFetchExecutor = new BoundedExecutor((Executor)coreExecutor, hiveClientConfig.getMaxConcurrentParquetQuickStatsCalls());
        this.footerFetchExecutorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)coreExecutor);
    }

    private static void processColumnMetadata(ParquetMetadata parquetMetadata, Map<ColumnPath, ColumnQuickStats<?>> rolledUpColStats) {
        List rowGroups = parquetMetadata.getBlocks();
        for (BlockMetaData rowGroup : rowGroups) {
            long rowCount = rowGroup.getRowCount();
            block17: for (ColumnChunkMetaData columnChunkMetaData : rowGroup.getColumns()) {
                ColumnQuickStats<Serializable> toMerge;
                Optional transformed;
                ColumnPath columnKey = columnChunkMetaData.getPath();
                if (columnKey.size() > 1) continue;
                String columnName = columnKey.toArray()[0];
                PrimitiveType columnPrimitiveType = columnChunkMetaData.getPrimitiveType();
                Statistics colStats = columnChunkMetaData.getStatistics();
                long nullsCount = colStats.getNumNulls();
                ColumnType mappedType = ColumnType.SLICE;
                switch (columnPrimitiveType.getPrimitiveTypeName()) {
                    case INT64: {
                        mappedType = ColumnType.LONG;
                        break;
                    }
                    case INT32: {
                        mappedType = ColumnType.INTEGER;
                        break;
                    }
                    case BOOLEAN: {
                        mappedType = ColumnType.BOOLEAN;
                        break;
                    }
                    case BINARY: {
                        mappedType = ColumnType.SLICE;
                        break;
                    }
                    case FLOAT: {
                        mappedType = ColumnType.FLOAT;
                        break;
                    }
                    case DOUBLE: {
                        mappedType = ColumnType.DOUBLE;
                        break;
                    }
                }
                if (columnPrimitiveType.getLogicalTypeAnnotation() != null && (transformed = columnPrimitiveType.getLogicalTypeAnnotation().accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<ColumnType>(){

                    public Optional<ColumnType> visit(LogicalTypeAnnotation.DateLogicalTypeAnnotation dateLogicalType) {
                        return Optional.of(ColumnType.DATE);
                    }

                    public Optional<ColumnType> visit(LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeLogicalType) {
                        return Optional.of(ColumnType.TIME);
                    }
                })).isPresent()) {
                    mappedType = (ColumnType)((Object)transformed.get());
                }
                switch (mappedType) {
                    case INTEGER: {
                        toMerge = rolledUpColStats.getOrDefault(columnKey, new ColumnQuickStats(columnName, (Type)((Object)Integer.class)));
                        IntStatistics asIntegerStats = (IntStatistics)colStats;
                        toMerge.setMinValue(Integer.valueOf(asIntegerStats.getMin()));
                        toMerge.setMaxValue(Integer.valueOf(asIntegerStats.getMax()));
                        toMerge.addToNullsCount(nullsCount);
                        toMerge.addToRowCount(rowCount);
                        rolledUpColStats.put(columnKey, toMerge);
                        continue block17;
                    }
                    case LONG: {
                        toMerge = rolledUpColStats.getOrDefault(columnKey, new ColumnQuickStats(columnName, (Type)((Object)Long.class)));
                        LongStatistics asLongStats = (LongStatistics)colStats;
                        toMerge.setMinValue(Long.valueOf(asLongStats.getMin()));
                        toMerge.setMaxValue(Long.valueOf(asLongStats.getMax()));
                        toMerge.addToNullsCount(nullsCount);
                        toMerge.addToRowCount(rowCount);
                        rolledUpColStats.put(columnKey, toMerge);
                        continue block17;
                    }
                    case DOUBLE: {
                        toMerge = rolledUpColStats.getOrDefault(columnKey, new ColumnQuickStats(columnName, (Type)((Object)Double.class)));
                        DoubleStatistics asDoubleStats = (DoubleStatistics)colStats;
                        toMerge.setMinValue(Double.valueOf(asDoubleStats.getMin()));
                        toMerge.setMaxValue(Double.valueOf(asDoubleStats.getMax()));
                        toMerge.addToNullsCount(nullsCount);
                        toMerge.addToRowCount(rowCount);
                        rolledUpColStats.put(columnKey, toMerge);
                        continue block17;
                    }
                    case FLOAT: {
                        toMerge = rolledUpColStats.getOrDefault(columnKey, new ColumnQuickStats(columnName, (Type)((Object)Float.class)));
                        FloatStatistics asFloatStats = (FloatStatistics)colStats;
                        toMerge.setMinValue(Float.valueOf(asFloatStats.getMin()));
                        toMerge.setMaxValue(Float.valueOf(asFloatStats.getMax()));
                        toMerge.addToNullsCount(nullsCount);
                        toMerge.addToRowCount(rowCount);
                        rolledUpColStats.put(columnKey, toMerge);
                        continue block17;
                    }
                    case BOOLEAN: {
                        toMerge = rolledUpColStats.getOrDefault(columnKey, new ColumnQuickStats(columnName, (Type)((Object)Boolean.class)));
                        toMerge.addToNullsCount(nullsCount);
                        toMerge.addToRowCount(rowCount);
                        rolledUpColStats.put(columnKey, toMerge);
                        continue block17;
                    }
                    case DATE: {
                        toMerge = rolledUpColStats.getOrDefault(columnKey, new ColumnQuickStats(columnName, (Type)((Object)ChronoLocalDate.class)));
                        IntStatistics asIntStats = (IntStatistics)colStats;
                        toMerge.setMinValue(LocalDate.ofEpochDay(asIntStats.getMin()));
                        toMerge.setMaxValue(LocalDate.ofEpochDay(asIntStats.getMax()));
                        toMerge.addToNullsCount(nullsCount);
                        toMerge.addToRowCount(rowCount);
                        rolledUpColStats.put(columnKey, toMerge);
                        continue block17;
                    }
                }
                toMerge = rolledUpColStats.getOrDefault(columnKey, new ColumnQuickStats(columnName, (Type)((Object)Slice.class)));
                toMerge.addToNullsCount(nullsCount);
                toMerge.addToRowCount(rowCount);
                rolledUpColStats.put(columnKey, toMerge);
            }
        }
    }

    @Managed
    @Nested
    public TimeStat getFooterFetchDuration() {
        return this.footerFetchDuration;
    }

    @Managed
    @Nested
    public DistributionStat getFooterByteSizeDistribution() {
        return this.footerByteSizeDistribution;
    }

    @Managed
    @Nested
    public DistributionStat getFileCountPerPartitionDistribution() {
        return this.fileCountPerPartition;
    }

    @Managed
    @Nested
    public ThreadPoolExecutorMBean getExecutor() {
        return this.footerFetchExecutorMBean;
    }

    @Override
    public PartitionQuickStats buildQuickStats(ConnectorSession session, SemiTransactionalHiveMetastore metastore, SchemaTableName table, MetastoreContext metastoreContext, String partitionId, Iterator<HiveFileInfo> files) {
        StorageFormat storageFormat;
        Objects.requireNonNull(session);
        Objects.requireNonNull(metastore);
        Objects.requireNonNull(table);
        Objects.requireNonNull(metastoreContext);
        Objects.requireNonNull(partitionId);
        Objects.requireNonNull(files);
        if (!files.hasNext()) {
            return PartitionQuickStats.EMPTY;
        }
        if (HivePartition.UNPARTITIONED_ID.getPartitionName().equals(partitionId)) {
            Table resolvedTable = (Table)metastore.getTable(metastoreContext, table.getSchemaName(), table.getTableName()).get();
            storageFormat = resolvedTable.getStorage().getStorageFormat();
        } else {
            Partition partition = (Partition)((Optional)metastore.getPartitionsByNames(metastoreContext, table.getSchemaName(), table.getTableName(), (List)ImmutableList.of((Object)new PartitionNameWithVersion(partitionId, Optional.empty()))).get(partitionId)).get();
            storageFormat = partition.getStorage().getStorageFormat();
        }
        if (!ParquetPageSourceFactory.PARQUET_SERDE_CLASS_NAMES.contains(storageFormat.getSerDe())) {
            return PartitionQuickStats.EMPTY;
        }
        ArrayList<CompletableFuture<ParquetMetadata>> footerFetchCompletableFutures = new ArrayList<CompletableFuture<ParquetMetadata>>();
        int filesCount = 0;
        while (files.hasNext()) {
            HiveFileInfo file = files.next();
            ++filesCount;
            Path path = file.getPath();
            long fileSize = file.getLength();
            HiveFileContext hiveFileContext = new HiveFileContext(true, CacheQuota.NO_CACHE_CONSTRAINTS, Optional.empty(), OptionalLong.of(fileSize), OptionalLong.empty(), OptionalLong.empty(), file.getFileModifiedTime(), false);
            HdfsContext hdfsContext = new HdfsContext(session, table.getSchemaName(), table.getTableName());
            Configuration configuration = this.hdfsEnvironment.getConfiguration(hdfsContext, path);
            footerFetchCompletableFutures.add(CompletableFuture.supplyAsync(() -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }, this.footerFetchExecutor));
        }
        session.getRuntimeStats().addMetricValue(String.format("ParquetQuickStatsBuilder/FileCount/%s/%s", table.getTableName(), partitionId), RuntimeUnit.NONE, (long)filesCount);
        this.fileCountPerPartition.add((long)filesCount);
        HashMap rolledUpColStats = new HashMap();
        try {
            CompletableFuture<Void> overallCompletableFuture = CompletableFuture.allOf(footerFetchCompletableFutures.toArray(new CompletableFuture[0]));
            overallCompletableFuture.get(this.footerFetchTimeoutMillis, TimeUnit.MILLISECONDS);
            for (CompletableFuture completableFuture : footerFetchCompletableFutures) {
                ParquetMetadata parquetMetadata = (ParquetMetadata)completableFuture.get();
                ParquetQuickStatsBuilder.processColumnMetadata(parquetMetadata, rolledUpColStats);
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error((Throwable)e, "Failed to read/build stats from parquet footer");
            throw new RuntimeException(e);
        }
        if (rolledUpColStats.isEmpty()) {
            return PartitionQuickStats.EMPTY;
        }
        return new PartitionQuickStats(partitionId, rolledUpColStats.values(), filesCount);
    }

    static enum ColumnType {
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE,
        SLICE,
        DATE,
        TIME,
        BOOLEAN;

    }
}

