/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.hive.orc.OrcConf;
import com.facebook.presto.hadoop.FileSystemFactory;
import com.facebook.presto.hive.CopyOnFirstWriteConfiguration;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.mapred.JobConf;
import org.apache.orc.OrcConf;

public final class ConfigurationUtils {
    public static final String PAGE_FILE_COMPRESSION = "pagefile.output.compression";
    private static final Configuration INITIAL_CONFIGURATION;

    private ConfigurationUtils() {
    }

    public static Configuration getInitialConfiguration() {
        return ConfigurationUtils.copy(INITIAL_CONFIGURATION);
    }

    public static Configuration copy(Configuration configuration) {
        if (configuration instanceof CopyOnFirstWriteConfiguration) {
            return new CopyOnFirstWriteConfiguration(ConfigurationUtils.copy(((CopyOnFirstWriteConfiguration)configuration).getConfig()));
        }
        Configuration copy = new Configuration(false);
        ConfigurationUtils.copy(configuration, copy);
        return copy;
    }

    public static void copy(Configuration from, Configuration to) {
        for (Map.Entry entry : from) {
            to.set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static JobConf toJobConf(Configuration conf) {
        if (conf instanceof JobConf) {
            return (JobConf)conf;
        }
        return new JobConf(conf);
    }

    public static JobConf configureCompression(Configuration config, HiveCompressionCodec compression) {
        JobConf result;
        if (config instanceof FileSystemFactory) {
            Preconditions.checkArgument((boolean)(config instanceof JobConf), (String)"config is not an instance of JobConf: %s", config.getClass());
            result = (JobConf)config;
        } else {
            result = new JobConf(false);
            ConfigurationUtils.copy(config, (Configuration)result);
        }
        ConfigurationUtils.setCompressionProperties((Configuration)result, compression);
        return result;
    }

    private static void setCompressionProperties(Configuration config, HiveCompressionCodec compression) {
        boolean compressed = compression != HiveCompressionCodec.NONE;
        config.setBoolean(HiveConf.ConfVars.COMPRESSRESULT.varname, compressed);
        config.setBoolean("mapred.output.compress", compressed);
        config.setBoolean("mapreduce.output.fileoutputformat.compress", compressed);
        com.facebook.hive.orc.OrcConf.setVar((Configuration)config, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_COMPRESSION, (String)compression.getOrcCompressionKind().name());
        OrcConf.COMPRESS.setString(config, compression.getOrcCompressionKind().name());
        if (compression.getCodec().isPresent()) {
            config.set("mapred.output.compression.codec", compression.getCodec().get().getName());
            config.set("mapreduce.output.fileoutputformat.compress.codec", compression.getCodec().get().getName());
        } else {
            config.unset("mapred.output.compression.codec");
            config.unset("mapreduce.output.fileoutputformat.compress.codec");
        }
        compression.getParquetCompressionCodec().ifPresent(codec -> config.set("parquet.compression", codec.name()));
        config.set("mapreduce.output.fileoutputformat.compress.type", SequenceFile.CompressionType.BLOCK.toString());
        config.set(PAGE_FILE_COMPRESSION, compression.name());
    }

    static {
        Configuration.addDefaultResource((String)"hdfs-default.xml");
        Configuration.addDefaultResource((String)"hdfs-site.xml");
        INITIAL_CONFIGURATION = new Configuration(false);
        Configuration defaultConfiguration = new Configuration();
        ConfigurationUtils.copy(defaultConfiguration, INITIAL_CONFIGURATION);
    }
}

