/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.hive.ql.exec.FooterBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;

public class FooterAwareRecordReader<K extends WritableComparable, V extends Writable>
implements RecordReader<K, V> {
    private final RecordReader<K, V> delegate;
    private final JobConf job;
    private final FooterBuffer footerBuffer = new FooterBuffer();

    public FooterAwareRecordReader(RecordReader<K, V> delegate, int footerCount, JobConf job) throws IOException {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.job = Objects.requireNonNull(job, "job is null");
        Preconditions.checkArgument((footerCount > 0 ? 1 : 0) != 0, (Object)"footerCount is expected to be positive");
        this.footerBuffer.initializeBuffer(job, delegate, footerCount, (WritableComparable)delegate.createKey(), (Writable)delegate.createValue());
    }

    public boolean next(K key, V value) throws IOException {
        return this.footerBuffer.updateBuffer(this.job, this.delegate, key, value);
    }

    public K createKey() {
        return (K)((WritableComparable)this.delegate.createKey());
    }

    public V createValue() {
        return (V)((Writable)this.delegate.createValue());
    }

    public long getPos() throws IOException {
        return this.delegate.getPos();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public float getProgress() throws IOException {
        return this.delegate.getProgress();
    }
}

