/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.RuntimeUnit;
import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.ForCachingDirectoryLister;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveDirectoryContext;
import com.facebook.presto.hive.HiveFileInfo;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.hadoop.fs.Path;
import org.openjdk.jol.info.ClassLayout;
import org.weakref.jmx.Managed;

public class CachingDirectoryLister
implements DirectoryLister {
    private final Cache<String, ValueHolder> cache;
    private final CachedTableChecker cachedTableChecker;
    private final DirectoryLister delegate;

    @Inject
    public CachingDirectoryLister(@ForCachingDirectoryLister DirectoryLister delegate, HiveClientConfig hiveClientConfig) {
        this(delegate, hiveClientConfig.getFileStatusCacheExpireAfterWrite(), hiveClientConfig.getFileStatusCacheMaxRetainedSize(), hiveClientConfig.getFileStatusCacheTables());
    }

    public CachingDirectoryLister(DirectoryLister delegate, Duration expireAfterWrite, DataSize maxSize, List<String> tables) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.cache = CacheBuilder.newBuilder().maximumWeight(maxSize.toBytes()).weigher((key, value) -> Math.toIntExact((long)key.length() + value.getRetainedSizeInBytes())).expireAfterWrite(expireAfterWrite.toMillis(), TimeUnit.MILLISECONDS).recordStats().build();
        this.cachedTableChecker = new CachedTableChecker(Objects.requireNonNull(tables, "tables is null"));
    }

    @Override
    public Iterator<HiveFileInfo> list(ExtendedFileSystem fileSystem, Table table, Path path, Optional<Partition> partition, NamenodeStats namenodeStats, HiveDirectoryContext hiveDirectoryContext) {
        ValueHolder value;
        RuntimeStats runtimeStats = hiveDirectoryContext.getRuntimeStats();
        long startTime = System.nanoTime();
        if (hiveDirectoryContext.isCacheable() && (value = (ValueHolder)Optional.ofNullable(this.cache.getIfPresent((Object)path.toString())).orElse(null)) != null) {
            List<HiveFileInfo> files = value.getFiles();
            runtimeStats.addMetricValue("directoryListingCacheHit", RuntimeUnit.NONE, 1L);
            runtimeStats.addMetricValue("directoryListingTimeNanos", RuntimeUnit.NANO, System.nanoTime() - startTime);
            runtimeStats.addMetricValue("filesReadCount", RuntimeUnit.NONE, (long)files.size());
            return files.iterator();
        }
        runtimeStats.addMetricValue("directoryListingCacheMiss", RuntimeUnit.NONE, 1L);
        Iterator<HiveFileInfo> iterator = this.delegate.list(fileSystem, table, path, partition, namenodeStats, hiveDirectoryContext);
        runtimeStats.addMetricValue("directoryListingTimeNanos", RuntimeUnit.NANO, System.nanoTime() - startTime);
        if (hiveDirectoryContext.isCacheable() && this.cachedTableChecker.isCachedTable(table.getSchemaTableName())) {
            return this.fileCountTrackingIterator(iterator, path, runtimeStats, true);
        }
        return this.fileCountTrackingIterator(iterator, path, runtimeStats, false);
    }

    private Iterator<HiveFileInfo> fileCountTrackingIterator(final Iterator<HiveFileInfo> iterator, final Path path, final RuntimeStats runtimeStats, final boolean enableCaching) {
        return new Iterator<HiveFileInfo>(){
            private final List<HiveFileInfo> files = new ArrayList<HiveFileInfo>();

            @Override
            public boolean hasNext() {
                boolean hasNext = iterator.hasNext();
                if (!hasNext) {
                    runtimeStats.addMetricValue("filesReadCount", RuntimeUnit.NONE, (long)this.files.size());
                    if (enableCaching) {
                        CachingDirectoryLister.this.cache.put((Object)path.toString(), (Object)new ValueHolder(this.files));
                    }
                }
                return hasNext;
            }

            @Override
            public HiveFileInfo next() {
                HiveFileInfo next = (HiveFileInfo)iterator.next();
                this.files.add(next);
                return next;
            }
        };
    }

    public void invalidateDirectoryListCache(Optional<String> directoryPath) {
        if (directoryPath.isPresent()) {
            if (directoryPath.get().isEmpty()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Directory path can not be a empty string");
            }
            ValueHolder value = (ValueHolder)this.cache.getIfPresent((Object)directoryPath.get());
            if (value == null) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Given directory path is not cached : " + directoryPath);
            }
            this.cache.invalidate((Object)directoryPath.get());
        } else {
            this.flushCache();
        }
    }

    @Managed
    public void flushCache() {
        this.cache.invalidateAll();
    }

    @Managed
    public Double getHitRate() {
        return this.cache.stats().hitRate();
    }

    @Managed
    public Double getMissRate() {
        return this.cache.stats().missRate();
    }

    @Managed
    public long getHitCount() {
        return this.cache.stats().hitCount();
    }

    @Managed
    public long getMissCount() {
        return this.cache.stats().missCount();
    }

    @Managed
    public long getRequestCount() {
        return this.cache.stats().requestCount();
    }

    @Managed
    public long getEvictionCount() {
        return this.cache.stats().evictionCount();
    }

    @Managed
    public long getSize() {
        return this.cache.size();
    }

    private static class CachedTableChecker {
        private final Set<SchemaTableName> cachedTableNames;
        private final boolean cacheAllTables;

        public CachedTableChecker(List<String> cachedTables) {
            this.cacheAllTables = cachedTables.contains("*");
            if (this.cacheAllTables) {
                Preconditions.checkArgument((cachedTables.size() == 1 ? 1 : 0) != 0, (Object)"Only '*' is expected when caching all tables");
                this.cachedTableNames = ImmutableSet.of();
            } else {
                this.cachedTableNames = (Set)cachedTables.stream().map(SchemaTableName::valueOf).collect(ImmutableSet.toImmutableSet());
            }
        }

        public boolean isCachedTable(SchemaTableName schemaTableName) {
            return this.cacheAllTables || this.cachedTableNames.contains(schemaTableName);
        }
    }

    private static class ValueHolder {
        private static final long INSTANCE_SIZE = ClassLayout.parseClass(ValueHolder.class).instanceSize();
        private final List<HiveFileInfo> files;

        public ValueHolder(List<HiveFileInfo> files) {
            this.files = ImmutableList.copyOf((Collection)Objects.requireNonNull(files, "files is null"));
        }

        public List<HiveFileInfo> getFiles() {
            return this.files;
        }

        public long getRetainedSizeInBytes() {
            return INSTANCE_SIZE + this.files.stream().map(HiveFileInfo::getRetainedSizeInBytes).reduce(0L, Long::sum);
        }
    }
}

