/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.hive.CachingDirectoryLister;
import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.procedure.Procedure;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;

public class DirectoryListCacheInvalidationProcedure
implements Provider<Procedure> {
    private static final MethodHandle CACHE_DATA_INVALIDATION = MethodHandleUtil.methodHandle(DirectoryListCacheInvalidationProcedure.class, (String)"directoryListCacheInvalidation", (Class[])new Class[]{ConnectorSession.class, String.class});
    private final DirectoryLister directoryLister;

    @Inject
    public DirectoryListCacheInvalidationProcedure(DirectoryLister directoryLister) {
        this.directoryLister = Objects.requireNonNull(directoryLister, "directoryLister is null");
    }

    public Procedure get() {
        return new Procedure("system", "invalidate_directory_list_cache", (List)ImmutableList.of((Object)new Procedure.Argument("directory_path", "varchar", false, null)), CACHE_DATA_INVALIDATION.bindTo(this));
    }

    public void directoryListCacheInvalidation(ConnectorSession session, String directoryPath) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doInvalidateDirectoryListCache(session, Optional.ofNullable(directoryPath));
        }
    }

    private void doInvalidateDirectoryListCache(ConnectorSession session, Optional<String> directoryPath) {
        if (!HiveSessionProperties.isUseListDirectoryCache(session)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Directory list cache is not enabled on this catalog");
        }
        CachingDirectoryLister cachingDirectoryLister = (CachingDirectoryLister)this.directoryLister;
        cachingDirectoryLister.invalidateDirectoryListCache(directoryPath);
    }
}

