/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.BucketFunctionType;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.spi.BucketFunction;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class HiveBucketFunction
implements BucketFunction {
    private final int bucketCount;
    private final BucketFunctionType bucketFunctionType;
    private final Optional<List<TypeInfo>> typeInfos;
    private final Optional<List<Type>> types;
    private final boolean useLegacyTimestampBucketing;

    public static HiveBucketFunction createHiveCompatibleBucketFunction(int bucketCount, List<HiveType> hiveTypes, boolean useLegacyTimestampBucketing) {
        return new HiveBucketFunction(bucketCount, BucketFunctionType.HIVE_COMPATIBLE, Optional.of(hiveTypes), Optional.empty(), useLegacyTimestampBucketing);
    }

    public static HiveBucketFunction createPrestoNativeBucketFunction(int bucketCount, List<Type> types, boolean useLegacyTimestampBucketing) {
        return new HiveBucketFunction(bucketCount, BucketFunctionType.PRESTO_NATIVE, Optional.empty(), Optional.of(types), useLegacyTimestampBucketing);
    }

    private HiveBucketFunction(int bucketCount, BucketFunctionType bucketFunctionType, Optional<List<HiveType>> hiveTypes, Optional<List<Type>> types, boolean useLegacyTimestampBucketing) {
        this.bucketCount = bucketCount;
        this.bucketFunctionType = Objects.requireNonNull(bucketFunctionType, "bucketFunctionType is null");
        Preconditions.checkArgument((bucketFunctionType.equals((Object)BucketFunctionType.HIVE_COMPATIBLE) && hiveTypes.isPresent() || bucketFunctionType.equals((Object)BucketFunctionType.PRESTO_NATIVE) && types.isPresent() ? 1 : 0) != 0, (Object)("The corresponding type list is not present for bucketFunctionType " + bucketFunctionType));
        this.typeInfos = hiveTypes.map(list -> (ImmutableList)list.stream().map(HiveType::getTypeInfo).collect(ImmutableList.toImmutableList()));
        this.types = Objects.requireNonNull(types, "types is null");
        this.useLegacyTimestampBucketing = useLegacyTimestampBucketing;
    }

    public int getBucket(Page page, int position) {
        switch (this.bucketFunctionType) {
            case HIVE_COMPATIBLE: {
                return HiveBucketing.getHiveBucket(this.bucketCount, this.typeInfos.get(), page, position, this.useLegacyTimestampBucketing);
            }
            case PRESTO_NATIVE: {
                return HiveBucketing.getBucket(this.bucketCount, this.types.get(), page, position);
            }
        }
        throw new IllegalArgumentException("Unsupported bucket function type " + this.bucketFunctionType);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bucketCount", this.bucketCount).add("bucketFunctionType", (Object)this.bucketFunctionType).add("types", this.bucketFunctionType.equals((Object)BucketFunctionType.HIVE_COMPATIBLE) ? this.typeInfos.get() : this.types.get()).toString();
    }
}

