/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.hive.BaseHiveColumnHandle;
import com.facebook.presto.hive.BucketFunctionType;
import com.facebook.presto.hive.HiveBucketHandle;
import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public final class HiveBucketing {
    private static final Set<HiveType> SUPPORTED_TYPES_FOR_BUCKET_FILTER = ImmutableSet.of((Object)HiveType.HIVE_BYTE, (Object)HiveType.HIVE_SHORT, (Object)HiveType.HIVE_INT, (Object)HiveType.HIVE_LONG, (Object)HiveType.HIVE_BOOLEAN, (Object)HiveType.HIVE_STRING, (Object[])new HiveType[0]);

    private HiveBucketing() {
    }

    public static int getVirtualBucketNumber(int bucketCount, Path path) {
        return (HiveBucketing.hashBytes(0, Slices.utf8Slice((String)path.toString())) & Integer.MAX_VALUE) % bucketCount;
    }

    public static int getBucket(int bucketCount, List<Type> types, Page page, int position) {
        return (HiveBucketing.getHashCode(types, page, position) & Integer.MAX_VALUE) % bucketCount;
    }

    public static int getHiveBucket(int bucketCount, List<TypeInfo> types, Page page, int position, boolean useLegacyTimestampBucketing) {
        return (HiveBucketing.getBucketHashCode(types, page, position, useLegacyTimestampBucketing) & Integer.MAX_VALUE) % bucketCount;
    }

    public static int getHiveBucket(int bucketCount, List<TypeInfo> types, Object[] values, boolean useLegacyTimestampBucketing) {
        return (HiveBucketing.getBucketHashCode(types, values, useLegacyTimestampBucketing) & Integer.MAX_VALUE) % bucketCount;
    }

    private static int getHashCode(List<Type> types, Page page, int position) {
        Preconditions.checkArgument((types.size() == page.getChannelCount() ? 1 : 0) != 0);
        int result = 0;
        for (int i = 0; i < page.getChannelCount(); ++i) {
            int fieldHash = (int)TypeUtils.hashPosition((Type)types.get(i), (Block)page.getBlock(i), (int)position);
            result = result * 31 + fieldHash;
        }
        return result;
    }

    private static int getBucketHashCode(List<TypeInfo> types, Page page, int position, boolean useLegacyTimestampBucketing) {
        Preconditions.checkArgument((types.size() == page.getChannelCount() ? 1 : 0) != 0);
        int result = 0;
        for (int i = 0; i < page.getChannelCount(); ++i) {
            int fieldHash = HiveBucketing.hash(types.get(i), page.getBlock(i), position, useLegacyTimestampBucketing);
            result = result * 31 + fieldHash;
        }
        return result;
    }

    private static int getBucketHashCode(List<TypeInfo> types, Object[] values, boolean useLegacyTimestampBucketing) {
        Preconditions.checkArgument((types.size() == values.length ? 1 : 0) != 0);
        int result = 0;
        for (int i = 0; i < values.length; ++i) {
            int fieldHash = HiveBucketing.hash(types.get(i), values[i], useLegacyTimestampBucketing);
            result = result * 31 + fieldHash;
        }
        return result;
    }

    private static int hash(TypeInfo type, Block block, int position, boolean useLegacyTimestampBucketing) {
        if (block.isNull(position)) {
            return 0;
        }
        switch (type.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo typeInfo = (PrimitiveTypeInfo)type;
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = typeInfo.getPrimitiveCategory();
                Type prestoType = Objects.requireNonNull(HiveType.getPrimitiveType((PrimitiveTypeInfo)typeInfo));
                switch (primitiveCategory) {
                    case BOOLEAN: {
                        return prestoType.getBoolean(block, position) ? 1 : 0;
                    }
                    case BYTE: {
                        return SignedBytes.checkedCast((long)prestoType.getLong(block, position));
                    }
                    case SHORT: {
                        return Shorts.checkedCast((long)prestoType.getLong(block, position));
                    }
                    case INT: {
                        return Math.toIntExact(prestoType.getLong(block, position));
                    }
                    case LONG: {
                        long bigintValue = prestoType.getLong(block, position);
                        return (int)(bigintValue >>> 32 ^ bigintValue);
                    }
                    case FLOAT: {
                        return (int)prestoType.getLong(block, position);
                    }
                    case DOUBLE: {
                        long doubleValue = Double.doubleToLongBits(prestoType.getDouble(block, position));
                        return (int)(doubleValue >>> 32 ^ doubleValue);
                    }
                    case STRING: {
                        return HiveBucketing.hashBytes(0, prestoType.getSlice(block, position));
                    }
                    case VARCHAR: {
                        return HiveBucketing.hashBytes(1, prestoType.getSlice(block, position));
                    }
                    case DATE: {
                        long days = prestoType.getLong(block, position);
                        return Math.toIntExact(days);
                    }
                    case TIMESTAMP: {
                        long millisSinceEpoch = prestoType.getLong(block, position);
                        return HiveBucketing.getHashForTimestamp(millisSinceEpoch, useLegacyTimestampBucketing);
                    }
                }
                throw new UnsupportedOperationException("Computation of Hive bucket hashCode is not supported for Hive primitive category: " + primitiveCategory.toString() + ".");
            }
            case LIST: {
                Block elementsBlock = block.getBlock(position);
                return HiveBucketing.hashOfList((ListTypeInfo)type, elementsBlock, useLegacyTimestampBucketing);
            }
            case MAP: {
                Block elementsBlock = block.getBlock(position);
                return HiveBucketing.hashOfMap((MapTypeInfo)type, elementsBlock, useLegacyTimestampBucketing);
            }
        }
        throw new UnsupportedOperationException("Computation of Hive bucket hashCode is not supported for Hive category: " + type.getCategory().toString() + ".");
    }

    private static int hash(TypeInfo type, Object value, boolean useLegacyTimestampBucketing) {
        if (value == null) {
            return 0;
        }
        switch (type.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo typeInfo = (PrimitiveTypeInfo)type;
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = typeInfo.getPrimitiveCategory();
                Type prestoType = Objects.requireNonNull(HiveType.getPrimitiveType((PrimitiveTypeInfo)typeInfo));
                switch (primitiveCategory) {
                    case BOOLEAN: {
                        return (Boolean)value != false ? 1 : 0;
                    }
                    case BYTE: {
                        return SignedBytes.checkedCast((long)((Long)value));
                    }
                    case SHORT: {
                        return Shorts.checkedCast((long)((Long)value));
                    }
                    case INT: {
                        return Math.toIntExact((Long)value);
                    }
                    case LONG: {
                        long bigintValue = (Long)value;
                        return (int)(bigintValue >>> 32 ^ bigintValue);
                    }
                    case FLOAT: {
                        return (int)((Long)value).longValue();
                    }
                    case DOUBLE: {
                        long doubleValue = Double.doubleToLongBits((Double)value);
                        return (int)(doubleValue >>> 32 ^ doubleValue);
                    }
                    case STRING: {
                        return HiveBucketing.hashBytes(0, (Slice)value);
                    }
                    case VARCHAR: {
                        return HiveBucketing.hashBytes(1, (Slice)value);
                    }
                    case DATE: {
                        long days = (Long)value;
                        return Math.toIntExact(days);
                    }
                    case TIMESTAMP: {
                        long millisSinceEpoch = (Long)value;
                        return HiveBucketing.getHashForTimestamp(millisSinceEpoch, useLegacyTimestampBucketing);
                    }
                }
                throw new UnsupportedOperationException("Computation of Hive bucket hashCode is not supported for Hive primitive category: " + primitiveCategory.toString() + ".");
            }
            case LIST: {
                return HiveBucketing.hashOfList((ListTypeInfo)type, (Block)value, useLegacyTimestampBucketing);
            }
            case MAP: {
                return HiveBucketing.hashOfMap((MapTypeInfo)type, (Block)value, useLegacyTimestampBucketing);
            }
        }
        throw new UnsupportedOperationException("Computation of Hive bucket hashCode is not supported for Hive category: " + type.getCategory().toString() + ".");
    }

    private static int getHashForTimestamp(long millisSinceEpoch, boolean useLegacyTimestampBucketing) {
        if (useLegacyTimestampBucketing) {
            long secondsAndMillis = (Math.floorDiv(millisSinceEpoch, 1000L) << 30) + Math.floorMod(millisSinceEpoch, 1000L);
            return (int)(secondsAndMillis >>> 32 ^ secondsAndMillis);
        }
        long secondsAndNanos = (Math.floorDiv(millisSinceEpoch, 1000L) << 30) + Math.floorMod(millisSinceEpoch, 1000L) * 1000L * 1000L;
        return (int)(secondsAndNanos >>> 32 ^ secondsAndNanos);
    }

    private static int hashOfMap(MapTypeInfo type, Block singleMapBlock, boolean useLegacyTimestampBucketing) {
        TypeInfo keyTypeInfo = type.getMapKeyTypeInfo();
        TypeInfo valueTypeInfo = type.getMapValueTypeInfo();
        int result = 0;
        for (int i = 0; i < singleMapBlock.getPositionCount(); i += 2) {
            result += HiveBucketing.hash(keyTypeInfo, singleMapBlock, i, useLegacyTimestampBucketing) ^ HiveBucketing.hash(valueTypeInfo, singleMapBlock, i + 1, useLegacyTimestampBucketing);
        }
        return result;
    }

    private static int hashOfList(ListTypeInfo type, Block singleListBlock, boolean useLegacyTimestampBucketing) {
        TypeInfo elementTypeInfo = type.getListElementTypeInfo();
        int result = 0;
        for (int i = 0; i < singleListBlock.getPositionCount(); ++i) {
            result = result * 31 + HiveBucketing.hash(elementTypeInfo, singleListBlock, i, useLegacyTimestampBucketing);
        }
        return result;
    }

    private static int hashBytes(int initialValue, Slice bytes) {
        int result = initialValue;
        for (int i = 0; i < bytes.length(); ++i) {
            result = result * 31 + bytes.getByte(i);
        }
        return result;
    }

    public static Optional<HiveBucketHandle> getHiveBucketHandle(ConnectorSession session, Table table) {
        Optional hiveBucketProperty = table.getStorage().getBucketProperty();
        if (!hiveBucketProperty.isPresent()) {
            if (table.getTableType().equals((Object)PrestoTableType.TEMPORARY_TABLE)) {
                return Optional.of(HiveBucketHandle.createVirtualBucketHandle(HiveSessionProperties.getCteVirtualBucketCount(session)));
            }
            return Optional.empty();
        }
        Map map = HiveUtil.getRegularColumnHandles(table).stream().collect(Collectors.toMap(BaseHiveColumnHandle::getName, Function.identity()));
        ImmutableList.Builder bucketColumns = ImmutableList.builder();
        for (String bucketColumnName : ((HiveBucketProperty)hiveBucketProperty.get()).getBucketedBy()) {
            HiveColumnHandle bucketColumnHandle = (HiveColumnHandle)((Object)map.get(bucketColumnName));
            if (bucketColumnHandle == null) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Table '%s.%s' is bucketed on non-existent column '%s'", table.getDatabaseName(), table.getTableName(), bucketColumnName));
            }
            bucketColumns.add((Object)bucketColumnHandle);
        }
        int bucketCount = ((HiveBucketProperty)hiveBucketProperty.get()).getBucketCount();
        return Optional.of(new HiveBucketHandle((List<HiveColumnHandle>)bucketColumns.build(), bucketCount, bucketCount));
    }

    public static Optional<HiveBucketFilter> getHiveBucketFilter(Table table, TupleDomain<ColumnHandle> effectivePredicate, boolean useLegacyTimestampBucketing) {
        return HiveBucketing.getHiveBucketFilter(table.getStorage().getBucketProperty(), table.getDataColumns(), effectivePredicate, useLegacyTimestampBucketing);
    }

    public static Optional<HiveBucketFilter> getHiveBucketFilter(Optional<HiveBucketProperty> hiveBucketProperty, List<Column> dataColumns, TupleDomain<ColumnHandle> effectivePredicate, boolean useLegacyTimestampBucketing) {
        if (!hiveBucketProperty.isPresent()) {
            return Optional.empty();
        }
        if (!hiveBucketProperty.get().getBucketFunctionType().equals((Object)BucketFunctionType.HIVE_COMPATIBLE)) {
            return Optional.empty();
        }
        Optional bindings = TupleDomain.extractFixedValueSets(effectivePredicate);
        if (!bindings.isPresent()) {
            return Optional.empty();
        }
        Optional<Set<Integer>> buckets = HiveBucketing.getHiveBuckets(hiveBucketProperty, dataColumns, (Map)bindings.get(), useLegacyTimestampBucketing);
        if (buckets.isPresent()) {
            return Optional.of(new HiveBucketFilter(buckets.get()));
        }
        if (!effectivePredicate.getDomains().isPresent()) {
            return Optional.empty();
        }
        Optional<Domain> domain = ((Map)effectivePredicate.getDomains().get()).entrySet().stream().filter(entry -> ((HiveColumnHandle)((Object)((Object)entry.getKey()))).getName().equals("$bucket")).findFirst().map(Map.Entry::getValue);
        if (!domain.isPresent()) {
            return Optional.empty();
        }
        ValueSet values = domain.get().getValues();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        int bucketCount = hiveBucketProperty.get().getBucketCount();
        for (int i = 0; i < bucketCount; ++i) {
            if (!values.containsValue((Object)i)) continue;
            builder.add((Object)i);
        }
        return Optional.of(new HiveBucketFilter((Set<Integer>)builder.build()));
    }

    private static Optional<Set<Integer>> getHiveBuckets(Optional<HiveBucketProperty> hiveBucketPropertyOptional, List<Column> dataColumns, Map<ColumnHandle, Set<NullableValue>> bindings, boolean useLegacyTimestampBucketing) {
        if (bindings.isEmpty() || !hiveBucketPropertyOptional.isPresent()) {
            return Optional.empty();
        }
        HiveBucketProperty hiveBucketProperty = hiveBucketPropertyOptional.get();
        Preconditions.checkArgument((boolean)hiveBucketProperty.getBucketFunctionType().equals((Object)BucketFunctionType.HIVE_COMPATIBLE), (String)"bucketFunctionType is expected to be HIVE_COMPATIBLE, got: %s", (Object)hiveBucketProperty.getBucketFunctionType());
        List bucketColumns = hiveBucketProperty.getBucketedBy();
        if (bucketColumns.isEmpty()) {
            return Optional.empty();
        }
        Map hiveTypes = (Map)dataColumns.stream().collect(ImmutableMap.toImmutableMap(Column::getName, Column::getType));
        for (String column : bucketColumns) {
            if (SUPPORTED_TYPES_FOR_BUCKET_FILTER.contains(hiveTypes.get(column))) continue;
            return Optional.empty();
        }
        Map nameToBindings = (Map)bindings.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((HiveColumnHandle)((Object)((Object)entry.getKey()))).getName(), Map.Entry::getValue));
        ImmutableList.Builder orderedBindingsBuilder = ImmutableList.builder();
        for (String columnName : bucketColumns) {
            if (!nameToBindings.containsKey(columnName)) {
                return Optional.empty();
            }
            orderedBindingsBuilder.add(nameToBindings.get(columnName));
        }
        ImmutableList orderedBindings = orderedBindingsBuilder.build();
        int bucketCount = hiveBucketProperty.getBucketCount();
        List types = (List)bucketColumns.stream().map(hiveTypes::get).map(HiveType::getTypeInfo).collect(ImmutableList.toImmutableList());
        ImmutableSet.Builder buckets = ImmutableSet.builder();
        HiveBucketing.getHiveBuckets(new Object[types.size()], 0, (List<Set<NullableValue>>)orderedBindings, bucketCount, types, (ImmutableSet.Builder<Integer>)buckets, useLegacyTimestampBucketing);
        return Optional.of(buckets.build());
    }

    private static void getHiveBuckets(Object[] values, int valuesCount, List<Set<NullableValue>> bindings, int bucketCount, List<TypeInfo> typeInfos, ImmutableSet.Builder<Integer> buckets, boolean useLegacyTimestampBucketing) {
        if (valuesCount == typeInfos.size()) {
            buckets.add((Object)HiveBucketing.getHiveBucket(bucketCount, typeInfos, values, useLegacyTimestampBucketing));
            return;
        }
        for (NullableValue value : bindings.get(valuesCount)) {
            values[valuesCount] = value.getValue();
            HiveBucketing.getHiveBuckets(values, valuesCount + 1, bindings, bucketCount, typeInfos, buckets, useLegacyTimestampBucketing);
        }
    }

    public static class HiveBucketFilter {
        private final Set<Integer> bucketsToKeep;

        @JsonCreator
        public HiveBucketFilter(@JsonProperty(value="bucketsToKeep") Set<Integer> bucketsToKeep) {
            this.bucketsToKeep = bucketsToKeep;
        }

        @JsonProperty
        public Set<Integer> getBucketsToKeep() {
            return this.bucketsToKeep;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HiveBucketFilter that = (HiveBucketFilter)o;
            return Objects.equals(this.bucketsToKeep, that.bucketsToKeep);
        }

        public int hashCode() {
            return Objects.hash(this.bucketsToKeep);
        }
    }
}

