/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.block.ArrayBlock;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.ColumnarArray;
import com.facebook.presto.common.block.ColumnarMap;
import com.facebook.presto.common.block.ColumnarRow;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.block.RowBlock;
import com.facebook.presto.common.predicate.TupleDomainFilter;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;

public interface HiveCoercer
extends Function<Block, Block> {
    public TupleDomainFilter toCoercingFilter(TupleDomainFilter var1, Subfield var2);

    public Type getToType();

    public static HiveCoercer createCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType) {
        Type fromType = typeManager.getType(fromHiveType.getTypeSignature());
        Type toType = typeManager.getType(toHiveType.getTypeSignature());
        if (toType instanceof VarcharType && (fromHiveType.equals((Object)HiveType.HIVE_BYTE) || fromHiveType.equals((Object)HiveType.HIVE_SHORT) || fromHiveType.equals((Object)HiveType.HIVE_INT) || fromHiveType.equals((Object)HiveType.HIVE_LONG))) {
            return new IntegerNumberToVarcharCoercer(fromType, toType);
        }
        if (fromType instanceof VarcharType && (toHiveType.equals((Object)HiveType.HIVE_BYTE) || toHiveType.equals((Object)HiveType.HIVE_SHORT) || toHiveType.equals((Object)HiveType.HIVE_INT) || toHiveType.equals((Object)HiveType.HIVE_LONG))) {
            return new VarcharToIntegerNumberCoercer(fromType, toType);
        }
        if (fromHiveType.equals((Object)HiveType.HIVE_BYTE) && (toHiveType.equals((Object)HiveType.HIVE_SHORT) || toHiveType.equals((Object)HiveType.HIVE_INT) || toHiveType.equals((Object)HiveType.HIVE_LONG))) {
            return new IntegerNumberUpscaleCoercer(fromType, toType);
        }
        if (fromHiveType.equals((Object)HiveType.HIVE_SHORT) && (toHiveType.equals((Object)HiveType.HIVE_INT) || toHiveType.equals((Object)HiveType.HIVE_LONG))) {
            return new IntegerNumberUpscaleCoercer(fromType, toType);
        }
        if (fromHiveType.equals((Object)HiveType.HIVE_INT) && toHiveType.equals((Object)HiveType.HIVE_LONG)) {
            return new IntegerNumberUpscaleCoercer(fromType, toType);
        }
        if (fromHiveType.equals((Object)HiveType.HIVE_FLOAT) && toHiveType.equals((Object)HiveType.HIVE_DOUBLE)) {
            return new FloatToDoubleCoercer();
        }
        if (MetastoreUtil.isArrayType((Type)fromType) && MetastoreUtil.isArrayType((Type)toType)) {
            return new ListCoercer(typeManager, fromHiveType, toHiveType);
        }
        if (MetastoreUtil.isMapType((Type)fromType) && MetastoreUtil.isMapType((Type)toType)) {
            return new MapCoercer(typeManager, fromHiveType, toHiveType);
        }
        if (MetastoreUtil.isRowType((Type)fromType) && MetastoreUtil.isRowType((Type)toType)) {
            return new StructCoercer(typeManager, fromHiveType, toHiveType);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported coercion from %s to %s", fromHiveType, toHiveType));
    }

    public static class StructCoercer
    implements HiveCoercer {
        private final HiveCoercer[] coercers;
        private final Block[] nullBlocks;
        private final List<String> toFieldNames;
        private final Type toType;

        public StructCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType) {
            Objects.requireNonNull(typeManager, "typeManage is null");
            Objects.requireNonNull(fromHiveType, "fromHiveType is null");
            Objects.requireNonNull(toHiveType, "toHiveType is null");
            List<HiveType> fromFieldTypes = HiveUtil.extractStructFieldTypes(fromHiveType);
            List<HiveType> toFieldTypes = HiveUtil.extractStructFieldTypes(toHiveType);
            this.coercers = new HiveCoercer[toFieldTypes.size()];
            this.nullBlocks = new Block[toFieldTypes.size()];
            for (int i = 0; i < this.coercers.length; ++i) {
                if (i >= fromFieldTypes.size()) {
                    this.nullBlocks[i] = toFieldTypes.get(i).getType(typeManager).createBlockBuilder(null, 1).appendNull().build();
                    continue;
                }
                if (fromFieldTypes.get(i).equals((Object)toFieldTypes.get(i))) continue;
                this.coercers[i] = HiveCoercer.createCoercer(typeManager, fromFieldTypes.get(i), toFieldTypes.get(i));
            }
            this.toFieldNames = HiveUtil.extractStructFieldNames(toHiveType);
            this.toType = toHiveType.getType(typeManager);
        }

        @Override
        public Block apply(Block block) {
            ColumnarRow rowBlock = ColumnarRow.toColumnarRow((Block)block);
            Block[] fields = new Block[this.coercers.length];
            int[] ids = new int[rowBlock.getField(0).getPositionCount()];
            for (int i = 0; i < this.coercers.length; ++i) {
                fields[i] = this.coercers[i] != null ? (Block)this.coercers[i].apply(rowBlock.getField(i)) : (i < rowBlock.getFieldCount() ? rowBlock.getField(i) : new DictionaryBlock(this.nullBlocks[i], ids));
            }
            boolean[] valueIsNull = new boolean[rowBlock.getPositionCount()];
            for (int i = 0; i < rowBlock.getPositionCount(); ++i) {
                valueIsNull[i] = rowBlock.isNull(i);
            }
            return RowBlock.fromFieldBlocks((int)valueIsNull.length, Optional.of(valueIsNull), (Block[])fields);
        }

        @Override
        public TupleDomainFilter toCoercingFilter(TupleDomainFilter filter, Subfield subfield) {
            if (filter == TupleDomainFilter.IS_NULL || filter == TupleDomainFilter.IS_NOT_NULL) {
                return filter;
            }
            if (subfield.getPath().size() > 0) {
                String fieldName = ((Subfield.NestedField)subfield.getPath().get(0)).getName();
                for (int i = 0; i < this.toFieldNames.size(); ++i) {
                    if (!fieldName.equals(this.toFieldNames.get(i))) continue;
                    HiveCoercer coercer = this.coercers[i];
                    if (coercer == null) {
                        return filter;
                    }
                    return coercer.toCoercingFilter(filter, subfield.tail(fieldName));
                }
                throw new IllegalArgumentException("Struct field not found: " + fieldName);
            }
            throw new UnsupportedOperationException("Range filers on struct types are not supported");
        }

        @Override
        public Type getToType() {
            return this.toType;
        }
    }

    public static class MapCoercer
    implements HiveCoercer {
        private final Type toType;
        private final HiveCoercer keyCoercer;
        private final HiveCoercer valueCoercer;

        public MapCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType) {
            Objects.requireNonNull(typeManager, "typeManage is null");
            Objects.requireNonNull(fromHiveType, "fromHiveType is null");
            this.toType = Objects.requireNonNull(toHiveType, "toHiveType is null").getType(typeManager);
            HiveType fromKeyHiveType = HiveType.valueOf((String)((MapTypeInfo)fromHiveType.getTypeInfo()).getMapKeyTypeInfo().getTypeName());
            HiveType fromValueHiveType = HiveType.valueOf((String)((MapTypeInfo)fromHiveType.getTypeInfo()).getMapValueTypeInfo().getTypeName());
            HiveType toKeyHiveType = HiveType.valueOf((String)((MapTypeInfo)toHiveType.getTypeInfo()).getMapKeyTypeInfo().getTypeName());
            HiveType toValueHiveType = HiveType.valueOf((String)((MapTypeInfo)toHiveType.getTypeInfo()).getMapValueTypeInfo().getTypeName());
            this.keyCoercer = fromKeyHiveType.equals((Object)toKeyHiveType) ? null : HiveCoercer.createCoercer(typeManager, fromKeyHiveType, toKeyHiveType);
            this.valueCoercer = fromValueHiveType.equals((Object)toValueHiveType) ? null : HiveCoercer.createCoercer(typeManager, fromValueHiveType, toValueHiveType);
        }

        @Override
        public Block apply(Block block) {
            ColumnarMap mapBlock = ColumnarMap.toColumnarMap((Block)block);
            Block keysBlock = this.keyCoercer == null ? mapBlock.getKeysBlock() : (Block)this.keyCoercer.apply(mapBlock.getKeysBlock());
            Block valuesBlock = this.valueCoercer == null ? mapBlock.getValuesBlock() : (Block)this.valueCoercer.apply(mapBlock.getValuesBlock());
            int positionCount = mapBlock.getPositionCount();
            boolean[] valueIsNull = new boolean[positionCount];
            int[] offsets = new int[positionCount + 1];
            for (int i = 0; i < positionCount; ++i) {
                valueIsNull[i] = mapBlock.isNull(i);
                offsets[i + 1] = offsets[i] + mapBlock.getEntryCount(i);
            }
            return ((MapType)this.toType).createBlockFromKeyValue(positionCount, Optional.of(valueIsNull), offsets, keysBlock, valuesBlock);
        }

        @Override
        public TupleDomainFilter toCoercingFilter(TupleDomainFilter filter, Subfield subfield) {
            if (filter == TupleDomainFilter.IS_NULL || filter == TupleDomainFilter.IS_NOT_NULL) {
                return filter;
            }
            throw new UnsupportedOperationException("Range filers on map elements are not supported");
        }

        @Override
        public Type getToType() {
            return this.toType;
        }
    }

    public static class ListCoercer
    implements HiveCoercer {
        private final HiveCoercer elementCoercer;
        private final Type toType;

        public ListCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType) {
            Objects.requireNonNull(typeManager, "typeManage is null");
            Objects.requireNonNull(fromHiveType, "fromHiveType is null");
            Objects.requireNonNull(toHiveType, "toHiveType is null");
            HiveType fromElementHiveType = HiveType.valueOf((String)((ListTypeInfo)fromHiveType.getTypeInfo()).getListElementTypeInfo().getTypeName());
            HiveType toElementHiveType = HiveType.valueOf((String)((ListTypeInfo)toHiveType.getTypeInfo()).getListElementTypeInfo().getTypeName());
            this.elementCoercer = fromElementHiveType.equals((Object)toElementHiveType) ? null : HiveCoercer.createCoercer(typeManager, fromElementHiveType, toElementHiveType);
            this.toType = toHiveType.getType(typeManager);
        }

        @Override
        public Block apply(Block block) {
            if (this.elementCoercer == null) {
                return block;
            }
            ColumnarArray arrayBlock = ColumnarArray.toColumnarArray((Block)block);
            Block elementsBlock = (Block)this.elementCoercer.apply(arrayBlock.getElementsBlock());
            boolean[] valueIsNull = new boolean[arrayBlock.getPositionCount()];
            int[] offsets = new int[arrayBlock.getPositionCount() + 1];
            for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
                valueIsNull[i] = arrayBlock.isNull(i);
                offsets[i + 1] = offsets[i] + arrayBlock.getLength(i);
            }
            return ArrayBlock.fromElementBlock((int)arrayBlock.getPositionCount(), Optional.of(valueIsNull), (int[])offsets, (Block)elementsBlock);
        }

        @Override
        public TupleDomainFilter toCoercingFilter(TupleDomainFilter filter, Subfield subfield) {
            if (filter == TupleDomainFilter.IS_NULL || filter == TupleDomainFilter.IS_NOT_NULL) {
                return filter;
            }
            throw new UnsupportedOperationException("Range filers on array elements are not supported");
        }

        @Override
        public Type getToType() {
            return this.toType;
        }
    }

    public static class FloatToDoubleCoercer
    implements HiveCoercer {
        @Override
        public Block apply(Block block) {
            BlockBuilder blockBuilder = DoubleType.DOUBLE.createBlockBuilder(null, block.getPositionCount());
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    blockBuilder.appendNull();
                    continue;
                }
                DoubleType.DOUBLE.writeDouble(blockBuilder, (double)Float.intBitsToFloat((int)RealType.REAL.getLong(block, i)));
            }
            return blockBuilder.build();
        }

        @Override
        public TupleDomainFilter toCoercingFilter(TupleDomainFilter filter, Subfield subfield) {
            Preconditions.checkArgument((boolean)subfield.getPath().isEmpty(), (Object)"Subfields on primitive types are not allowed");
            return filter;
        }

        @Override
        public Type getToType() {
            return DoubleType.DOUBLE;
        }
    }

    public static class VarcharToIntegerNumberCoercer
    implements HiveCoercer {
        private final Type fromType;
        private final Type toType;
        private final long minValue;
        private final long maxValue;

        public VarcharToIntegerNumberCoercer(Type fromType, Type toType) {
            this.fromType = Objects.requireNonNull(fromType, "fromType is null");
            this.toType = Objects.requireNonNull(toType, "toType is null");
            if (toType.equals(TinyintType.TINYINT)) {
                this.minValue = -128L;
                this.maxValue = 127L;
            } else if (toType.equals(SmallintType.SMALLINT)) {
                this.minValue = -32768L;
                this.maxValue = 32767L;
            } else if (toType.equals(IntegerType.INTEGER)) {
                this.minValue = Integer.MIN_VALUE;
                this.maxValue = Integer.MAX_VALUE;
            } else if (toType.equals(BigintType.BIGINT)) {
                this.minValue = Long.MIN_VALUE;
                this.maxValue = Long.MAX_VALUE;
            } else {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Could not create Coercer from varchar to %s", toType));
            }
        }

        @Override
        public Block apply(Block block) {
            BlockBuilder blockBuilder = this.toType.createBlockBuilder(null, block.getPositionCount());
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    blockBuilder.appendNull();
                    continue;
                }
                try {
                    long value = Long.parseLong(this.fromType.getSlice(block, i).toStringUtf8());
                    if (this.minValue <= value && value <= this.maxValue) {
                        this.toType.writeLong(blockBuilder, value);
                        continue;
                    }
                    blockBuilder.appendNull();
                    continue;
                }
                catch (NumberFormatException e) {
                    blockBuilder.appendNull();
                }
            }
            return blockBuilder.build();
        }

        @Override
        public TupleDomainFilter toCoercingFilter(TupleDomainFilter filter, Subfield subfield) {
            Preconditions.checkArgument((boolean)subfield.getPath().isEmpty(), (Object)"Subfields on primitive types are not allowed");
            return new CoercingFilter(filter, this.minValue, this.maxValue);
        }

        @Override
        public Type getToType() {
            return this.toType;
        }

        private static final class CoercingFilter
        extends TupleDomainFilter.AbstractTupleDomainFilter {
            private final TupleDomainFilter delegate;
            private final long minValue;
            private final long maxValue;

            public CoercingFilter(TupleDomainFilter delegate, long minValue, long maxValue) {
                super(delegate.isDeterministic(), !delegate.isDeterministic() || delegate.testNull());
                this.delegate = Objects.requireNonNull(delegate, "delegate is null");
                this.minValue = minValue;
                this.maxValue = maxValue;
            }

            public boolean testNull() {
                return this.delegate.testNull();
            }

            public boolean testLength(int length) {
                return true;
            }

            public boolean testBytes(byte[] buffer, int offset, int length) {
                long value;
                try {
                    value = Long.valueOf(new String(buffer, offset, length));
                }
                catch (NumberFormatException e) {
                    return this.delegate.testNull();
                }
                if (this.minValue <= value && value <= this.maxValue) {
                    return this.delegate.testLong(value);
                }
                return this.delegate.testNull();
            }
        }
    }

    public static class IntegerNumberToVarcharCoercer
    implements HiveCoercer {
        private final Type fromType;
        private final Type toType;

        public IntegerNumberToVarcharCoercer(Type fromType, Type toType) {
            this.fromType = Objects.requireNonNull(fromType, "fromType is null");
            this.toType = Objects.requireNonNull(toType, "toType is null");
        }

        @Override
        public Block apply(Block block) {
            BlockBuilder blockBuilder = this.toType.createBlockBuilder(null, block.getPositionCount());
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    blockBuilder.appendNull();
                    continue;
                }
                this.toType.writeSlice(blockBuilder, Slices.utf8Slice((String)String.valueOf(this.fromType.getLong(block, i))));
            }
            return blockBuilder.build();
        }

        @Override
        public TupleDomainFilter toCoercingFilter(TupleDomainFilter filter, Subfield subfield) {
            Preconditions.checkArgument((boolean)subfield.getPath().isEmpty(), (Object)"Subfields on primitive types are not allowed");
            return new CoercingFilter(filter);
        }

        @Override
        public Type getToType() {
            return this.toType;
        }

        private static final class CoercingFilter
        extends TupleDomainFilter.AbstractTupleDomainFilter {
            private final TupleDomainFilter delegate;

            public CoercingFilter(TupleDomainFilter delegate) {
                super(delegate.isDeterministic(), !delegate.isDeterministic() || delegate.testNull());
                this.delegate = Objects.requireNonNull(delegate, "delegate is null");
            }

            public boolean testNull() {
                return this.delegate.testNull();
            }

            public boolean testLong(long value) {
                byte[] bytes = String.valueOf(value).getBytes();
                return this.delegate.testBytes(bytes, 0, bytes.length);
            }
        }
    }

    public static class IntegerNumberUpscaleCoercer
    implements HiveCoercer {
        private final Type fromType;
        private final Type toType;

        public IntegerNumberUpscaleCoercer(Type fromType, Type toType) {
            this.fromType = Objects.requireNonNull(fromType, "fromType is null");
            this.toType = Objects.requireNonNull(toType, "toType is null");
        }

        @Override
        public Block apply(Block block) {
            BlockBuilder blockBuilder = this.toType.createBlockBuilder(null, block.getPositionCount());
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    blockBuilder.appendNull();
                    continue;
                }
                this.toType.writeLong(blockBuilder, this.fromType.getLong(block, i));
            }
            return blockBuilder.build();
        }

        @Override
        public TupleDomainFilter toCoercingFilter(TupleDomainFilter filter, Subfield subfield) {
            Preconditions.checkArgument((boolean)subfield.getPath().isEmpty(), (Object)"Subfields on primitive types are not allowed");
            return filter;
        }

        @Override
        public Type getToType() {
            return this.toType;
        }
    }
}

