/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.hive.BaseHiveColumnHandle;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.plan.AggregationNode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class HiveColumnHandle
extends BaseHiveColumnHandle {
    public static final int PATH_COLUMN_INDEX = -11;
    public static final String PATH_COLUMN_NAME = "$path";
    public static final HiveType PATH_HIVE_TYPE = HiveType.HIVE_STRING;
    public static final TypeSignature PATH_TYPE_SIGNATURE = PATH_HIVE_TYPE.getTypeSignature();
    public static final int BUCKET_COLUMN_INDEX = -12;
    public static final String BUCKET_COLUMN_NAME = "$bucket";
    public static final HiveType BUCKET_HIVE_TYPE = HiveType.HIVE_INT;
    public static final TypeSignature BUCKET_TYPE_SIGNATURE = BUCKET_HIVE_TYPE.getTypeSignature();
    public static final int ROW_ID_COLUMN_INDEX = -10;
    public static final String ROW_ID_COLUMN_NAME = "$row_id";
    public static final HiveType ROW_ID_TYPE = HiveType.HIVE_BINARY;
    public static final TypeSignature ROW_ID_TYPE_SIGNATURE = ROW_ID_TYPE.getTypeSignature();
    public static final int FILE_SIZE_COLUMN_INDEX = -9;
    public static final String FILE_SIZE_COLUMN_NAME = "$file_size";
    public static final HiveType FILE_SIZE_TYPE = HiveType.HIVE_LONG;
    public static final TypeSignature FILE_SIZE_TYPE_SIGNATURE = FILE_SIZE_TYPE.getTypeSignature();
    public static final int FILE_MODIFIED_TIME_COLUMN_INDEX = -8;
    public static final String FILE_MODIFIED_TIME_COLUMN_NAME = "$file_modified_time";
    public static final HiveType FILE_MODIFIED_TIME_TYPE = HiveType.HIVE_LONG;
    public static final TypeSignature FILE_MODIFIED_TIME_TYPE_SIGNATURE = FILE_MODIFIED_TIME_TYPE.getTypeSignature();
    private static final String UPDATE_ROW_ID_COLUMN_NAME = "$shard_row_id";
    public static final int MAX_PARTITION_KEY_COLUMN_INDEX = -13;
    private final HiveType hiveType;
    private final TypeSignature typeName;
    private final int hiveColumnIndex;
    private final Optional<AggregationNode.Aggregation> partialAggregation;

    @JsonCreator
    public HiveColumnHandle(@JsonProperty(value="name") String name, @JsonProperty(value="hiveType") HiveType hiveType, @JsonProperty(value="typeSignature") TypeSignature typeSignature, @JsonProperty(value="hiveColumnIndex") int hiveColumnIndex, @JsonProperty(value="columnType") BaseHiveColumnHandle.ColumnType columnType, @JsonProperty(value="comment") Optional<String> comment, @JsonProperty(value="requiredSubfields") List<Subfield> requiredSubfields, @JsonProperty(value="partialAggregation") Optional<AggregationNode.Aggregation> partialAggregation) {
        super(name, comment, columnType, requiredSubfields);
        Preconditions.checkArgument((hiveColumnIndex >= 0 || columnType == BaseHiveColumnHandle.ColumnType.PARTITION_KEY || columnType == BaseHiveColumnHandle.ColumnType.SYNTHESIZED || columnType == BaseHiveColumnHandle.ColumnType.AGGREGATED ? 1 : 0) != 0, (Object)String.format("hiveColumnIndex:%d is negative, columnType:%s", hiveColumnIndex, columnType.toString()));
        this.hiveColumnIndex = hiveColumnIndex;
        this.hiveType = Objects.requireNonNull(hiveType, "hiveType is null");
        this.typeName = Objects.requireNonNull(typeSignature, "type is null");
        this.partialAggregation = Objects.requireNonNull(partialAggregation, "partialAggregation is null");
        Preconditions.checkArgument((columnType != BaseHiveColumnHandle.ColumnType.AGGREGATED || partialAggregation.isPresent() ? 1 : 0) != 0, (Object)"Aggregated column does not have aggregate function");
    }

    public HiveColumnHandle(String name, HiveType hiveType, TypeSignature typeSignature, int hiveColumnIndex, BaseHiveColumnHandle.ColumnType columnType, Optional<String> comment, Optional<AggregationNode.Aggregation> partialAggregation) {
        this(name, hiveType, typeSignature, hiveColumnIndex, columnType, comment, (List<Subfield>)ImmutableList.of(), partialAggregation);
    }

    @JsonProperty
    public HiveType getHiveType() {
        return this.hiveType;
    }

    @JsonProperty
    public int getHiveColumnIndex() {
        return this.hiveColumnIndex;
    }

    public boolean isPartitionKey() {
        return this.getColumnType() == BaseHiveColumnHandle.ColumnType.PARTITION_KEY;
    }

    public boolean isHidden() {
        return this.getColumnType() == BaseHiveColumnHandle.ColumnType.SYNTHESIZED;
    }

    public ColumnMetadata getColumnMetadata(TypeManager typeManager) {
        return new ColumnMetadata(this.getName(), typeManager.getType(this.typeName), null, this.isHidden());
    }

    @JsonProperty
    public Optional<AggregationNode.Aggregation> getPartialAggregation() {
        return this.partialAggregation;
    }

    @JsonProperty
    public TypeSignature getTypeSignature() {
        return this.typeName;
    }

    public ColumnHandle withRequiredSubfields(List<Subfield> subfields) {
        if (HiveColumnHandle.isPushedDownSubfield(this)) {
            return this;
        }
        return new HiveColumnHandle(this.getName(), this.hiveType, this.typeName, this.hiveColumnIndex, this.getColumnType(), this.getComment(), subfields, this.partialAggregation);
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.hiveColumnIndex, this.hiveType, this.getColumnType(), this.getComment());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        HiveColumnHandle other = (HiveColumnHandle)((Object)obj);
        return Objects.equals(this.getName(), other.getName()) && Objects.equals(this.hiveColumnIndex, other.hiveColumnIndex) && Objects.equals(this.hiveType, other.hiveType) && Objects.equals(this.getColumnType(), other.getColumnType()) && Objects.equals(this.getComment(), other.getComment()) && Objects.equals(this.getRequiredSubfields(), other.getRequiredSubfields());
    }

    public String toString() {
        if (this.getRequiredSubfields().isEmpty()) {
            return this.getName() + ":" + this.hiveType + ":" + this.hiveColumnIndex + ":" + this.getColumnType();
        }
        return this.getName() + ":" + this.hiveType + ":" + this.hiveColumnIndex + ":" + this.getColumnType() + ":" + this.getRequiredSubfields();
    }

    public static HiveColumnHandle updateRowIdHandle() {
        return new HiveColumnHandle(UPDATE_ROW_ID_COLUMN_NAME, HiveType.HIVE_LONG, BigintType.BIGINT.getTypeSignature(), -1, BaseHiveColumnHandle.ColumnType.SYNTHESIZED, Optional.empty(), (List<Subfield>)ImmutableList.of(), Optional.empty());
    }

    public static HiveColumnHandle pathColumnHandle() {
        return new HiveColumnHandle(PATH_COLUMN_NAME, PATH_HIVE_TYPE, PATH_TYPE_SIGNATURE, -11, BaseHiveColumnHandle.ColumnType.SYNTHESIZED, Optional.empty(), (List<Subfield>)ImmutableList.of(), Optional.empty());
    }

    public static HiveColumnHandle bucketColumnHandle() {
        return new HiveColumnHandle(BUCKET_COLUMN_NAME, BUCKET_HIVE_TYPE, BUCKET_TYPE_SIGNATURE, -12, BaseHiveColumnHandle.ColumnType.SYNTHESIZED, Optional.empty(), (List<Subfield>)ImmutableList.of(), Optional.empty());
    }

    public static HiveColumnHandle rowIdColumnHandle() {
        return new HiveColumnHandle(ROW_ID_COLUMN_NAME, ROW_ID_TYPE, ROW_ID_TYPE_SIGNATURE, -10, BaseHiveColumnHandle.ColumnType.SYNTHESIZED, Optional.empty(), (List<Subfield>)ImmutableList.of(), Optional.empty());
    }

    public static HiveColumnHandle fileSizeColumnHandle() {
        return new HiveColumnHandle(FILE_SIZE_COLUMN_NAME, FILE_SIZE_TYPE, FILE_SIZE_TYPE_SIGNATURE, -9, BaseHiveColumnHandle.ColumnType.SYNTHESIZED, Optional.empty(), (List<Subfield>)ImmutableList.of(), Optional.empty());
    }

    public static HiveColumnHandle fileModifiedTimeColumnHandle() {
        return new HiveColumnHandle(FILE_MODIFIED_TIME_COLUMN_NAME, FILE_MODIFIED_TIME_TYPE, FILE_MODIFIED_TIME_TYPE_SIGNATURE, -8, BaseHiveColumnHandle.ColumnType.SYNTHESIZED, Optional.empty(), (List<Subfield>)ImmutableList.of(), Optional.empty());
    }

    public static boolean isRowIdColumnHandle(HiveColumnHandle column) {
        return column.getHiveColumnIndex() == -10;
    }

    public static boolean isPathColumnHandle(HiveColumnHandle column) {
        return column.getHiveColumnIndex() == -11;
    }

    public static boolean isBucketColumnHandle(HiveColumnHandle column) {
        return column.getHiveColumnIndex() == -12;
    }

    public static Subfield getPushedDownSubfield(HiveColumnHandle column) {
        Preconditions.checkArgument((boolean)HiveColumnHandle.isPushedDownSubfield(column), (Object)String.format("not a valid pushed down subfield: type=%s, subfields=%s", column.getColumnType(), column.getRequiredSubfields()));
        return (Subfield)Iterables.getOnlyElement((Iterable)column.getRequiredSubfields());
    }

    public static boolean isPushedDownSubfield(HiveColumnHandle column) {
        return column.getColumnType() == BaseHiveColumnHandle.ColumnType.SYNTHESIZED && column.getRequiredSubfields().size() == 1;
    }

    public static boolean isFileSizeColumnHandle(HiveColumnHandle column) {
        return column.getHiveColumnIndex() == -9;
    }

    public static boolean isFileModifiedTimeColumnHandle(HiveColumnHandle column) {
        return column.getHiveColumnIndex() == -8;
    }

    public static boolean isInfoColumnHandle(HiveColumnHandle column) {
        return HiveColumnHandle.isPathColumnHandle(column) || HiveColumnHandle.isFileSizeColumnHandle(column) || HiveColumnHandle.isFileModifiedTimeColumnHandle(column);
    }
}

