/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.hive.NestedDirectoryPolicy;
import com.facebook.presto.spi.security.ConnectorIdentity;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public class HiveDirectoryContext {
    private final NestedDirectoryPolicy nestedDirectoryPolicy;
    private final ConnectorIdentity connectorIdentity;
    private final Map<String, String> additionalProperties;
    private final RuntimeStats runtimeStats;
    private boolean cacheable;
    private boolean skipEmptyFiles;

    public HiveDirectoryContext(NestedDirectoryPolicy nestedDirectoryPolicy, boolean cacheable, boolean skipEmptyFiles, ConnectorIdentity connectorIdentity, Map<String, String> additionalProperties, RuntimeStats runtimeStats) {
        this.nestedDirectoryPolicy = Objects.requireNonNull(nestedDirectoryPolicy, "nestedDirectoryPolicy is null");
        this.connectorIdentity = Objects.requireNonNull(connectorIdentity, "connectorIdentity is null");
        this.additionalProperties = ImmutableMap.copyOf(Objects.requireNonNull(additionalProperties, "additionalProperties is null"));
        this.runtimeStats = Objects.requireNonNull(runtimeStats, "runtimeStats is null");
        this.cacheable = cacheable;
        this.skipEmptyFiles = skipEmptyFiles;
    }

    public NestedDirectoryPolicy getNestedDirectoryPolicy() {
        return this.nestedDirectoryPolicy;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public void disableCaching() {
        this.cacheable = false;
    }

    public ConnectorIdentity getConnectorIdentity() {
        return this.connectorIdentity;
    }

    public Map<String, String> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean isSkipEmptyFilesEnabled() {
        return this.skipEmptyFiles;
    }

    public RuntimeStats getRuntimeStats() {
        return this.runtimeStats;
    }
}

