/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.BaseHiveColumnHandle;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.PartitionNameWithVersion;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.MaterializedViewDefinition;
import com.facebook.presto.spi.MaterializedViewStatus;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.joda.time.DateTimeZone;

public class HiveMaterializedViewUtils {
    private static final MaterializedViewStatus.MaterializedDataPredicates EMPTY_MATERIALIZED_VIEW_DATA_PREDICATES = new MaterializedViewStatus.MaterializedDataPredicates((List)ImmutableList.of(), (List)ImmutableList.of());

    private HiveMaterializedViewUtils() {
    }

    public static void validateMaterializedViewPartitionColumns(SemiTransactionalHiveMetastore metastore, MetastoreContext metastoreContext, Table viewTable, MaterializedViewDefinition viewDefinition) {
        SchemaTableName viewName = new SchemaTableName(viewTable.getDatabaseName(), viewTable.getTableName());
        Map viewToBaseDirectColumnMap = viewDefinition.getDirectColumnMappingsAsMap();
        if (viewToBaseDirectColumnMap.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Materialized view %s must have at least one column directly defined by a base table column.", viewName));
        }
        List viewPartitions = viewTable.getPartitionColumns();
        if (viewPartitions.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unpartitioned materialized view is not supported.");
        }
        List baseTables = (List)viewDefinition.getBaseTables().stream().map(baseTableName -> (Table)metastore.getTable(metastoreContext, baseTableName.getSchemaName(), baseTableName.getTableName()).orElseThrow(() -> new TableNotFoundException(baseTableName))).collect(ImmutableList.toImmutableList());
        Map baseTablePartitions = (Map)baseTables.stream().collect(ImmutableMap.toImmutableMap(table -> table, Table::getPartitionColumns));
        for (Table baseTable : baseTablePartitions.keySet()) {
            SchemaTableName schemaBaseTable = new SchemaTableName(baseTable.getDatabaseName(), baseTable.getTableName());
            if (!HiveMaterializedViewUtils.isCommonPartitionFound(schemaBaseTable, (List)baseTablePartitions.get(baseTable), viewPartitions, viewToBaseDirectColumnMap)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Materialized view %s must have at least one partition column that exists in %s as well", viewName, baseTable.getTableName()));
            }
            if (!viewDefinition.getBaseTablesOnOuterJoinSide().contains(schemaBaseTable) || !HiveMaterializedViewUtils.viewToBaseTableOnOuterJoinSideIndirectMappedPartitions(viewDefinition, baseTable).get().isEmpty()) continue;
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Outer join conditions in Materialized view %s must have at least one common partition equality constraint", viewName));
        }
    }

    private static boolean isCommonPartitionFound(SchemaTableName baseTable, List<Column> baseTablePartitions, List<Column> viewPartitions, Map<String, Map<SchemaTableName, String>> viewToBaseColumnMap) {
        for (Column viewPartition : viewPartitions) {
            for (Column basePartition : baseTablePartitions) {
                if (!viewToBaseColumnMap.getOrDefault(viewPartition.getName(), Collections.emptyMap()).getOrDefault(baseTable, "").equals(basePartition.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static MaterializedViewStatus.MaterializedDataPredicates getMaterializedDataPredicates(SemiTransactionalHiveMetastore metastore, MetastoreContext metastoreContext, TypeManager typeManager, Table table, DateTimeZone timeZone) {
        List partitionColumns = table.getPartitionColumns();
        for (Column partitionColumn : partitionColumns) {
            HiveType hiveType = partitionColumn.getType();
            if (hiveType.isSupportedType()) continue;
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type %s found in partition keys of table %s.%s", hiveType, table.getDatabaseName(), table.getTableName()));
        }
        List<HiveColumnHandle> partitionKeyColumnHandles = HiveUtil.getPartitionKeyColumnHandles(table);
        Map partitionTypes = (Map)partitionKeyColumnHandles.stream().collect(ImmutableMap.toImmutableMap(BaseHiveColumnHandle::getName, column -> typeManager.getType(column.getTypeSignature())));
        List partitionNames = (List)metastore.getPartitionNames(metastoreContext, table.getDatabaseName(), table.getTableName()).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(table.getDatabaseName(), table.getTableName())));
        ImmutableList.Builder partitionNamesAndValues = ImmutableList.builder();
        for (PartitionNameWithVersion partitionName : partitionNames) {
            ImmutableMap.Builder partitionNameAndValuesMap = ImmutableMap.builder();
            Map partitions = MetastoreUtil.toPartitionNamesAndValues((String)partitionName.getPartitionName());
            if (partitionColumns.size() != partitions.size()) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Expected %d partition key values, but got %d", partitionColumns.size(), partitions.size()));
            }
            partitionTypes.forEach((name, type) -> {
                String value = (String)partitions.get(name);
                if (value == null) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, String.format("partition key value cannot be null for field: %s", name));
                }
                partitionNameAndValuesMap.put(name, (Object)HiveUtil.parsePartitionValue(name, value, type, timeZone));
            });
            TupleDomain tupleDomain = TupleDomain.fromFixedValues((Map)partitionNameAndValuesMap.build());
            partitionNamesAndValues.add((Object)tupleDomain);
        }
        return new MaterializedViewStatus.MaterializedDataPredicates((List)partitionNamesAndValues.build(), (List)partitionColumns.stream().map(Column::getName).collect(ImmutableList.toImmutableList()));
    }

    public static Optional<Map<String, String>> viewToBaseTableOnOuterJoinSideIndirectMappedPartitions(MaterializedViewDefinition viewDefinition, Table baseTable) {
        SchemaTableName schemaBaseTable = new SchemaTableName(baseTable.getDatabaseName(), baseTable.getTableName());
        if (!viewDefinition.getBaseTablesOnOuterJoinSide().contains(schemaBaseTable)) {
            return Optional.empty();
        }
        HashMap<String, String> viewToBaseIndirectMappedColumns = new HashMap<String, String>();
        Map columnMappings = viewDefinition.getColumnMappingsAsMap();
        Map directColumnMappings = viewDefinition.getDirectColumnMappingsAsMap();
        for (String viewPartition : (List)viewDefinition.getValidRefreshColumns().orElse(ImmutableList.of())) {
            String baseTablePartition = (String)((Map)columnMappings.get(viewPartition)).get(schemaBaseTable);
            if (baseTable.getPartitionColumns().stream().noneMatch(col -> col.getName().equals(baseTablePartition)) || !((Map)directColumnMappings.get(viewPartition)).keySet().stream().allMatch(e -> !e.equals((Object)schemaBaseTable)) || !((Map)directColumnMappings.get(viewPartition)).keySet().stream().allMatch(t -> !viewDefinition.getBaseTablesOnOuterJoinSide().contains(t))) continue;
            viewToBaseIndirectMappedColumns.put(viewPartition, baseTablePartition);
        }
        return Optional.of(viewToBaseIndirectMappedColumns);
    }

    public static MaterializedViewStatus.MaterializedDataPredicates differenceDataPredicates(MaterializedViewStatus.MaterializedDataPredicates baseTablePredicatesInfo, MaterializedViewStatus.MaterializedDataPredicates viewPredicatesInfo, Map<String, String> viewToBaseTablePredicatesKeyMap) {
        return HiveMaterializedViewUtils.differenceDataPredicates(baseTablePredicatesInfo, viewPredicatesInfo, viewToBaseTablePredicatesKeyMap, (Map<String, String>)ImmutableMap.of());
    }

    public static MaterializedViewStatus.MaterializedDataPredicates differenceDataPredicates(MaterializedViewStatus.MaterializedDataPredicates baseTablePredicatesInfo, MaterializedViewStatus.MaterializedDataPredicates viewPredicatesInfo, Map<String, String> viewToBaseTablePredicatesKeyMap, Map<String, String> viewToBaseTableIndirectMap) {
        if (viewToBaseTablePredicatesKeyMap.isEmpty()) {
            return EMPTY_MATERIALIZED_VIEW_DATA_PREDICATES;
        }
        if (viewPredicatesInfo.isEmpty()) {
            return baseTablePredicatesInfo;
        }
        HashSet<String> baseTableMappedCommonKeys = new HashSet<String>();
        HashSet<Object> viewMappedCommonKeys = new HashSet<Object>();
        for (Object rightKey : viewPredicatesInfo.getColumnNames()) {
            String leftKey = viewToBaseTablePredicatesKeyMap.get(rightKey);
            if (leftKey == null || !baseTablePredicatesInfo.getColumnNames().contains(leftKey)) continue;
            baseTableMappedCommonKeys.add(leftKey);
            viewMappedCommonKeys.add(rightKey);
        }
        if (baseTableMappedCommonKeys.isEmpty()) {
            return EMPTY_MATERIALIZED_VIEW_DATA_PREDICATES;
        }
        HashSet viewPredicatesMappedToBaseTableCommonKeys = new HashSet();
        for (TupleDomain rightPredicate : viewPredicatesInfo.getPredicateDisjuncts()) {
            LinkedHashMap viewPredicateKeyValue = HiveMaterializedViewUtils.getLinkedHashMap((Map)TupleDomain.extractFixedValues((TupleDomain)rightPredicate).orElseThrow(() -> new IllegalStateException("rightPredicateKeyValue is not present!")));
            LinkedHashMap viewPredicateMappedToBaseTableCommonKeys = HiveMaterializedViewUtils.getLinkedHashMap((Map)viewPredicateKeyValue.keySet().stream().filter(viewMappedCommonKeys::contains).collect(TupleDomain.toLinkedMap(viewToBaseTablePredicatesKeyMap::get, viewPredicateKeyValue::get)));
            viewToBaseTableIndirectMap.entrySet().forEach(e -> {
                NullableValue cfr_ignored_0 = (NullableValue)viewPredicateMappedToBaseTableCommonKeys.put(e.getValue(), viewPredicateKeyValue.get(e.getKey()));
            });
            viewPredicatesMappedToBaseTableCommonKeys.add(viewPredicateMappedToBaseTableCommonKeys);
        }
        ImmutableList.Builder difference = ImmutableList.builder();
        for (TupleDomain leftPredicate : baseTablePredicatesInfo.getPredicateDisjuncts()) {
            LinkedHashMap baseTablePredicateKeyValue = HiveMaterializedViewUtils.getLinkedHashMap((Map)TupleDomain.extractFixedValues((TupleDomain)leftPredicate).orElseThrow(() -> new IllegalStateException("leftPredicateKeyValue is not present!")));
            LinkedHashMap<String, NullableValue> baseTablePredicateMappedToBaseTableCommonKeys = HiveMaterializedViewUtils.getLinkedHashMap(baseTablePredicateKeyValue.keySet().stream().filter(baseTableMappedCommonKeys::contains).collect(Collectors.toMap(columnName -> columnName, baseTablePredicateKeyValue::get)));
            if (!viewPredicatesMappedToBaseTableCommonKeys.contains(baseTablePredicateMappedToBaseTableCommonKeys)) {
                difference.add((Object)leftPredicate);
                continue;
            }
            if (viewToBaseTableIndirectMap.isEmpty()) continue;
            LinkedHashMap<String, NullableValue> baseTablePredicateMappedToBaseTableAllKeys = HiveMaterializedViewUtils.getLinkedHashMap(baseTablePredicateKeyValue.keySet().stream().filter(baseTableMappedCommonKeys::contains).collect(Collectors.toMap(columnName -> columnName, columnName -> NullableValue.asNull((Type)((NullableValue)baseTablePredicateKeyValue.get(columnName)).getType()))));
            viewToBaseTableIndirectMap.entrySet().forEach(e -> {
                NullableValue cfr_ignored_0 = (NullableValue)baseTablePredicateMappedToBaseTableAllKeys.put((String)e.getValue(), (NullableValue)baseTablePredicateKeyValue.get(e.getValue()));
            });
            if (viewPredicatesMappedToBaseTableCommonKeys.contains(baseTablePredicateMappedToBaseTableCommonKeys)) continue;
            difference.add((Object)leftPredicate);
        }
        return new MaterializedViewStatus.MaterializedDataPredicates((List)difference.build(), baseTablePredicatesInfo.getColumnNames());
    }

    public static MaterializedViewStatus.MaterializedDataPredicates getEmptyMaterializedViewDataPredicates() {
        return EMPTY_MATERIALIZED_VIEW_DATA_PREDICATES;
    }

    private static <K, V> LinkedHashMap<K, V> getLinkedHashMap(Map<K, V> map) {
        return map instanceof LinkedHashMap ? (LinkedHashMap)map : new LinkedHashMap<K, V>(map);
    }

    public static Map<SchemaTableName, Map<String, String>> getViewToBasePartitionMap(Table view, List<Table> baseTables, Map<String, Map<SchemaTableName, String>> viewToBaseColumnMap) {
        List viewPartitions = view.getPartitionColumns().stream().map(Column::getName).collect(Collectors.toList());
        Map<SchemaTableName, List> baseTablePartitions = baseTables.stream().collect(Collectors.toMap(table -> new SchemaTableName(table.getDatabaseName(), table.getTableName()), table -> (ImmutableList)table.getPartitionColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList())));
        ImmutableMap.Builder viewToBasePartitionMap = ImmutableMap.builder();
        for (SchemaTableName baseTable : baseTablePartitions.keySet()) {
            HashMap<String, String> partitionMap = new HashMap<String, String>();
            for (String viewPartition : viewPartitions) {
                for (String basePartition : baseTablePartitions.get(baseTable)) {
                    if (!viewToBaseColumnMap.containsKey(viewPartition) || !viewToBaseColumnMap.get(viewPartition).containsKey(baseTable) || !viewToBaseColumnMap.get(viewPartition).get(baseTable).equals(basePartition)) continue;
                    partitionMap.put(viewPartition, basePartition);
                }
            }
            if (partitionMap.isEmpty()) continue;
            viewToBasePartitionMap.put((Object)baseTable, (Object)ImmutableMap.copyOf(partitionMap));
        }
        return viewToBasePartitionMap.build();
    }
}

