/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.hive.BaseHiveColumnHandle;
import com.facebook.presto.hive.HiveBucketHandle;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.spi.ColumnHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HivePartitionResult {
    private final List<BaseHiveColumnHandle> partitionColumns;
    private final List<Column> dataColumns;
    private final Map<String, String> tableParameters;
    private final List<HivePartition> partitions;
    private final TupleDomain<? extends ColumnHandle> effectivePredicate;
    private final TupleDomain<ColumnHandle> unenforcedConstraint;
    private final TupleDomain<ColumnHandle> enforcedConstraint;
    private final Optional<HiveBucketHandle> bucketHandle;
    private final Optional<HiveBucketing.HiveBucketFilter> bucketFilter;

    public HivePartitionResult(List<BaseHiveColumnHandle> partitionColumns, List<Column> dataColumns, Map<String, String> tableParameters, List<HivePartition> partitions, TupleDomain<? extends ColumnHandle> effectivePredicate, TupleDomain<ColumnHandle> unenforcedConstraint, TupleDomain<ColumnHandle> enforcedConstraint, Optional<HiveBucketHandle> bucketHandle, Optional<HiveBucketing.HiveBucketFilter> bucketFilter) {
        this.partitionColumns = Objects.requireNonNull(partitionColumns, "partitionColumns is null");
        this.dataColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(dataColumns, "dataColumns is null"));
        this.tableParameters = ImmutableMap.copyOf(Objects.requireNonNull(tableParameters, "tableProperties is null"));
        this.partitions = Objects.requireNonNull(partitions, "partitions is null");
        this.effectivePredicate = Objects.requireNonNull(effectivePredicate, "effectivePredicate is null");
        this.unenforcedConstraint = Objects.requireNonNull(unenforcedConstraint, "unenforcedConstraint is null");
        this.enforcedConstraint = Objects.requireNonNull(enforcedConstraint, "enforcedConstraint is null");
        this.bucketHandle = Objects.requireNonNull(bucketHandle, "bucketHandle is null");
        this.bucketFilter = Objects.requireNonNull(bucketFilter, "bucketFilter is null");
    }

    public List<BaseHiveColumnHandle> getPartitionColumns() {
        return this.partitionColumns;
    }

    public List<Column> getDataColumns() {
        return this.dataColumns;
    }

    public Map<String, String> getTableParameters() {
        return this.tableParameters;
    }

    public List<HivePartition> getPartitions() {
        return this.partitions;
    }

    public TupleDomain<? extends ColumnHandle> getEffectivePredicate() {
        return this.effectivePredicate;
    }

    public TupleDomain<ColumnHandle> getUnenforcedConstraint() {
        return this.unenforcedConstraint;
    }

    public TupleDomain<ColumnHandle> getEnforcedConstraint() {
        return this.enforcedConstraint;
    }

    public Optional<HiveBucketHandle> getBucketHandle() {
        return this.bucketHandle;
    }

    public Optional<HiveBucketing.HiveBucketFilter> getBucketFilter() {
        return this.bucketFilter;
    }
}

