/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.CacheQuotaRequirement;
import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveFileSplit;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.TableToPartitionMapping;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeProvider;
import com.facebook.presto.spi.SplitWeight;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;

public class HiveSplit
implements ConnectorSplit {
    private final HiveFileSplit fileSplit;
    private final Storage storage;
    private final List<HivePartitionKey> partitionKeys;
    private final List<HostAddress> addresses;
    private final String database;
    private final String table;
    private final String partitionName;
    private final OptionalInt readBucketNumber;
    private final OptionalInt tableBucketNumber;
    private final NodeSelectionStrategy nodeSelectionStrategy;
    private final int partitionDataColumnCount;
    private final TableToPartitionMapping tableToPartitionMapping;
    private final Optional<BucketConversion> bucketConversion;
    private final boolean s3SelectPushdownEnabled;
    private final CacheQuotaRequirement cacheQuotaRequirement;
    private final Optional<EncryptionInformation> encryptionInformation;
    private final Set<ColumnHandle> redundantColumnDomains;
    private final SplitWeight splitWeight;
    private final Optional<byte[]> rowIdPartitionComponent;

    @JsonCreator
    public HiveSplit(@JsonProperty(value="fileSplit") HiveFileSplit fileSplit, @JsonProperty(value="database") String database, @JsonProperty(value="table") String table, @JsonProperty(value="partitionName") String partitionName, @JsonProperty(value="storage") Storage storage, @JsonProperty(value="partitionKeys") List<HivePartitionKey> partitionKeys, @JsonProperty(value="addresses") List<HostAddress> addresses, @JsonProperty(value="readBucketNumber") OptionalInt readBucketNumber, @JsonProperty(value="tableBucketNumber") OptionalInt tableBucketNumber, @JsonProperty(value="nodeSelectionStrategy") NodeSelectionStrategy nodeSelectionStrategy, @JsonProperty(value="partitionDataColumnCount") int partitionDataColumnCount, @JsonProperty(value="tableToPartitionMapping") TableToPartitionMapping tableToPartitionMapping, @JsonProperty(value="bucketConversion") Optional<BucketConversion> bucketConversion, @JsonProperty(value="s3SelectPushdownEnabled") boolean s3SelectPushdownEnabled, @JsonProperty(value="cacheQuota") CacheQuotaRequirement cacheQuotaRequirement, @JsonProperty(value="encryptionMetadata") Optional<EncryptionInformation> encryptionInformation, @JsonProperty(value="redundantColumnDomains") Set<ColumnHandle> redundantColumnDomains, @JsonProperty(value="splitWeight") SplitWeight splitWeight, @JsonProperty(value="rowIdPartitionComponent") Optional<byte[]> rowIdPartitionComponent) {
        Objects.requireNonNull(fileSplit, "fileSplit is null");
        Objects.requireNonNull(database, "database is null");
        Objects.requireNonNull(table, "table is null");
        Objects.requireNonNull(partitionName, "partitionName is null");
        Objects.requireNonNull(storage, "storage is null");
        Objects.requireNonNull(partitionKeys, "partitionKeys is null");
        Objects.requireNonNull(addresses, "addresses is null");
        Objects.requireNonNull(readBucketNumber, "readBucketNumber is null");
        Objects.requireNonNull(tableBucketNumber, "tableBucketNumber is null");
        Objects.requireNonNull(nodeSelectionStrategy, "nodeSelectionStrategy is null");
        Objects.requireNonNull(tableToPartitionMapping, "tableToPartitionMapping is null");
        Objects.requireNonNull(bucketConversion, "bucketConversion is null");
        Objects.requireNonNull(cacheQuotaRequirement, "cacheQuotaRequirement is null");
        Objects.requireNonNull(encryptionInformation, "encryptionMetadata is null");
        Objects.requireNonNull(redundantColumnDomains, "redundantColumnDomains is null");
        Objects.requireNonNull(rowIdPartitionComponent, "rowIdPartitionComponent is null");
        this.fileSplit = fileSplit;
        this.database = database;
        this.table = table;
        this.partitionName = partitionName;
        this.storage = storage;
        this.partitionKeys = ImmutableList.copyOf(partitionKeys);
        this.addresses = ImmutableList.copyOf(addresses);
        this.readBucketNumber = readBucketNumber;
        this.tableBucketNumber = tableBucketNumber;
        this.nodeSelectionStrategy = nodeSelectionStrategy;
        this.partitionDataColumnCount = partitionDataColumnCount;
        this.tableToPartitionMapping = tableToPartitionMapping;
        this.bucketConversion = bucketConversion;
        this.s3SelectPushdownEnabled = s3SelectPushdownEnabled;
        this.cacheQuotaRequirement = cacheQuotaRequirement;
        this.encryptionInformation = encryptionInformation;
        this.redundantColumnDomains = ImmutableSet.copyOf(redundantColumnDomains);
        this.splitWeight = Objects.requireNonNull(splitWeight, "splitWeight is null");
        this.rowIdPartitionComponent = rowIdPartitionComponent;
    }

    @JsonProperty
    public HiveFileSplit getFileSplit() {
        return this.fileSplit;
    }

    @JsonProperty
    public String getDatabase() {
        return this.database;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    @JsonProperty
    public String getPartitionName() {
        return this.partitionName;
    }

    @JsonProperty
    public Storage getStorage() {
        return this.storage;
    }

    @JsonProperty
    public List<HivePartitionKey> getPartitionKeys() {
        return this.partitionKeys;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public List<HostAddress> getPreferredNodes(NodeProvider nodeProvider) {
        if (this.getNodeSelectionStrategy() == NodeSelectionStrategy.SOFT_AFFINITY) {
            return nodeProvider.get(this.fileSplit.getPath() + "#" + this.fileSplit.getAffinitySchedulingFileSectionIndex());
        }
        return this.addresses;
    }

    @JsonProperty
    public OptionalInt getReadBucketNumber() {
        return this.readBucketNumber;
    }

    @JsonProperty
    public OptionalInt getTableBucketNumber() {
        return this.tableBucketNumber;
    }

    @JsonProperty
    public int getPartitionDataColumnCount() {
        return this.partitionDataColumnCount;
    }

    @JsonProperty
    public TableToPartitionMapping getTableToPartitionMapping() {
        return this.tableToPartitionMapping;
    }

    @JsonProperty
    public Optional<BucketConversion> getBucketConversion() {
        return this.bucketConversion;
    }

    @JsonProperty
    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return this.nodeSelectionStrategy;
    }

    @JsonProperty
    public boolean isS3SelectPushdownEnabled() {
        return this.s3SelectPushdownEnabled;
    }

    @JsonProperty
    public CacheQuotaRequirement getCacheQuotaRequirement() {
        return this.cacheQuotaRequirement;
    }

    @JsonProperty
    public Optional<EncryptionInformation> getEncryptionInformation() {
        return this.encryptionInformation;
    }

    @JsonProperty
    public Set<ColumnHandle> getRedundantColumnDomains() {
        return this.redundantColumnDomains;
    }

    @JsonProperty
    public SplitWeight getSplitWeight() {
        return this.splitWeight;
    }

    @JsonProperty
    public Optional<byte[]> getRowIdPartitionComponent() {
        return this.rowIdPartitionComponent;
    }

    public Object getInfo() {
        return ImmutableMap.builder().put((Object)"path", (Object)this.fileSplit.getPath()).put((Object)"start", (Object)this.fileSplit.getStart()).put((Object)"length", (Object)this.fileSplit.getLength()).put((Object)"fileSize", (Object)this.fileSplit.getFileSize()).put((Object)"fileModifiedTime", (Object)this.fileSplit.getFileModifiedTime()).put((Object)"hosts", this.addresses).put((Object)"database", (Object)this.database).put((Object)"table", (Object)this.table).put((Object)"nodeSelectionStrategy", (Object)this.nodeSelectionStrategy).put((Object)"partitionName", (Object)this.partitionName).put((Object)"s3SelectPushdownEnabled", (Object)this.s3SelectPushdownEnabled).put((Object)"cacheQuotaRequirement", (Object)this.cacheQuotaRequirement).build();
    }

    public Map<String, String> getInfoMap() {
        return ImmutableMap.builder().put((Object)"path", (Object)this.fileSplit.getPath()).put((Object)"start", (Object)Long.toString(this.fileSplit.getStart())).put((Object)"length", (Object)Long.toString(this.fileSplit.getLength())).put((Object)"fileSize", (Object)Long.toString(this.fileSplit.getFileSize())).put((Object)"fileModifiedTime", (Object)Long.toString(this.fileSplit.getFileModifiedTime())).put((Object)"hosts", (Object)this.addresses.toString()).put((Object)"database", (Object)this.database).put((Object)"table", (Object)this.table).put((Object)"nodeSelectionStrategy", (Object)this.nodeSelectionStrategy.toString()).put((Object)"partitionName", (Object)this.partitionName).put((Object)"s3SelectPushdownEnabled", (Object)Boolean.toString(this.s3SelectPushdownEnabled)).put((Object)"cacheQuotaRequirement", (Object)this.cacheQuotaRequirement.toString()).put((Object)"readBucketNumber", (Object)this.readBucketNumber.toString()).put((Object)"tableBucketNumber", (Object)this.tableBucketNumber.toString()).build();
    }

    public Object getSplitIdentifier() {
        return ImmutableMap.builder().put((Object)"path", (Object)this.fileSplit.getPath()).put((Object)"start", (Object)this.fileSplit.getStart()).put((Object)"length", (Object)this.fileSplit.getLength()).build();
    }

    public OptionalLong getSplitSizeInBytes() {
        return OptionalLong.of(this.fileSplit.getLength());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.fileSplit.getPath()).addValue(this.fileSplit.getStart()).addValue(this.fileSplit.getLength()).addValue(this.fileSplit.getFileSize()).addValue(this.s3SelectPushdownEnabled).addValue((Object)this.cacheQuotaRequirement).toString();
    }

    public static class BucketConversion {
        private final int tableBucketCount;
        private final int partitionBucketCount;
        private final List<HiveColumnHandle> bucketColumnNames;

        @JsonCreator
        public BucketConversion(@JsonProperty(value="tableBucketCount") int tableBucketCount, @JsonProperty(value="partitionBucketCount") int partitionBucketCount, @JsonProperty(value="bucketColumnHandles") List<HiveColumnHandle> bucketColumnHandles) {
            this.tableBucketCount = tableBucketCount;
            this.partitionBucketCount = partitionBucketCount;
            this.bucketColumnNames = Objects.requireNonNull(bucketColumnHandles, "bucketColumnHandles is null");
        }

        @JsonProperty
        public int getTableBucketCount() {
            return this.tableBucketCount;
        }

        @JsonProperty
        public int getPartitionBucketCount() {
            return this.partitionBucketCount;
        }

        @JsonProperty
        public List<HiveColumnHandle> getBucketColumnHandles() {
            return this.bucketColumnNames;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BucketConversion that = (BucketConversion)o;
            return this.tableBucketCount == that.tableBucketCount && this.partitionBucketCount == that.partitionBucketCount && Objects.equals(this.bucketColumnNames, that.bucketColumnNames);
        }

        public int hashCode() {
            return Objects.hash(this.tableBucketCount, this.partitionBucketCount, this.bucketColumnNames);
        }
    }
}

