/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.concurrent.BoundedExecutor;
import com.facebook.airlift.stats.CounterStat;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.SortedRangeSet;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.FixedWidthType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.BackgroundHiveSplitLoader;
import com.facebook.presto.hive.BaseHiveColumnHandle;
import com.facebook.presto.hive.CacheQuotaRequirement;
import com.facebook.presto.hive.CacheQuotaRequirementProvider;
import com.facebook.presto.hive.CoercionPolicy;
import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.ForHiveClient;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBucketHandle;
import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveCommonSessionProperties;
import com.facebook.presto.hive.HiveEncryptionInformationProvider;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveNotReadableException;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.HivePartitionMetadata;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveSplitLoader;
import com.facebook.presto.hive.HiveSplitSource;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveTableLayoutHandle;
import com.facebook.presto.hive.HiveTransactionManager;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveWarningCode;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.PartitionSkippabilityChecker;
import com.facebook.presto.hive.StoragePartitionLoader;
import com.facebook.presto.hive.TableToPartitionMapping;
import com.facebook.presto.hive.TransactionalMetadata;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.DateStatistics;
import com.facebook.presto.hive.metastore.DecimalStatistics;
import com.facebook.presto.hive.metastore.DoubleStatistics;
import com.facebook.presto.hive.metastore.HiveColumnStatistics;
import com.facebook.presto.hive.metastore.IntegerStatistics;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.WarningCodeSupplier;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.statistics.ColumnStatistics;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import io.airlift.units.DataSize;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.hadoop.hive.metastore.ProtectMode;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hudi.hadoop.HoodieParquetInputFormat;
import org.apache.hudi.hadoop.realtime.HoodieParquetRealtimeInputFormat;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class HiveSplitManager
implements ConnectorSplitManager {
    public static final String OBJECT_NOT_READABLE = "object_not_readable";
    private final HiveTransactionManager hiveTransactionManager;
    private final NamenodeStats namenodeStats;
    private final HdfsEnvironment hdfsEnvironment;
    private final DirectoryLister directoryLister;
    private final Executor executor;
    private final CoercionPolicy coercionPolicy;
    private final int maxOutstandingSplits;
    private final DataSize maxOutstandingSplitsSize;
    private final int minPartitionBatchSize;
    private final int maxPartitionBatchSize;
    private final int splitLoaderConcurrency;
    private final boolean recursiveDfsWalkerEnabled;
    private final CounterStat highMemorySplitSourceCounter;
    private final CacheQuotaRequirementProvider cacheQuotaRequirementProvider;
    private final HiveEncryptionInformationProvider encryptionInformationProvider;
    private final PartitionSkippabilityChecker partitionSkippabilityChecker;

    @Inject
    public HiveSplitManager(HiveClientConfig hiveClientConfig, CacheQuotaRequirementProvider cacheQuotaRequirementProvider, HiveTransactionManager hiveTransactionManager, NamenodeStats namenodeStats, HdfsEnvironment hdfsEnvironment, DirectoryLister directoryLister, @ForHiveClient ExecutorService executorService, CoercionPolicy coercionPolicy, HiveEncryptionInformationProvider encryptionInformationProvider, PartitionSkippabilityChecker partitionSkippabilityChecker) {
        this(hiveTransactionManager, namenodeStats, hdfsEnvironment, directoryLister, (Executor)new BoundedExecutor((Executor)executorService, hiveClientConfig.getMaxSplitIteratorThreads()), coercionPolicy, new CounterStat(), hiveClientConfig.getMaxOutstandingSplits(), hiveClientConfig.getMaxOutstandingSplitsSize(), hiveClientConfig.getMinPartitionBatchSize(), hiveClientConfig.getMaxPartitionBatchSize(), hiveClientConfig.getSplitLoaderConcurrency(), hiveClientConfig.getRecursiveDirWalkerEnabled(), cacheQuotaRequirementProvider, encryptionInformationProvider, partitionSkippabilityChecker);
    }

    public HiveSplitManager(HiveTransactionManager hiveTransactionManager, NamenodeStats namenodeStats, HdfsEnvironment hdfsEnvironment, DirectoryLister directoryLister, Executor executor, CoercionPolicy coercionPolicy, CounterStat highMemorySplitSourceCounter, int maxOutstandingSplits, DataSize maxOutstandingSplitsSize, int minPartitionBatchSize, int maxPartitionBatchSize, int splitLoaderConcurrency, boolean recursiveDfsWalkerEnabled, CacheQuotaRequirementProvider cacheQuotaRequirementProvider, HiveEncryptionInformationProvider encryptionInformationProvider, PartitionSkippabilityChecker partitionSkippabilityChecker) {
        this.hiveTransactionManager = Objects.requireNonNull(hiveTransactionManager, "hiveTransactionManager is null");
        this.namenodeStats = Objects.requireNonNull(namenodeStats, "namenodeStats is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.directoryLister = Objects.requireNonNull(directoryLister, "directoryLister is null");
        this.executor = new ErrorCodedExecutor(executor);
        this.coercionPolicy = Objects.requireNonNull(coercionPolicy, "coercionPolicy is null");
        this.highMemorySplitSourceCounter = Objects.requireNonNull(highMemorySplitSourceCounter, "highMemorySplitSourceCounter is null");
        Preconditions.checkArgument((maxOutstandingSplits >= 1 ? 1 : 0) != 0, (Object)"maxOutstandingSplits must be at least 1");
        this.maxOutstandingSplits = maxOutstandingSplits;
        this.maxOutstandingSplitsSize = maxOutstandingSplitsSize;
        this.minPartitionBatchSize = minPartitionBatchSize;
        this.maxPartitionBatchSize = maxPartitionBatchSize;
        this.splitLoaderConcurrency = splitLoaderConcurrency;
        this.recursiveDfsWalkerEnabled = recursiveDfsWalkerEnabled;
        this.cacheQuotaRequirementProvider = Objects.requireNonNull(cacheQuotaRequirementProvider, "cacheQuotaRequirementProvider is null");
        this.encryptionInformationProvider = Objects.requireNonNull(encryptionInformationProvider, "encryptionInformationProvider is null");
        this.partitionSkippabilityChecker = Objects.requireNonNull(partitionSkippabilityChecker, "partitionSkippabilityChecker is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableLayoutHandle layoutHandle, ConnectorSplitManager.SplitSchedulingContext splitSchedulingContext) {
        String tableNotReadable;
        HiveTableLayoutHandle layout = (HiveTableLayoutHandle)layoutHandle;
        SchemaTableName tableName = layout.getSchemaTableName();
        TransactionalMetadata metadata = this.hiveTransactionManager.get(transaction);
        if (metadata == null) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TRANSACTION_NOT_FOUND, String.format("Transaction not found: %s", transaction));
        }
        SemiTransactionalHiveMetastore metastore = metadata.getMetastore();
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getClientTags(), session.getSource(), MetastoreUtil.getMetastoreHeaders((ConnectorSession)session), MetastoreUtil.isUserDefinedTypeEncodingEnabled((ConnectorSession)session), metastore.getColumnConverterProvider(), session.getWarningCollector(), session.getRuntimeStats());
        Table table = layout.getTable(metastore, metastoreContext);
        if (!HiveSessionProperties.isOfflineDataDebugModeEnabled(session) && !Strings.isNullOrEmpty((String)(tableNotReadable = (String)table.getParameters().get(OBJECT_NOT_READABLE)))) {
            throw new HiveNotReadableException(tableName, Optional.empty(), tableNotReadable);
        }
        List partitions = (List)layout.getPartitions().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Layout does not contain partitions"));
        HivePartition partition = (HivePartition)Iterables.getFirst((Iterable)partitions, null);
        if (partition == null) {
            return new FixedSplitSource((Iterable)ImmutableList.of());
        }
        Optional<HiveBucketing.HiveBucketFilter> bucketFilter = layout.getBucketFilter();
        Optional<HiveBucketHandle> bucketHandle = layout.getBucketHandle();
        if (splitSchedulingContext.getSplitSchedulingStrategy() == ConnectorSplitManager.SplitSchedulingStrategy.GROUPED_SCHEDULING && !bucketHandle.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "SchedulingPolicy is bucketed, but BucketHandle is not present");
        }
        if (bucketHandle.isPresent() && bucketHandle.get().getReadBucketCount() > bucketHandle.get().getTableBucketCount()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "readBucketCount (%s) is greater than the tableBucketCount (%s) which generally points to an issue in plan generation");
        }
        partitions = Ordering.natural().onResultOf(HivePartition::getPartitionId).reverse().sortedCopy((Iterable)partitions);
        Iterable<HivePartitionMetadata> hivePartitions = this.getPartitionMetadata(metastore, table, tableName, partitions, bucketHandle, session, splitSchedulingContext.getWarningCollector(), layout.getRequestedColumns(), layout.getPredicateColumns(), layout.getDomainPredicate().getDomains());
        double ratio = this.getSplitScanRatio(session, tableName, layout, metadata, partitions);
        BackgroundHiveSplitLoader hiveSplitLoader = new BackgroundHiveSplitLoader(table, hivePartitions, HiveSplitManager.getInfoColumnConstraints((TupleDomain<Subfield>)layout.getDomainPredicate(), layout.getPredicateColumns()), StoragePartitionLoader.BucketSplitInfo.createBucketSplitInfo(bucketHandle, bucketFilter), session, this.hdfsEnvironment, this.namenodeStats, this.directoryLister, this.executor, Math.min(this.splitLoaderConcurrency, partitions.size()), this.recursiveDfsWalkerEnabled, splitSchedulingContext.schedulerUsesHostAddresses(), layout.isPartialAggregationsPushedDown());
        HiveSplitSource splitSource = this.computeSplitSource(splitSchedulingContext, table, session, hiveSplitLoader, ratio);
        hiveSplitLoader.start(splitSource);
        return splitSource;
    }

    private double getSplitScanRatio(ConnectorSession session, SchemaTableName tableName, HiveTableLayoutHandle layout, TransactionalMetadata metadata, List<HivePartition> partitions) {
        if (!HiveSessionProperties.isDynamicSplitSizesEnabled(session)) {
            return 1.0;
        }
        HiveTableHandle hiveTableHandle = new HiveTableHandle(tableName.getSchemaName(), tableName.getTableName());
        Set readColumnHandles = HiveSplitManager.mergeRequestedAndPredicateColumns(layout.getRequestedColumns(), (Set)layout.getPredicateColumns().values().stream().collect(ImmutableSet.toImmutableSet())).orElseGet(ImmutableSet::of);
        Map readColumnTypes = (Map)readColumnHandles.stream().collect(ImmutableMap.toImmutableMap(BaseHiveColumnHandle::getName, handle -> metadata.getColumnMetadata(session, (ConnectorTableHandle)hiveTableHandle, (ColumnHandle)handle).getType()));
        Map readColumns = (Map)readColumnHandles.stream().collect(ImmutableMap.toImmutableMap(BaseHiveColumnHandle::getName, Function.identity()));
        TableStatistics tableStatistics = metadata.getHiveStatisticsProvider().getTableStatistics(session, tableName, readColumns, readColumnTypes, partitions);
        double totalSize = tableStatistics.getTotalSize().getValue();
        double readSize = 0.0;
        double rowCount = tableStatistics.getRowCount().getValue();
        for (Map.Entry entry : tableStatistics.getColumnStatistics().entrySet()) {
            HiveColumnHandle columnHandle;
            Type type;
            double value = ((ColumnStatistics)entry.getValue()).getDataSize().getValue();
            if (!Double.isFinite(value) && Double.isFinite(rowCount) && (type = metadata.getColumnMetadata(session, (ConnectorTableHandle)hiveTableHandle, (ColumnHandle)(columnHandle = (HiveColumnHandle)((Object)entry.getKey()))).getType()) instanceof FixedWidthType) {
                int size = ((FixedWidthType)type).getFixedSize();
                value = (double)size * rowCount;
            }
            readSize += value;
        }
        if (totalSize > 0.0 && Double.isFinite(totalSize) && Double.isFinite(readSize)) {
            return readSize / totalSize;
        }
        return 1.0;
    }

    private HiveSplitSource computeSplitSource(ConnectorSplitManager.SplitSchedulingContext splitSchedulingContext, Table table, ConnectorSession session, HiveSplitLoader hiveSplitLoader, double splitScanRatio) {
        HiveSplitSource splitSource;
        CacheQuotaRequirement cacheQuotaRequirement = this.cacheQuotaRequirementProvider.getCacheQuotaRequirement(table.getDatabaseName(), table.getTableName());
        switch (splitSchedulingContext.getSplitSchedulingStrategy()) {
            case UNGROUPED_SCHEDULING: {
                splitSource = HiveSplitSource.allAtOnce(session, table.getDatabaseName(), table.getTableName(), cacheQuotaRequirement, HiveSessionProperties.getHiveMaxInitialSplitSize(session), this.maxOutstandingSplits, this.maxOutstandingSplitsSize, hiveSplitLoader, this.executor, new CounterStat(), splitScanRatio);
                break;
            }
            case GROUPED_SCHEDULING: {
                splitSource = HiveSplitSource.bucketed(session, table.getDatabaseName(), table.getTableName(), cacheQuotaRequirement, HiveSessionProperties.getHiveMaxInitialSplitSize(session), this.maxOutstandingSplits, this.maxOutstandingSplitsSize, hiveSplitLoader, this.executor, new CounterStat(), splitScanRatio);
                break;
            }
            case REWINDABLE_GROUPED_SCHEDULING: {
                splitSource = HiveSplitSource.bucketedRewindable(session, table.getDatabaseName(), table.getTableName(), cacheQuotaRequirement, HiveSessionProperties.getHiveMaxInitialSplitSize(session), this.maxOutstandingSplitsSize, hiveSplitLoader, this.executor, new CounterStat(), splitScanRatio);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown splitSchedulingStrategy: " + splitSchedulingContext.getSplitSchedulingStrategy());
            }
        }
        return splitSource;
    }

    private static Map<Integer, Domain> getInfoColumnConstraints(TupleDomain<Subfield> domainPredicate, Map<String, HiveColumnHandle> predicateColumns) {
        Preconditions.checkArgument((!domainPredicate.isNone() ? 1 : 0) != 0, (Object)"Unexpected domain predicate: none");
        if (domainPredicate.getDomains().isPresent()) {
            return ((Map)domainPredicate.getDomains().get()).entrySet().stream().filter(kv -> HiveColumnHandle.isInfoColumnHandle((HiveColumnHandle)((Object)((Object)predicateColumns.get(((Subfield)kv.getKey()).getRootName()))))).collect(Collectors.toMap(e -> ((HiveColumnHandle)((Object)((Object)predicateColumns.get(((Subfield)e.getKey()).getRootName())))).getHiveColumnIndex(), e -> (Domain)e.getValue()));
        }
        return ImmutableMap.of();
    }

    @Managed
    @Nested
    public CounterStat getHighMemorySplitSource() {
        return this.highMemorySplitSourceCounter;
    }

    private Iterable<HivePartitionMetadata> getPartitionMetadata(SemiTransactionalHiveMetastore metastore, Table table, SchemaTableName tableName, List<HivePartition> hivePartitions, Optional<HiveBucketHandle> hiveBucketHandle, ConnectorSession session, WarningCollector warningCollector, Optional<Set<HiveColumnHandle>> requestedColumns, Map<String, HiveColumnHandle> predicateColumns, Optional<Map<Subfield, Domain>> domains) {
        HivePartition firstPartition;
        if (hivePartitions.isEmpty()) {
            return ImmutableList.of();
        }
        Optional<Set<HiveColumnHandle>> allRequestedColumns = HiveSplitManager.mergeRequestedAndPredicateColumns(requestedColumns, (Set<HiveColumnHandle>)ImmutableSet.copyOf(predicateColumns.values()));
        if (hivePartitions.size() == 1 && (firstPartition = (HivePartition)Iterables.getOnlyElement(hivePartitions)).getPartitionId().equals((Object)HivePartition.UNPARTITIONED_ID)) {
            return ImmutableList.of((Object)new HivePartitionMetadata(firstPartition, Optional.empty(), TableToPartitionMapping.empty(), this.encryptionInformationProvider.getReadEncryptionInformation(session, table, allRequestedColumns), (Set<ColumnHandle>)ImmutableSet.of(), Optional.empty()));
        }
        StorageFormat storageFormat = table.getStorage().getStorageFormat();
        Optional<HiveStorageFormat> hiveStorageFormat = HiveStorageFormat.getHiveStorageFormat((StorageFormat)storageFormat);
        Optional<HiveStorageFormat> resolvedHiveStorageFormat = HiveCommonSessionProperties.isUseParquetColumnNames((ConnectorSession)session) ? (!hiveStorageFormat.isPresent() && this.isHudiFormat(storageFormat) ? Optional.of(HiveStorageFormat.PARQUET) : hiveStorageFormat) : hiveStorageFormat;
        Iterable<List<HivePartition>> partitionNameBatches = HiveSplitManager.partitionExponentially(hivePartitions, this.minPartitionBatchSize, this.maxPartitionBatchSize);
        Iterable<List<HivePartitionMetadata>> partitionBatches = this.computePartitionMetadata(partitionNameBatches, session, table, metastore, tableName, predicateColumns, domains, allRequestedColumns, hiveBucketHandle, resolvedHiveStorageFormat, warningCollector);
        return Iterables.concat(partitionBatches);
    }

    private Iterable<List<HivePartitionMetadata>> computePartitionMetadata(Iterable<List<HivePartition>> partitionNameBatches, ConnectorSession session, Table table, SemiTransactionalHiveMetastore metastore, SchemaTableName tableName, Map<String, HiveColumnHandle> predicateColumns, Optional<Map<Subfield, Domain>> domains, Optional<Set<HiveColumnHandle>> allRequestedColumns, Optional<HiveBucketHandle> hiveBucketHandle, Optional<HiveStorageFormat> resolvedHiveStorageFormat, WarningCollector warningCollector) {
        Iterable partitionBatches = Iterables.transform(partitionNameBatches, partitionBatch -> {
            Map<String, PartitionSplitInfo> partitionSplitInfo = this.getPartitionSplitInfo(session, metastore, tableName, (List<HivePartition>)partitionBatch, predicateColumns, domains);
            if (partitionBatch.size() != partitionSplitInfo.size()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Expected %s partitions but found %s", partitionBatch.size(), partitionSplitInfo.size()));
            }
            Map partitions = (Map)partitionSplitInfo.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((PartitionSplitInfo)entry.getValue()).getPartition()));
            Optional<Map<String, EncryptionInformation>> encryptionInformationForPartitions = this.encryptionInformationProvider.getReadEncryptionInformation(session, table, allRequestedColumns, partitions);
            ImmutableList.Builder results = ImmutableList.builder();
            HashMap partitionsNotReadable = new HashMap();
            int unreadablePartitionsSkipped = 0;
            for (HivePartition hivePartition : partitionBatch) {
                Partition partition = (Partition)partitions.get(hivePartition.getPartitionId().getPartitionName());
                if (partitionSplitInfo.get(hivePartition.getPartitionId().getPartitionName()).isPruned()) continue;
                if (partition == null) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Partition not loaded: " + hivePartition);
                }
                String partitionName = MetastoreUtil.makePartName((List)table.getPartitionColumns(), (List)partition.getValues());
                Optional<EncryptionInformation> encryptionInformation = encryptionInformationForPartitions.map(metadata -> (EncryptionInformation)metadata.get(hivePartition.getPartitionId().getPartitionName()));
                if (!HiveSessionProperties.isOfflineDataDebugModeEnabled(session)) {
                    MetastoreUtil.verifyOnline((SchemaTableName)tableName, Optional.of(partitionName), (ProtectMode)MetastoreUtil.getProtectMode((Partition)partition), (Map)partition.getParameters());
                    String reason = (String)partition.getParameters().get(OBJECT_NOT_READABLE);
                    if (!Strings.isNullOrEmpty((String)reason)) {
                        if (!this.partitionSkippabilityChecker.isPartitionSkippable(partition, session)) {
                            throw new HiveNotReadableException(tableName, Optional.of(partitionName), reason);
                        }
                        ++unreadablePartitionsSkipped;
                        if (partitionsNotReadable.size() > 3) continue;
                        partitionsNotReadable.putIfAbsent(reason, new HashSet(ImmutableSet.of((Object)partitionName)));
                        if (((Set)partitionsNotReadable.get(reason)).size() > 3) continue;
                        ((Set)partitionsNotReadable.get(reason)).add(partitionName);
                        continue;
                    }
                }
                List tableColumns = table.getDataColumns();
                List partitionColumns = partition.getColumns();
                if (tableColumns == null || partitionColumns == null) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Table '%s' or partition '%s' has null columns", tableName, partitionName));
                }
                TableToPartitionMapping tableToPartitionMapping = this.getTableToPartitionMapping(session, resolvedHiveStorageFormat, tableName, partitionName, tableColumns, partitionColumns);
                if (hiveBucketHandle.isPresent() && !((HiveBucketHandle)hiveBucketHandle.get()).isVirtuallyBucketed()) {
                    List partitionBucketColumns;
                    Optional partitionBucketProperty = partition.getStorage().getBucketProperty();
                    if (!partitionBucketProperty.isPresent()) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("Hive table (%s) is bucketed but partition (%s) is not bucketed", hivePartition.getTableName(), hivePartition.getPartitionId().getPartitionName()));
                    }
                    int tableBucketCount = ((HiveBucketHandle)hiveBucketHandle.get()).getTableBucketCount();
                    int partitionBucketCount = ((HiveBucketProperty)partitionBucketProperty.get()).getBucketCount();
                    List tableBucketColumns = (List)((HiveBucketHandle)hiveBucketHandle.get()).getColumns().stream().map(BaseHiveColumnHandle::getName).collect(ImmutableList.toImmutableList());
                    if (!tableBucketColumns.equals(partitionBucketColumns = ((HiveBucketProperty)partitionBucketProperty.get()).getBucketedBy()) || !HiveSplitManager.isBucketCountCompatible(tableBucketCount, partitionBucketCount)) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("Hive table (%s) bucketing (columns=%s, buckets=%s) is not compatible with partition (%s) bucketing (columns=%s, buckets=%s)", hivePartition.getTableName(), tableBucketColumns, tableBucketCount, hivePartition.getPartitionId().getPartitionName(), partitionBucketColumns, partitionBucketCount));
                    }
                }
                results.add((Object)new HivePartitionMetadata(hivePartition, Optional.of(partition), tableToPartitionMapping, encryptionInformation, partitionSplitInfo.get(hivePartition.getPartitionId().getPartitionName()).getRedundantColumnDomains(), partition.getRowIdPartitionComponent()));
            }
            if (unreadablePartitionsSkipped > 0) {
                StringBuilder warningMessage = new StringBuilder(String.format("Table '%s' has %s out of %s partitions unreadable: ", tableName, unreadablePartitionsSkipped, partitionBatch.size()));
                for (Map.Entry entry2 : partitionsNotReadable.entrySet()) {
                    warningMessage.append(String.join((CharSequence)", ", (Iterable)entry2.getValue())).append("... are due to ").append((String)entry2.getKey()).append(". ");
                }
                warningCollector.add(new PrestoWarning((WarningCodeSupplier)HiveWarningCode.PARTITION_NOT_READABLE, warningMessage.toString()));
            }
            return results.build();
        });
        return partitionBatches;
    }

    private TableToPartitionMapping getTableToPartitionMapping(ConnectorSession session, Optional<HiveStorageFormat> storageFormat, SchemaTableName tableName, String partName, List<Column> tableColumns, List<Column> partitionColumns) {
        if (storageFormat.isPresent() && storageFormat.get().equals((Object)HiveStorageFormat.PARQUET) && HiveCommonSessionProperties.isUseParquetColumnNames((ConnectorSession)session)) {
            return this.getTableToPartitionMappingByColumnNames(tableName, partName, tableColumns, partitionColumns);
        }
        ImmutableMap.Builder partitionSchemaDifference = ImmutableMap.builder();
        for (int i = 0; i < partitionColumns.size(); ++i) {
            Column partitionColumn = partitionColumns.get(i);
            if (i >= tableColumns.size()) {
                partitionSchemaDifference.put((Object)i, (Object)partitionColumn);
                continue;
            }
            HiveType tableType = tableColumns.get(i).getType();
            if (!tableType.equals((Object)partitionColumn.getType())) {
                if (!this.coercionPolicy.canCoerce(partitionColumn.getType(), tableType)) {
                    throw this.tablePartitionColumnMismatchException(tableName, partName, tableColumns.get(i).getName(), tableType, partitionColumn.getName(), partitionColumn.getType());
                }
                partitionSchemaDifference.put((Object)i, (Object)partitionColumn);
                continue;
            }
            if (tableColumns.get(i).getName().equals(partitionColumn.getName())) continue;
            partitionSchemaDifference.put((Object)i, (Object)partitionColumn);
        }
        return TableToPartitionMapping.mapColumnsByIndex((Map<Integer, Column>)partitionSchemaDifference.build());
    }

    private TableToPartitionMapping getTableToPartitionMappingByColumnNames(SchemaTableName tableName, String partName, List<Column> tableColumns, List<Column> partitionColumns) {
        ImmutableMap.Builder partitionColumnIndexesBuilder = ImmutableMap.builder();
        for (int i = 0; i < partitionColumns.size(); ++i) {
            partitionColumnIndexesBuilder.put((Object)partitionColumns.get(i).getName().toLowerCase(Locale.ENGLISH), (Object)i);
        }
        ImmutableMap partitionColumnsByIndex = partitionColumnIndexesBuilder.build();
        ImmutableMap.Builder partitionSchemaDifference = ImmutableMap.builder();
        ImmutableMap.Builder tableToPartitionColumns = ImmutableMap.builder();
        for (int tableColumnIndex = 0; tableColumnIndex < tableColumns.size(); ++tableColumnIndex) {
            Column tableColumn = tableColumns.get(tableColumnIndex);
            HiveType tableType = tableColumn.getType();
            Integer partitionColumnIndex = (Integer)partitionColumnsByIndex.get(tableColumn.getName().toLowerCase(Locale.ENGLISH));
            if (partitionColumnIndex == null) continue;
            tableToPartitionColumns.put((Object)tableColumnIndex, (Object)partitionColumnIndex);
            Column partitionColumn = partitionColumns.get(partitionColumnIndex);
            HiveType partitionType = partitionColumn.getType();
            if (tableType.equals((Object)partitionType)) continue;
            if (!this.coercionPolicy.canCoerce(partitionType, tableType)) {
                throw this.tablePartitionColumnMismatchException(tableName, partName, tableColumn.getName(), tableType, partitionColumn.getName(), partitionType);
            }
            partitionSchemaDifference.put((Object)partitionColumnIndex, (Object)partitionColumn);
        }
        ImmutableMap tableToPartitionColumnsMap = tableToPartitionColumns.build();
        for (int partitionColumnIndex = 0; partitionColumnIndex < partitionColumns.size(); ++partitionColumnIndex) {
            if (tableToPartitionColumnsMap.containsValue((Object)partitionColumnIndex)) continue;
            partitionSchemaDifference.put((Object)partitionColumnIndex, (Object)partitionColumns.get(partitionColumnIndex));
        }
        return new TableToPartitionMapping(Optional.of(tableToPartitionColumnsMap), (Map<Integer, Column>)partitionSchemaDifference.build());
    }

    private PrestoException tablePartitionColumnMismatchException(SchemaTableName tableName, String partName, String tableColumnName, HiveType tableType, String partitionColumnName, HiveType partitionType) {
        return new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("There is a mismatch between the table and partition schemas. The types are incompatible and cannot be coerced. The column '%s' in table '%s' is declared as type '%s', but partition '%s' declared column '%s' as type '%s'.", tableColumnName, tableName, tableType, partName, partitionColumnName, partitionType));
    }

    private boolean isHudiFormat(StorageFormat storageFormat) {
        String serde = storageFormat.getSerDeNullable();
        String inputFormat = storageFormat.getInputFormatNullable();
        return serde != null && serde.equals(ParquetHiveSerDe.class.getName()) && inputFormat != null && (inputFormat.equals(HoodieParquetInputFormat.class.getName()) || inputFormat.equals(HoodieParquetRealtimeInputFormat.class.getName()));
    }

    private Map<String, PartitionSplitInfo> getPartitionSplitInfo(ConnectorSession session, SemiTransactionalHiveMetastore metastore, SchemaTableName tableName, List<HivePartition> partitionBatch, Map<String, HiveColumnHandle> predicateColumns, Optional<Map<Subfield, Domain>> domains) {
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getClientTags(), session.getSource(), MetastoreUtil.getMetastoreHeaders((ConnectorSession)session), MetastoreUtil.isUserDefinedTypeEncodingEnabled((ConnectorSession)session), metastore.getColumnConverterProvider(), session.getWarningCollector(), session.getRuntimeStats());
        Map partitions = metastore.getPartitionsByNames(metastoreContext, tableName.getSchemaName(), tableName.getTableName(), Lists.transform(partitionBatch, HivePartition::getPartitionId));
        Object partitionStatistics = ImmutableMap.of();
        if (domains.isPresent() && HiveSessionProperties.isPartitionStatisticsBasedOptimizationEnabled(session)) {
            partitionStatistics = metastore.getPartitionStatistics(metastoreContext, tableName.getSchemaName(), tableName.getTableName(), (Set)partitionBatch.stream().map(hivePartition -> hivePartition.getPartitionId().getPartitionName()).collect(ImmutableSet.toImmutableSet()));
        }
        HashMap partitionNameToLocation = new HashMap();
        ImmutableMap.Builder partitionSplitInfoBuilder = ImmutableMap.builder();
        for (Map.Entry entry : partitions.entrySet()) {
            ImmutableSet.Builder redundantColumnDomainsBuilder = ImmutableSet.builder();
            if (!((Optional)entry.getValue()).isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_DROPPED_DURING_QUERY, String.format("Partition no longer exists: %s.%s/%s", tableName.getSchemaName(), tableName.getTableName(), entry.getKey()));
            }
            boolean pruned = false;
            if (partitionStatistics.containsKey(entry.getKey())) {
                Map columnStatistics = ((PartitionStatistics)partitionStatistics.get(entry.getKey())).getColumnStatistics();
                for (Map.Entry<String, HiveColumnHandle> predicateColumnEntry : predicateColumns.entrySet()) {
                    if (!columnStatistics.containsKey(predicateColumnEntry.getKey())) continue;
                    Optional<ValueSet> columnsStatisticsValueSet = this.getColumnStatisticsValueSet((HiveColumnStatistics)columnStatistics.get(predicateColumnEntry.getKey()), predicateColumnEntry.getValue().getHiveType());
                    Subfield subfield = new Subfield(predicateColumnEntry.getKey());
                    if (!columnsStatisticsValueSet.isPresent() || !domains.get().containsKey(subfield)) continue;
                    ValueSet columnPredicateValueSet = domains.get().get(subfield).getValues();
                    if (!columnPredicateValueSet.overlaps(columnsStatisticsValueSet.get())) {
                        pruned = true;
                        break;
                    }
                    if (!columnPredicateValueSet.contains(columnsStatisticsValueSet.get())) continue;
                    redundantColumnDomainsBuilder.add((Object)predicateColumnEntry.getValue());
                }
            }
            if (!pruned) {
                partitionNameToLocation.put(entry.getKey(), ((Partition)((Optional)entry.getValue()).get()).getStorage().getLocation());
            }
            partitionSplitInfoBuilder.put(entry.getKey(), (Object)new PartitionSplitInfo((Partition)((Optional)entry.getValue()).get(), pruned, (Set<ColumnHandle>)redundantColumnDomainsBuilder.build()));
        }
        metastore.setPartitionLeases(metastoreContext, tableName.getSchemaName(), tableName.getTableName(), partitionNameToLocation, HiveSessionProperties.getLeaseDuration(session));
        return partitionSplitInfoBuilder.build();
    }

    private Optional<ValueSet> getColumnStatisticsValueSet(HiveColumnStatistics statistics, HiveType hiveType) {
        if (hiveType.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            return Optional.empty();
        }
        PrimitiveTypeInfo typeInfo = (PrimitiveTypeInfo)hiveType.getTypeInfo();
        switch (typeInfo.getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return this.getIntegerColumnStatisticsValueSet(statistics, HiveType.getPrimitiveType((PrimitiveTypeInfo)typeInfo));
            }
            case FLOAT: {
                return this.getFloatColumnStatisticsValueSet(statistics, HiveType.getPrimitiveType((PrimitiveTypeInfo)typeInfo));
            }
            case DOUBLE: {
                return this.getDoubleColumnStatisticsValueSet(statistics, HiveType.getPrimitiveType((PrimitiveTypeInfo)typeInfo));
            }
            case DECIMAL: {
                return this.getDecimalColumnStatisticsValueSet(statistics, HiveType.getPrimitiveType((PrimitiveTypeInfo)typeInfo));
            }
            case DATE: {
                return this.getDateColumnStatisticsValueSet(statistics, HiveType.getPrimitiveType((PrimitiveTypeInfo)typeInfo));
            }
        }
        return Optional.empty();
    }

    private Optional<ValueSet> getIntegerColumnStatisticsValueSet(HiveColumnStatistics statistics, Type type) {
        if (!statistics.getIntegerStatistics().isPresent()) {
            return Optional.empty();
        }
        IntegerStatistics hiveColumnStatistics = (IntegerStatistics)statistics.getIntegerStatistics().get();
        ValueSet result = ValueSet.all((Type)type);
        if (hiveColumnStatistics.getMin().isPresent()) {
            result = result.intersect((ValueSet)SortedRangeSet.copyOf((Type)type, (List)ImmutableList.of((Object)Range.greaterThanOrEqual((Type)type, (Object)hiveColumnStatistics.getMin().getAsLong()))));
        }
        if (hiveColumnStatistics.getMax().isPresent()) {
            result = result.intersect((ValueSet)SortedRangeSet.copyOf((Type)type, (List)ImmutableList.of((Object)Range.lessThanOrEqual((Type)type, (Object)hiveColumnStatistics.getMax().getAsLong()))));
        }
        return Optional.of(result);
    }

    private Optional<ValueSet> getFloatColumnStatisticsValueSet(HiveColumnStatistics statistics, Type type) {
        if (!statistics.getDoubleStatistics().isPresent()) {
            return Optional.empty();
        }
        DoubleStatistics hiveColumnStatistics = (DoubleStatistics)statistics.getDoubleStatistics().get();
        ValueSet result = ValueSet.all((Type)type);
        if (hiveColumnStatistics.getMin().isPresent()) {
            result = result.intersect((ValueSet)SortedRangeSet.copyOf((Type)type, (List)ImmutableList.of((Object)Range.greaterThanOrEqual((Type)type, (Object)Float.floatToIntBits((float)hiveColumnStatistics.getMin().getAsDouble())))));
        }
        if (hiveColumnStatistics.getMax().isPresent()) {
            result = result.intersect((ValueSet)SortedRangeSet.copyOf((Type)type, (List)ImmutableList.of((Object)Range.lessThanOrEqual((Type)type, (Object)Float.floatToIntBits((float)hiveColumnStatistics.getMax().getAsDouble())))));
        }
        return Optional.of(result);
    }

    private Optional<ValueSet> getDoubleColumnStatisticsValueSet(HiveColumnStatistics statistics, Type type) {
        if (!statistics.getDoubleStatistics().isPresent()) {
            return Optional.empty();
        }
        DoubleStatistics hiveColumnStatistics = (DoubleStatistics)statistics.getDoubleStatistics().get();
        ValueSet result = ValueSet.all((Type)type);
        if (hiveColumnStatistics.getMin().isPresent()) {
            result = result.intersect((ValueSet)SortedRangeSet.copyOf((Type)type, (List)ImmutableList.of((Object)Range.greaterThanOrEqual((Type)type, (Object)hiveColumnStatistics.getMin().getAsDouble()))));
        }
        if (hiveColumnStatistics.getMax().isPresent()) {
            result = result.intersect((ValueSet)SortedRangeSet.copyOf((Type)type, (List)ImmutableList.of((Object)Range.lessThanOrEqual((Type)type, (Object)hiveColumnStatistics.getMax().getAsDouble()))));
        }
        return Optional.of(result);
    }

    private Optional<ValueSet> getDecimalColumnStatisticsValueSet(HiveColumnStatistics statistics, Type type) {
        if (!statistics.getDecimalStatistics().isPresent()) {
            return Optional.empty();
        }
        DecimalStatistics hiveColumnStatistics = (DecimalStatistics)statistics.getDecimalStatistics().get();
        ValueSet result = ValueSet.all((Type)type);
        if (hiveColumnStatistics.getMin().isPresent()) {
            Object min = Decimals.isShortDecimal((Type)type) ? Long.valueOf(((BigDecimal)hiveColumnStatistics.getMin().get()).longValue()) : Decimals.encodeScaledValue((BigDecimal)((BigDecimal)hiveColumnStatistics.getMin().get()));
            result = result.intersect((ValueSet)SortedRangeSet.copyOf((Type)type, (List)ImmutableList.of((Object)Range.greaterThanOrEqual((Type)type, (Object)min))));
        }
        if (hiveColumnStatistics.getMax().isPresent()) {
            Object max = Decimals.isShortDecimal((Type)type) ? Long.valueOf(((BigDecimal)hiveColumnStatistics.getMax().get()).longValue()) : Decimals.encodeScaledValue((BigDecimal)((BigDecimal)hiveColumnStatistics.getMax().get()));
            result = result.intersect((ValueSet)SortedRangeSet.copyOf((Type)type, (List)ImmutableList.of((Object)Range.lessThanOrEqual((Type)type, (Object)max))));
        }
        return Optional.of(result);
    }

    private Optional<ValueSet> getDateColumnStatisticsValueSet(HiveColumnStatistics statistics, Type type) {
        if (!statistics.getDateStatistics().isPresent()) {
            return Optional.empty();
        }
        DateStatistics hiveColumnStatistics = (DateStatistics)statistics.getDateStatistics().get();
        ValueSet result = ValueSet.all((Type)type);
        if (hiveColumnStatistics.getMin().isPresent()) {
            result = result.intersect((ValueSet)SortedRangeSet.copyOf((Type)type, (List)ImmutableList.of((Object)Range.greaterThanOrEqual((Type)type, (Object)((LocalDate)hiveColumnStatistics.getMin().get()).toEpochDay()))));
        }
        if (hiveColumnStatistics.getMax().isPresent()) {
            result = result.intersect((ValueSet)SortedRangeSet.copyOf((Type)type, (List)ImmutableList.of((Object)Range.lessThanOrEqual((Type)type, (Object)((LocalDate)hiveColumnStatistics.getMax().get()).toEpochDay()))));
        }
        return Optional.of(result);
    }

    @VisibleForTesting
    static Optional<Set<HiveColumnHandle>> mergeRequestedAndPredicateColumns(Optional<Set<HiveColumnHandle>> requestedColumns, Set<HiveColumnHandle> predicateColumns) {
        if (!requestedColumns.isPresent() || predicateColumns.isEmpty()) {
            return requestedColumns;
        }
        return Optional.of(Stream.concat(requestedColumns.get().stream(), predicateColumns.stream()).filter(column -> column.getColumnType() == BaseHiveColumnHandle.ColumnType.REGULAR).collect(Collectors.groupingBy(BaseHiveColumnHandle::getName, Collectors.reducing((handle1, handle2) -> {
            if (handle1.getRequiredSubfields().isEmpty()) {
                return handle1;
            }
            if (handle2.getRequiredSubfields().isEmpty()) {
                return handle2;
            }
            return (HiveColumnHandle)handle1.withRequiredSubfields((List<Subfield>)ImmutableList.copyOf((Collection)ImmutableSet.copyOf((Collection)ImmutableList.builder().addAll((Iterable)handle1.getRequiredSubfields()).addAll((Iterable)handle2.getRequiredSubfields()).build())));
        }))).values().stream().filter(Optional::isPresent).map(Optional::get).collect(ImmutableSet.toImmutableSet()));
    }

    static boolean isBucketCountCompatible(int tableBucketCount, int partitionBucketCount) {
        Preconditions.checkArgument((tableBucketCount > 0 && partitionBucketCount > 0 ? 1 : 0) != 0);
        int larger = Math.max(tableBucketCount, partitionBucketCount);
        int smaller = Math.min(tableBucketCount, partitionBucketCount);
        if (larger % smaller != 0) {
            return false;
        }
        return Integer.bitCount(larger / smaller) == 1;
    }

    private static <T> Iterable<List<T>> partitionExponentially(final List<T> values, final int minBatchSize, final int maxBatchSize) {
        return () -> new AbstractIterator<List<T>>(){
            private int currentSize;
            private final Iterator iterator;
            {
                this.currentSize = minBatchSize;
                this.iterator = values.iterator();
            }

            protected List<T> computeNext() {
                if (!this.iterator.hasNext()) {
                    return (List)this.endOfData();
                }
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int count = 0; this.iterator.hasNext() && count < this.currentSize; ++count) {
                    builder.add(this.iterator.next());
                }
                this.currentSize = Math.min(maxBatchSize, this.currentSize * 2);
                return builder.build();
            }
        };
    }

    private static class ErrorCodedExecutor
    implements Executor {
        private final Executor delegate;

        private ErrorCodedExecutor(Executor delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        @Override
        public void execute(Runnable command) {
            try {
                this.delegate.execute(command);
            }
            catch (RejectedExecutionException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SERVER_SHUTTING_DOWN, "Server is shutting down", (Throwable)e);
            }
        }
    }

    private static class PartitionSplitInfo {
        private final Partition partition;
        private final boolean pruned;
        private final Set<ColumnHandle> redundantColumnDomains;

        public PartitionSplitInfo(Partition partition, boolean pruned, Set<ColumnHandle> redundantColumnDomains) {
            this.partition = Objects.requireNonNull(partition, "partition is null");
            this.pruned = pruned;
            this.redundantColumnDomains = ImmutableSet.copyOf((Collection)Objects.requireNonNull(redundantColumnDomains, "redundantColumnDomains is null"));
        }

        public Partition getPartition() {
            return this.partition;
        }

        public boolean isPruned() {
            return this.pruned;
        }

        public Set<ColumnHandle> getRedundantColumnDomains() {
            return this.redundantColumnDomains;
        }
    }
}

