/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.TableToPartitionMapping;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import io.airlift.slice.SizeOf;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.openjdk.jol.info.ClassLayout;

public class HiveSplitPartitionInfo {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(HiveSplitPartitionInfo.class).instanceSize();
    private final Storage storage;
    private final URI path;
    private final List<HivePartitionKey> partitionKeys;
    private final String partitionName;
    private final int partitionDataColumnCount;
    private final TableToPartitionMapping tableToPartitionMapping;
    private final Optional<HiveSplit.BucketConversion> bucketConversion;
    private final Set<ColumnHandle> redundantColumnDomains;
    private final Optional<byte[]> rowIdPartitionComponent;
    private final AtomicInteger references = new AtomicInteger(0);

    HiveSplitPartitionInfo(Storage storage, URI path, List<HivePartitionKey> partitionKeys, String partitionName, int partitionDataColumnCount, TableToPartitionMapping tableToPartitionMapping, Optional<HiveSplit.BucketConversion> bucketConversion, Set<ColumnHandle> redundantColumnDomains, Optional<byte[]> rowIdPartitionComponent) {
        Objects.requireNonNull(storage, "storage is null");
        Objects.requireNonNull(path, "path is null");
        Objects.requireNonNull(partitionKeys, "partitionKeys is null");
        Objects.requireNonNull(partitionName, "partitionName is null");
        Objects.requireNonNull(tableToPartitionMapping, "tableToPartitionMapping is null");
        Objects.requireNonNull(bucketConversion, "bucketConversion is null");
        Objects.requireNonNull(redundantColumnDomains, "redundantColumnDomains is null");
        Objects.requireNonNull(rowIdPartitionComponent, "rowIdPartitionComponent is null");
        this.storage = storage;
        this.path = HiveSplitPartitionInfo.ensurePathHasTrailingSlash(path);
        this.partitionKeys = partitionKeys;
        this.partitionName = partitionName;
        this.partitionDataColumnCount = partitionDataColumnCount;
        this.tableToPartitionMapping = tableToPartitionMapping;
        this.bucketConversion = bucketConversion;
        this.redundantColumnDomains = redundantColumnDomains;
        this.rowIdPartitionComponent = rowIdPartitionComponent;
    }

    private static URI ensurePathHasTrailingSlash(URI path) {
        if (!path.getPath().endsWith("/")) {
            try {
                path = new URI(path.toString() + "/");
            }
            catch (URISyntaxException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
            }
        }
        return path;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public List<HivePartitionKey> getPartitionKeys() {
        return this.partitionKeys;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public Optional<byte[]> getRowIdPartitionComponent() {
        return this.rowIdPartitionComponent;
    }

    public int getPartitionDataColumnCount() {
        return this.partitionDataColumnCount;
    }

    public TableToPartitionMapping getTableToPartitionMapping() {
        return this.tableToPartitionMapping;
    }

    public Optional<HiveSplit.BucketConversion> getBucketConversion() {
        return this.bucketConversion;
    }

    public Set<ColumnHandle> getRedundantColumnDomains() {
        return this.redundantColumnDomains;
    }

    public int getEstimatedSizeInBytes() {
        int result = INSTANCE_SIZE;
        result = (int)((long)result + SizeOf.sizeOfObjectArray((int)this.partitionKeys.size()));
        for (HivePartitionKey partitionKey : this.partitionKeys) {
            result += partitionKey.getEstimatedSizeInBytes();
        }
        result += this.partitionName.length() * 2;
        return result += this.tableToPartitionMapping.getEstimatedSizeInBytes();
    }

    public int incrementAndGetReferences() {
        return this.references.incrementAndGet();
    }

    public int decrementAndGetReferences() {
        return this.references.decrementAndGet();
    }

    public URI getPath() {
        return this.path;
    }
}

