/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveWriteUtils;
import com.facebook.presto.hive.TableWritabilityChecker;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class HiveTableWritabilityChecker
implements TableWritabilityChecker {
    private final boolean writesToNonManagedTablesEnabled;

    @Inject
    public HiveTableWritabilityChecker(HiveClientConfig hiveClientConfig) {
        this(Objects.requireNonNull(hiveClientConfig, "hiveClientConfig is null").getWritesToNonManagedTablesEnabled());
    }

    public HiveTableWritabilityChecker(boolean writesToNonManagedTablesEnabled) {
        this.writesToNonManagedTablesEnabled = writesToNonManagedTablesEnabled;
    }

    @Override
    public void checkTableWritable(Table table) {
        PrestoTableType tableType = table.getTableType();
        if (!(this.writesToNonManagedTablesEnabled || tableType.equals((Object)PrestoTableType.MANAGED_TABLE) || tableType.equals((Object)PrestoTableType.MATERIALIZED_VIEW) || tableType.equals((Object)PrestoTableType.TEMPORARY_TABLE))) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot write to non-managed Hive table");
        }
        HiveWriteUtils.checkWritable(table.getSchemaTableName(), Optional.empty(), MetastoreUtil.getProtectMode((Table)table), table.getParameters(), table.getStorage());
    }
}

