/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.LazyBlock;
import com.facebook.presto.common.predicate.TupleDomainFilter;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.hive.HiveCoercer;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class RowIDCoercer
implements HiveCoercer {
    private final ByteBuffer rowIDBytes;
    private final Slice rowIDSlice;

    public RowIDCoercer(byte[] partitionComponent, String rowGroupID) {
        Objects.requireNonNull(partitionComponent, "partitionComponent is null");
        Objects.requireNonNull(rowGroupID, "rowGroupID is null");
        byte[] rowGroupIdComponent = rowGroupID.getBytes(StandardCharsets.UTF_8);
        byte[] bytes = new byte[8 + rowGroupIdComponent.length + partitionComponent.length];
        this.rowIDBytes = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        this.rowIDSlice = Slices.wrappedBuffer((byte[])bytes);
        this.rowIDSlice.setBytes(8, rowGroupIdComponent);
        this.rowIDSlice.setBytes(8 + rowGroupIdComponent.length, partitionComponent);
    }

    @Override
    public TupleDomainFilter toCoercingFilter(TupleDomainFilter filter, Subfield subfield) {
        Preconditions.checkArgument((boolean)subfield.getPath().isEmpty(), (Object)"Subfields on primitive types are not allowed");
        return filter;
    }

    @Override
    public Type getToType() {
        return VarbinaryType.VARBINARY;
    }

    @Override
    public Block apply(Block rowNumberBlock) {
        Objects.requireNonNull(rowNumberBlock, "rowNumberBlock is null");
        int positionCount = rowNumberBlock.getPositionCount();
        LazyBlock lazyBlock = new LazyBlock(positionCount, block -> {
            BlockBuilder blockBuilder = VarbinaryType.VARBINARY.createBlockBuilder(null, positionCount, this.rowIDSlice.length());
            for (int i = 0; i < positionCount; ++i) {
                long rowNumber = BigintType.BIGINT.getLong(rowNumberBlock, i);
                this.rowIDBytes.putLong(0, rowNumber);
                VarbinaryType.VARBINARY.writeSlice(blockBuilder, this.rowIDSlice);
            }
            block.setBlock(blockBuilder.build());
        });
        return lazyBlock;
    }
}

