/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.cache;

import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.cache.CacheFactory;
import com.facebook.presto.cache.CacheManager;
import com.facebook.presto.cache.ForCachingFileSystem;
import com.facebook.presto.hadoop.FileSystemFactory;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.WrapperJobConf;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HiveCachingHdfsConfiguration
implements HdfsConfiguration {
    private final HdfsConfiguration hiveHdfsConfiguration;
    private final CacheManager cacheManager;
    private final CacheConfig cacheConfig;
    private final CacheFactory cacheFactory;

    @Inject
    public HiveCachingHdfsConfiguration(@ForCachingFileSystem HdfsConfiguration hdfsConfiguration, CacheConfig cacheConfig, CacheManager cacheManager, CacheFactory cacheFactory) {
        this.hiveHdfsConfiguration = Objects.requireNonNull(hdfsConfiguration, "hiveHdfsConfiguration is null");
        this.cacheManager = Objects.requireNonNull(cacheManager, "CacheManager is null");
        this.cacheConfig = Objects.requireNonNull(cacheConfig, "cacheConfig is null");
        this.cacheFactory = Objects.requireNonNull(cacheFactory, "CacheFactory is null");
    }

    public Configuration getConfiguration(HdfsContext context, URI uri) {
        Configuration defaultConfig = this.hiveHdfsConfiguration.getConfiguration(context, uri);
        CachingJobConf config = new CachingJobConf((factoryConfig, factoryUri) -> {
            try {
                Configuration currentConfig = defaultConfig;
                if (uri.compareTo((URI)factoryUri) != 0) {
                    currentConfig = this.hiveHdfsConfiguration.getConfiguration(context, factoryUri);
                }
                FileSystem fileSystem = new Path(factoryUri).getFileSystem(currentConfig);
                Preconditions.checkState((boolean)(fileSystem instanceof ExtendedFileSystem));
                return this.cacheFactory.createCachingFileSystem(factoryConfig, factoryUri, (ExtendedFileSystem)fileSystem, this.cacheManager, context.getSession().map(HiveSessionProperties::isCacheEnabled).orElse(this.cacheConfig.isCachingEnabled()).booleanValue(), this.cacheConfig);
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "cannot create caching file system", (Throwable)e);
            }
        }, defaultConfig);
        return config;
    }

    public static class CachingJobConf
    extends WrapperJobConf
    implements FileSystemFactory {
        private final BiFunction<Configuration, URI, FileSystem> factory;

        public CachingJobConf(BiFunction<Configuration, URI, FileSystem> factory, Configuration config) {
            super(config);
            this.factory = Objects.requireNonNull(factory, "factory is null");
        }

        public FileSystem createFileSystem(URI uri) {
            return this.factory.apply(this.getConfig(), uri);
        }
    }
}

