/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.orc;

import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveAggregatedPageSourceFactory;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveCommonSessionProperties;
import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.hive.HiveFileSplit;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.orc.AggregatedOrcPageSource;
import com.facebook.presto.hive.orc.HdfsOrcDataSource;
import com.facebook.presto.hive.orc.OrcPageSourceFactoryUtils;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcReaderOptions;
import com.facebook.presto.orc.StripeMetadataSourceFactory;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.FixedPageSource;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;

public class OrcAggregatedPageSourceFactory
implements HiveAggregatedPageSourceFactory {
    private final TypeManager typeManager;
    private final StandardFunctionResolution functionResolution;
    private final boolean useOrcColumnNames;
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats stats;
    private final OrcFileTailSource orcFileTailSource;
    private final StripeMetadataSourceFactory stripeMetadataSourceFactory;

    @Inject
    public OrcAggregatedPageSourceFactory(TypeManager typeManager, StandardFunctionResolution functionResolution, HiveClientConfig config, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats, OrcFileTailSource orcFileTailSource, StripeMetadataSourceFactory stripeMetadataSourceFactory) {
        this(typeManager, functionResolution, Objects.requireNonNull(config, "hiveClientConfig is null").isUseOrcColumnNames(), hdfsEnvironment, stats, orcFileTailSource, stripeMetadataSourceFactory);
    }

    public OrcAggregatedPageSourceFactory(TypeManager typeManager, StandardFunctionResolution functionResolution, boolean useOrcColumnNames, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats, OrcFileTailSource orcFileTailSource, StripeMetadataSourceFactory stripeMetadataSourceFactory) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
        this.useOrcColumnNames = useOrcColumnNames;
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.orcFileTailSource = Objects.requireNonNull(orcFileTailSource, "orcFileTailCache is null");
        this.stripeMetadataSourceFactory = Objects.requireNonNull(stripeMetadataSourceFactory, "stripeMetadataSourceFactory is null");
    }

    @Override
    public Optional<? extends ConnectorPageSource> createPageSource(Configuration configuration, ConnectorSession session, HiveFileSplit fileSplit, Storage storage, List<HiveColumnHandle> columns, HiveFileContext hiveFileContext, Optional<EncryptionInformation> encryptionInformation) {
        if (!OrcSerde.class.getName().equals(storage.getStorageFormat().getSerDe())) {
            return Optional.empty();
        }
        if (fileSplit.getFileSize() == 0L) {
            return Optional.of(new FixedPageSource((Iterable)ImmutableList.of()));
        }
        return Optional.of(OrcAggregatedPageSourceFactory.createOrcPageSource(session, OrcEncoding.ORC, this.hdfsEnvironment, configuration, fileSplit, columns, this.useOrcColumnNames, this.typeManager, this.functionResolution, this.stats, this.orcFileTailSource, this.stripeMetadataSourceFactory, hiveFileContext, encryptionInformation, DwrfEncryptionProvider.NO_ENCRYPTION, false, Optional.empty()));
    }

    public static ConnectorPageSource createOrcPageSource(ConnectorSession session, OrcEncoding orcEncoding, HdfsEnvironment hdfsEnvironment, Configuration configuration, HiveFileSplit fileSplit, List<HiveColumnHandle> columns, boolean useOrcColumnNames, TypeManager typeManager, StandardFunctionResolution functionResolution, FileFormatDataSourceStats stats, OrcFileTailSource orcFileTailSource, StripeMetadataSourceFactory stripeMetadataSourceFactory, HiveFileContext hiveFileContext, Optional<EncryptionInformation> encryptionInformation, DwrfEncryptionProvider dwrfEncryptionProvider, boolean appendRowNumberEnabled, Optional<byte[]> rowIDPartitionComponent) {
        HdfsOrcDataSource orcDataSource = OrcPageSourceFactoryUtils.getOrcDataSource(session, fileSplit, hdfsEnvironment, configuration, hiveFileContext, stats);
        DataSize maxMergeDistance = HiveCommonSessionProperties.getOrcMaxMergeDistance((ConnectorSession)session);
        DataSize tinyStripeThreshold = HiveCommonSessionProperties.getOrcTinyStripeThreshold((ConnectorSession)session);
        DataSize maxReadBlockSize = HiveCommonSessionProperties.getOrcMaxReadBlockSize((ConnectorSession)session);
        Path path = new Path(fileSplit.getPath());
        OrcReaderOptions orcReaderOptions = OrcReaderOptions.builder().withMaxMergeDistance(maxMergeDistance).withTinyStripeThreshold(tinyStripeThreshold).withMaxBlockSize(maxReadBlockSize).withZstdJniDecompressionEnabled(HiveCommonSessionProperties.isOrcZstdJniDecompressionEnabled((ConnectorSession)session)).withAppendRowNumber(appendRowNumberEnabled).build();
        try {
            OrcReader reader = OrcPageSourceFactoryUtils.getOrcReader(orcEncoding, columns, useOrcColumnNames, orcFileTailSource, stripeMetadataSourceFactory, hiveFileContext, orcReaderOptions, encryptionInformation, dwrfEncryptionProvider, (OrcDataSource)orcDataSource, path);
            List<HiveColumnHandle> physicalColumns = HiveUtil.getPhysicalHiveColumnHandles(columns, useOrcColumnNames, reader.getTypes(), path);
            AggregatedOrcPageSource aggregatedOrcPageSource = new AggregatedOrcPageSource(physicalColumns, reader.getFooter(), typeManager, functionResolution);
            return aggregatedOrcPageSource;
        }
        catch (Exception e) {
            throw OrcPageSourceFactoryUtils.mapToPrestoException(e, path, fileSplit);
        }
        finally {
            try {
                orcDataSource.close();
            }
            catch (IOException iOException) {}
        }
    }
}

