/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.orc;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.BaseHiveColumnHandle;
import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBatchPageSourceFactory;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveCommonSessionProperties;
import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.hive.HiveFileSplit;
import com.facebook.presto.hive.HiveOrcAggregatedMemoryContext;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.orc.HdfsOrcDataSource;
import com.facebook.presto.hive.orc.OrcBatchPageSource;
import com.facebook.presto.hive.orc.OrcPageSourceFactoryUtils;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcBatchRecordReader;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcReaderOptions;
import com.facebook.presto.orc.StripeMetadataSourceFactory;
import com.facebook.presto.orc.TupleDomainOrcPredicate;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.FixedPageSource;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.joda.time.DateTimeZone;

public class OrcBatchPageSourceFactory
implements HiveBatchPageSourceFactory {
    private final TypeManager typeManager;
    private final boolean useOrcColumnNames;
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats stats;
    private final int domainCompactionThreshold;
    private final OrcFileTailSource orcFileTailSource;
    private final StripeMetadataSourceFactory stripeMetadataSourceFactory;

    @Inject
    public OrcBatchPageSourceFactory(TypeManager typeManager, StandardFunctionResolution functionResolution, HiveClientConfig config, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats, OrcFileTailSource orcFileTailSource, StripeMetadataSourceFactory stripeMetadataSourceFactory) {
        this(typeManager, Objects.requireNonNull(config, "hiveClientConfig is null").isUseOrcColumnNames(), hdfsEnvironment, stats, config.getDomainCompactionThreshold(), orcFileTailSource, stripeMetadataSourceFactory);
    }

    public OrcBatchPageSourceFactory(TypeManager typeManager, boolean useOrcColumnNames, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats, int domainCompactionThreshold, OrcFileTailSource orcFileTailSource, StripeMetadataSourceFactory stripeMetadataSourceFactory) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.useOrcColumnNames = useOrcColumnNames;
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.domainCompactionThreshold = domainCompactionThreshold;
        this.orcFileTailSource = Objects.requireNonNull(orcFileTailSource, "orcFileTailSource is null");
        this.stripeMetadataSourceFactory = Objects.requireNonNull(stripeMetadataSourceFactory, "stripeMetadataSourceFactory is null");
    }

    @Override
    public Optional<? extends ConnectorPageSource> createPageSource(Configuration configuration, ConnectorSession session, HiveFileSplit fileSplit, Storage storage, SchemaTableName tableName, Map<String, String> tableParameters, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone, HiveFileContext hiveFileContext, Optional<EncryptionInformation> encryptionInformation, Optional<byte[]> rowIDPartitionComponent) {
        if (!OrcSerde.class.getName().equals(storage.getStorageFormat().getSerDe())) {
            return Optional.empty();
        }
        if (fileSplit.getFileSize() == 0L) {
            return Optional.of(new FixedPageSource((Iterable)ImmutableList.of()));
        }
        return Optional.of(OrcBatchPageSourceFactory.createOrcPageSource(OrcEncoding.ORC, this.hdfsEnvironment, configuration, fileSplit, columns, this.useOrcColumnNames, effectivePredicate, hiveStorageTimeZone, this.typeManager, HiveCommonSessionProperties.isOrcBloomFiltersEnabled((ConnectorSession)session), this.stats, this.domainCompactionThreshold, this.orcFileTailSource, this.stripeMetadataSourceFactory, hiveFileContext, OrcReaderOptions.builder().withMaxMergeDistance(HiveCommonSessionProperties.getOrcMaxMergeDistance((ConnectorSession)session)).withTinyStripeThreshold(HiveCommonSessionProperties.getOrcTinyStripeThreshold((ConnectorSession)session)).withMaxBlockSize(HiveCommonSessionProperties.getOrcMaxReadBlockSize((ConnectorSession)session)).withZstdJniDecompressionEnabled(HiveCommonSessionProperties.isOrcZstdJniDecompressionEnabled((ConnectorSession)session)).build(), encryptionInformation, DwrfEncryptionProvider.NO_ENCRYPTION, session, rowIDPartitionComponent));
    }

    public static ConnectorPageSource createOrcPageSource(OrcEncoding orcEncoding, HdfsEnvironment hdfsEnvironment, Configuration configuration, HiveFileSplit fileSplit, List<HiveColumnHandle> columns, boolean useOrcColumnNames, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone, TypeManager typeManager, boolean orcBloomFiltersEnabled, FileFormatDataSourceStats stats, int domainCompactionThreshold, OrcFileTailSource orcFileTailSource, StripeMetadataSourceFactory stripeMetadataSourceFactory, HiveFileContext hiveFileContext, OrcReaderOptions orcReaderOptions, Optional<EncryptionInformation> encryptionInformation, DwrfEncryptionProvider dwrfEncryptionProvider, ConnectorSession session, Optional<byte[]> rowIDPartitionComponent) {
        Preconditions.checkArgument((domainCompactionThreshold >= 1 ? 1 : 0) != 0, (Object)"domainCompactionThreshold must be at least 1");
        HiveUtil.checkRowIDPartitionComponent(columns, rowIDPartitionComponent);
        HdfsOrcDataSource orcDataSource = OrcPageSourceFactoryUtils.getOrcDataSource(session, fileSplit, hdfsEnvironment, configuration, hiveFileContext, stats);
        Path path = new Path(fileSplit.getPath());
        HiveOrcAggregatedMemoryContext systemMemoryUsage = new HiveOrcAggregatedMemoryContext();
        try {
            OrcReader reader = OrcPageSourceFactoryUtils.getOrcReader(orcEncoding, columns, useOrcColumnNames, orcFileTailSource, stripeMetadataSourceFactory, hiveFileContext, orcReaderOptions, encryptionInformation, dwrfEncryptionProvider, (OrcDataSource)orcDataSource, path);
            List<HiveColumnHandle> physicalColumns = HiveUtil.getPhysicalHiveColumnHandles(columns, useOrcColumnNames, reader.getTypes(), path);
            ImmutableMap.Builder includedColumns = ImmutableMap.builder();
            ImmutableList.Builder columnReferences = ImmutableList.builder();
            for (HiveColumnHandle column : physicalColumns) {
                if (column.getColumnType() != BaseHiveColumnHandle.ColumnType.REGULAR) continue;
                Type type = typeManager.getType(column.getTypeSignature());
                includedColumns.put((Object)column.getHiveColumnIndex(), (Object)type);
                columnReferences.add((Object)new TupleDomainOrcPredicate.ColumnReference((Object)column, column.getHiveColumnIndex(), type));
            }
            TupleDomainOrcPredicate predicate = new TupleDomainOrcPredicate(effectivePredicate, (List)columnReferences.build(), orcBloomFiltersEnabled, Optional.of(domainCompactionThreshold));
            OrcBatchRecordReader recordReader = reader.createBatchRecordReader((Map)includedColumns.build(), (OrcPredicate)predicate, fileSplit.getStart(), fileSplit.getLength(), hiveStorageTimeZone, (OrcAggregatedMemoryContext)systemMemoryUsage, 1);
            byte[] partitionID = rowIDPartitionComponent.orElse(new byte[0]);
            String rowGroupID = path.getName();
            List<Boolean> isRowNumberList = Collections.nCopies(physicalColumns.size(), false);
            return new OrcBatchPageSource(recordReader, reader.getOrcDataSource(), physicalColumns, typeManager, systemMemoryUsage, stats, hiveFileContext.getStats(), isRowNumberList, partitionID, rowGroupID);
        }
        catch (Exception e) {
            try {
                orcDataSource.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw OrcPageSourceFactoryUtils.mapToPrestoException(e, path, fileSplit);
        }
    }
}

