/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.orc;

import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveCommonSessionProperties;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.hive.HiveFileSplit;
import com.facebook.presto.hive.HiveOrcAggregatedMemoryContext;
import com.facebook.presto.hive.orc.HdfsOrcDataSource;
import com.facebook.presto.hive.orc.ProjectionBasedDwrfKeyProvider;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.DwrfKeyProvider;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcReaderOptions;
import com.facebook.presto.orc.StripeMetadataSourceFactory;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.units.DataSize;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;

public class OrcPageSourceFactoryUtils {
    private OrcPageSourceFactoryUtils() {
    }

    public static HdfsOrcDataSource getOrcDataSource(ConnectorSession session, HiveFileSplit fileSplit, HdfsEnvironment hdfsEnvironment, Configuration configuration, HiveFileContext hiveFileContext, FileFormatDataSourceStats stats) {
        DataSize maxMergeDistance = HiveCommonSessionProperties.getOrcMaxMergeDistance((ConnectorSession)session);
        DataSize maxBufferSize = HiveCommonSessionProperties.getOrcMaxBufferSize((ConnectorSession)session);
        DataSize streamBufferSize = HiveCommonSessionProperties.getOrcStreamBufferSize((ConnectorSession)session);
        boolean lazyReadSmallRanges = HiveCommonSessionProperties.getOrcLazyReadSmallRanges((ConnectorSession)session);
        Path path = new Path(fileSplit.getPath());
        try {
            FSDataInputStream inputStream = hdfsEnvironment.getFileSystem(session.getUser(), path, configuration).openFile(path, hiveFileContext);
            return new HdfsOrcDataSource(new OrcDataSourceId(fileSplit.getPath()), fileSplit.getFileSize(), maxMergeDistance, maxBufferSize, streamBufferSize, lazyReadSmallRanges, inputStream, stats);
        }
        catch (Exception e) {
            if (Strings.nullToEmpty((String)e.getMessage()).trim().equals("Filesystem closed") || e instanceof FileNotFoundException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, OrcPageSourceFactoryUtils.splitError(e, path, fileSplit.getStart(), fileSplit.getLength()), (Throwable)e);
        }
    }

    private static String splitError(Throwable t, Path path, long start, long length) {
        return String.format("Error opening Hive split %s (offset=%s, length=%s): %s", path, start, length, t.getMessage());
    }

    public static OrcReader getOrcReader(OrcEncoding orcEncoding, List<HiveColumnHandle> columns, boolean useOrcColumnNames, OrcFileTailSource orcFileTailSource, StripeMetadataSourceFactory stripeMetadataSourceFactory, HiveFileContext hiveFileContext, OrcReaderOptions orcReaderOptions, Optional<EncryptionInformation> encryptionInformation, DwrfEncryptionProvider dwrfEncryptionProvider, OrcDataSource orcDataSource, Path path) throws IOException {
        ProjectionBasedDwrfKeyProvider dwrfKeyProvider = new ProjectionBasedDwrfKeyProvider(encryptionInformation, columns, useOrcColumnNames, path);
        OrcReader reader = new OrcReader(orcDataSource, orcEncoding, orcFileTailSource, stripeMetadataSourceFactory, (OrcAggregatedMemoryContext)new HiveOrcAggregatedMemoryContext(), orcReaderOptions, hiveFileContext.isCacheable(), dwrfEncryptionProvider, (DwrfKeyProvider)dwrfKeyProvider, hiveFileContext.getStats());
        return reader;
    }

    public static PrestoException mapToPrestoException(Exception e, Path path, HiveFileSplit fileSplit) {
        if (e.getClass().getName().equals(UncheckedExecutionException.class.getName()) && e.getCause() instanceof PrestoException) {
            return (PrestoException)e.getCause();
        }
        if (e instanceof PrestoException) {
            return (PrestoException)((Object)e);
        }
        String message = OrcPageSourceFactoryUtils.splitError(e, path, fileSplit.getStart(), fileSplit.getLength());
        if (e.getClass().getSimpleName().equals("BlockMissingException")) {
            return new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_MISSING_DATA, message, (Throwable)e);
        }
        return new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, message, (Throwable)e);
    }
}

