/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.orc;

import com.facebook.presto.common.InvalidFunctionArgumentException;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.RowIDCoercer;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcSelectiveRecordReader;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.OptionalInt;

public class OrcSelectivePageSource
implements ConnectorPageSource {
    private static final int ROW_ID_COLUMN_INDEX = -10;
    private final OrcSelectiveRecordReader recordReader;
    private final OrcDataSource orcDataSource;
    private final OrcAggregatedMemoryContext systemMemoryContext;
    private final FileFormatDataSourceStats stats;
    private final RuntimeStats runtimeStats;
    private final boolean appendRowNumberEnabled;
    private final RowIDCoercer coercer;
    private final boolean supplyRowIDs;
    private final OptionalInt rowIDColumnIndex;
    private boolean closed;

    OrcSelectivePageSource(OrcSelectiveRecordReader recordReader, OrcDataSource orcDataSource, OrcAggregatedMemoryContext systemMemoryContext, FileFormatDataSourceStats stats, RuntimeStats runtimeStats, boolean appendRowNumberEnabled, byte[] rowIDPartitionComponent, String rowGroupId, boolean supplyRowIDs) {
        this.recordReader = Objects.requireNonNull(recordReader, "recordReader is null");
        this.orcDataSource = Objects.requireNonNull(orcDataSource, "orcDataSource is null");
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.runtimeStats = runtimeStats;
        this.appendRowNumberEnabled = appendRowNumberEnabled;
        this.coercer = new RowIDCoercer(rowIDPartitionComponent, rowGroupId);
        this.supplyRowIDs = supplyRowIDs;
        this.rowIDColumnIndex = recordReader.toZeroBasedColumnIndex(-10);
    }

    public RuntimeStats getRuntimeStats() {
        return this.runtimeStats;
    }

    public long getCompletedBytes() {
        return this.orcDataSource.getReadBytes();
    }

    public long getCompletedPositions() {
        return this.recordReader.getReadPositions();
    }

    public long getReadTimeNanos() {
        return this.orcDataSource.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public Page getNextPage() {
        try {
            Page page;
            if (this.supplyRowIDs) {
                page = this.recordReader.getNextPage(true);
                page = this.fillInRowIDs(page);
            } else {
                page = this.recordReader.getNextPage();
            }
            if (page == null) {
                this.close();
            }
            return page;
        }
        catch (InvalidFunctionArgumentException e) {
            this.closeWithSuppression(e);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, e.getMessage(), (Throwable)e);
        }
        catch (PrestoException e) {
            this.closeWithSuppression(e);
            throw e;
        }
        catch (OrcCorruptionException e) {
            this.closeWithSuppression(e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, (Throwable)e);
        }
        catch (IOException | RuntimeException e) {
            this.closeWithSuppression(e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, String.format("Failed to read ORC file: %s", this.orcDataSource.getId()), (Throwable)e);
        }
    }

    private Page fillInRowIDs(Page page) {
        Block rowNumbers = page.getBlock(page.getChannelCount() - 1);
        Block rowIDs = this.coercer.apply(rowNumbers);
        page = page.replaceColumn(this.rowIDColumnIndex.getAsInt(), rowIDs);
        if (!this.appendRowNumberEnabled) {
            page = page.dropColumn(page.getChannelCount() - 1);
        }
        return page;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.stats.addMaxCombinedBytesPerRow(this.recordReader.getMaxCombinedBytesPerRow());
            this.recordReader.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).toString();
    }

    public long getSystemMemoryUsage() {
        return this.systemMemoryContext.getBytes();
    }

    protected void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (RuntimeException e) {
                if (throwable == e) break block2;
                throwable.addSuppressed(e);
            }
        }
    }
}

