/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.pagefile;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.io.DataSink;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileWriter;
import com.facebook.presto.hive.pagefile.PageWriter;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.page.PagesSerde;
import com.google.common.base.Throwables;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.openjdk.jol.info.ClassLayout;

public class PageFileWriter
implements HiveFileWriter {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(PageFileWriter.class).instanceSize();
    private final PageWriter pageWriter;
    private final PagesSerde pagesSerde;
    private final Callable<Void> rollbackAction;

    public PageFileWriter(DataSink dataSink, PagesSerde pagesSerde, HiveCompressionCodec compression, DataSize pageFileStripeMaxSize, Callable<Void> rollbackAction) {
        this.pageWriter = new PageWriter(dataSink, compression, pageFileStripeMaxSize);
        this.pagesSerde = Objects.requireNonNull(pagesSerde, "pagesSerde is null");
        this.rollbackAction = Objects.requireNonNull(rollbackAction, "rollbackAction is null");
    }

    @Override
    public long getWrittenBytes() {
        return this.pageWriter.getWrittenBytes();
    }

    @Override
    public long getSystemMemoryUsage() {
        return (long)INSTANCE_SIZE + this.pageWriter.getRetainedBytes();
    }

    @Override
    public void appendRows(Page dataPage) {
        try {
            this.pageWriter.write(this.pagesSerde.serialize(dataPage));
        }
        catch (IOException | UncheckedIOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, (Throwable)e);
        }
    }

    @Override
    public Optional<Page> commit() {
        try {
            this.pageWriter.close();
            return Optional.empty();
        }
        catch (PrestoException | IOException | UncheckedIOException e) {
            try {
                this.rollbackAction.call();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Throwables.throwIfInstanceOf((Throwable)e, PrestoException.class);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error committing write to Hive. " + e.getMessage(), e);
        }
    }

    @Override
    public void rollback() {
        try {
            try {
                this.pageWriter.closeWithoutWrite();
            }
            finally {
                this.rollbackAction.call();
            }
        }
        catch (PrestoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error rolling back write to Hive", (Throwable)e);
        }
    }

    @Override
    public long getValidationCpuNanos() {
        return 0L;
    }

    @Override
    public long getFileSizeInBytes() {
        return this.getWrittenBytes();
    }
}

