/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.s3;

import com.facebook.presto.hive.aws.AbstractSdkMetricsCollector;
import com.facebook.presto.hive.s3.PrestoS3FileSystemStats;
import io.airlift.units.Duration;
import java.util.Objects;

public class PrestoS3FileSystemMetricCollector
extends AbstractSdkMetricsCollector {
    private final PrestoS3FileSystemStats stats;

    public PrestoS3FileSystemMetricCollector(PrestoS3FileSystemStats stats) {
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    protected void recordRequestCount(long count) {
        this.stats.updateAwsRequestCount(count);
    }

    protected void recordRetryCount(long count) {
        this.stats.updateAwsRetryCount(count);
    }

    protected void recordThrottleExceptionCount(long count) {
        this.stats.updateAwsThrottleExceptionsCount(count);
    }

    protected void recordHttpRequestTime(Duration duration) {
        this.stats.addAwsRequestTime(duration);
    }

    protected void recordClientExecutionTime(Duration duration) {
        this.stats.addAwsClientExecuteTime(duration);
    }

    protected void recordRetryPauseTime(Duration duration) {
        this.stats.addAwsClientRetryPauseTime(duration);
    }
}

