/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.s3.security;

import com.facebook.presto.hive.DynamicConfigurationProvider;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.aws.security.AWSSecurityMapping;
import com.facebook.presto.hive.aws.security.AWSSecurityMappings;
import com.facebook.presto.hive.aws.security.AWSSecurityMappingsSupplier;
import com.facebook.presto.hive.s3.security.ForAWSS3DynamicConfigurationProvider;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;

public class AWSS3SecurityMappingConfigurationProvider
implements DynamicConfigurationProvider {
    private static final Set<String> SCHEMES = ImmutableSet.of((Object)"s3", (Object)"s3a", (Object)"s3n");
    private final Supplier<AWSSecurityMappings> mappings;

    @Inject
    public AWSS3SecurityMappingConfigurationProvider(@ForAWSS3DynamicConfigurationProvider AWSSecurityMappingsSupplier awsSecurityMappingsSupplier) {
        this(Objects.requireNonNull(awsSecurityMappingsSupplier, "awsSecurityMappingsSupplier is null").getMappingsSupplier());
    }

    private AWSS3SecurityMappingConfigurationProvider(Supplier<AWSSecurityMappings> mappings) {
        this.mappings = Objects.requireNonNull(mappings, "mappings is null");
    }

    public void updateConfiguration(Configuration configuration, HdfsContext context, URI uri) {
        if (!SCHEMES.contains(uri.getScheme())) {
            return;
        }
        AWSSecurityMapping awsS3SecurityMapping = this.mappings.get().getAWSS3SecurityMapping(context.getIdentity().getUser());
        Preconditions.checkArgument((awsS3SecurityMapping.getIamRole().isPresent() || awsS3SecurityMapping.getCredentials().isPresent() ? 1 : 0) != 0, (Object)"AWS S3 security mapping must have role or credentials");
        awsS3SecurityMapping.getCredentials().ifPresent(credentials -> {
            configuration.set("presto.s3.access-key", credentials.getAWSAccessKeyId());
            configuration.set("presto.s3.secret-key", credentials.getAWSSecretKey());
        });
        awsS3SecurityMapping.getIamRole().ifPresent(role -> configuration.set("presto.hive.s3.iam-role", role));
    }
}

