/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.s3select;

import com.facebook.presto.hive.s3select.S3SelectDataType;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hive.hcatalog.data.JsonSerDe;

public class S3SelectSerDeDataTypeMapper {
    private static final Map<String, S3SelectDataType> SERDE_TO_DATA_TYPE_MAPPING = ImmutableMap.of((Object)LazySimpleSerDe.class.getName(), (Object)((Object)S3SelectDataType.CSV), (Object)JsonSerDe.class.getName(), (Object)((Object)S3SelectDataType.JSON));

    private S3SelectSerDeDataTypeMapper() {
    }

    public static Optional<S3SelectDataType> getDataType(String serdeName) {
        return Optional.ofNullable(SERDE_TO_DATA_TYPE_MAPPING.get(serdeName));
    }

    public static boolean doesSerDeExist(String serdeName) {
        return SERDE_TO_DATA_TYPE_MAPPING.containsKey(serdeName);
    }
}

