/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.statistics;

import java.lang.reflect.Type;
import java.util.Objects;

public class ColumnQuickStats<T extends Comparable<T>> {
    private final String columnName;
    private final Type statType;
    private long rowCount;
    private long nullsCount;
    private T minValue;
    private T maxValue;

    public ColumnQuickStats(String columnName, Type statType) {
        this.columnName = columnName;
        this.statType = statType;
    }

    public Type getStatType() {
        return this.statType;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public T getMinValue() {
        return this.minValue;
    }

    public void setMinValue(T minValue) {
        this.minValue = this.minValue == null ? minValue : (this.minValue.compareTo(minValue) < 0 ? this.minValue : minValue);
    }

    public T getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(T maxValue) {
        this.maxValue = this.maxValue == null ? maxValue : (this.maxValue.compareTo(maxValue) > 0 ? this.maxValue : maxValue);
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public void addToRowCount(long rowCount) {
        this.rowCount += rowCount;
    }

    public long getNullsCount() {
        return this.nullsCount;
    }

    public void addToNullsCount(long nullsCount) {
        this.nullsCount += nullsCount;
    }

    public String toString() {
        return "ColumnQuickStats{columnName='" + this.columnName + '\'' + ", statType=" + this.statType + ", rowCount=" + this.rowCount + ", nullsCount=" + this.nullsCount + ", minValue=" + this.minValue + ", maxValue=" + this.maxValue + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnQuickStats that = (ColumnQuickStats)o;
        return this.rowCount == that.rowCount && this.nullsCount == that.nullsCount && Objects.equals(this.columnName, that.columnName) && Objects.equals(this.statType, that.statType) && Objects.equals(this.minValue, that.minValue) && Objects.equals(this.maxValue, that.maxValue);
    }

    public int hashCode() {
        return Objects.hash(this.columnName, this.statType, this.rowCount, this.nullsCount, this.minValue, this.maxValue);
    }
}

