/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.statistics;

import com.facebook.presto.hive.HiveBasicStatistics;
import com.facebook.presto.hive.metastore.HiveColumnStatistics;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.statistics.ColumnQuickStats;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;

public class PartitionQuickStats {
    public static final PartitionQuickStats EMPTY = new PartitionQuickStats("emptyPartition", Collections.emptyList(), 0);
    private final String partitionId;
    private final List<ColumnQuickStats<?>> stats;
    private final int fileCount;

    public PartitionQuickStats(String partitionId, Collection<ColumnQuickStats<?>> stats, int fileCount) {
        this.partitionId = partitionId;
        this.stats = ImmutableList.copyOf(stats);
        this.fileCount = fileCount;
    }

    public static PartitionStatistics convertToPartitionStatistics(PartitionQuickStats partitionQuickStats) {
        if (partitionQuickStats.equals(EMPTY) || partitionQuickStats.getStats().isEmpty()) {
            return PartitionStatistics.empty();
        }
        ImmutableMap.Builder hiveColumnStatisticsBuilder = ImmutableMap.builder();
        partitionQuickStats.getStats().forEach(columnQuickStats -> {
            long nullsCount = columnQuickStats.getNullsCount();
            Object minValue = columnQuickStats.getMinValue();
            Object maxValue = columnQuickStats.getMaxValue();
            HiveColumnStatistics hiveColumnStatistics = columnQuickStats.getStatType().equals(Integer.class) ? HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of(((Integer)minValue).intValue()), (OptionalLong)OptionalLong.of(((Integer)maxValue).intValue()), (OptionalLong)OptionalLong.of(nullsCount), (OptionalLong)OptionalLong.empty()) : (columnQuickStats.getStatType().equals(Long.class) ? HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of((Long)minValue), (OptionalLong)OptionalLong.of((Long)maxValue), (OptionalLong)OptionalLong.of(nullsCount), (OptionalLong)OptionalLong.empty()) : (columnQuickStats.getStatType().equals(Double.class) ? HiveColumnStatistics.createDoubleColumnStatistics((OptionalDouble)OptionalDouble.of((Double)minValue), (OptionalDouble)OptionalDouble.of((Double)maxValue), (OptionalLong)OptionalLong.of(nullsCount), (OptionalLong)OptionalLong.empty()) : (columnQuickStats.getStatType().equals(Slice.class) ? HiveColumnStatistics.createBinaryColumnStatistics((OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.of(nullsCount)) : (columnQuickStats.getStatType().equals(Boolean.class) ? HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.of(nullsCount)) : (columnQuickStats.getStatType().equals(ChronoLocalDate.class) ? HiveColumnStatistics.createDateColumnStatistics(Optional.of((LocalDate)minValue), Optional.of((LocalDate)maxValue), (OptionalLong)OptionalLong.of(nullsCount), (OptionalLong)OptionalLong.empty()) : new HiveColumnStatistics(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), OptionalLong.empty(), OptionalLong.empty(), OptionalLong.of(nullsCount), OptionalLong.empty()))))));
            hiveColumnStatisticsBuilder.put((Object)columnQuickStats.getColumnName(), (Object)hiveColumnStatistics);
        });
        long rowCount = partitionQuickStats.getStats().get(0).getRowCount();
        HiveBasicStatistics hiveBasicStatistics = new HiveBasicStatistics(OptionalLong.of(partitionQuickStats.getFileCount()), OptionalLong.of(rowCount), OptionalLong.empty(), OptionalLong.empty());
        return new PartitionStatistics(hiveBasicStatistics, (Map)hiveColumnStatisticsBuilder.build());
    }

    public List<ColumnQuickStats<?>> getStats() {
        return this.stats;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public String toString() {
        return "PartitionQuickStats{partitionId='" + this.partitionId + '\'' + ", stats=" + this.stats + ", fileCount=" + this.fileCount + '}';
    }
}

