/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.statistics;

import com.facebook.airlift.concurrent.BoundedExecutor;
import com.facebook.airlift.concurrent.ThreadPoolExecutorMBean;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.stats.TimeStat;
import com.facebook.presto.common.RuntimeUnit;
import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveDirectoryContext;
import com.facebook.presto.hive.HiveFileInfo;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.NestedDirectoryPolicy;
import com.facebook.presto.hive.PartitionNameWithVersion;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.statistics.PartitionQuickStats;
import com.facebook.presto.hive.statistics.QuickStatsBuilder;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.SchemaTableName;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class QuickStatsProvider {
    public static final Logger log = Logger.get(QuickStatsProvider.class);
    public static final long MAX_CACHE_ENTRIES = 1000000L;
    private final Executor backgroundFetchExecutor;
    private final ThreadPoolExecutorMBean backgroundFetchExecutorMBean;
    private final ScheduledExecutorService inProgressReaperExecutor = new ScheduledThreadPoolExecutor(1, Threads.daemonThreadsNamed((String)"in-progress-reaper"));
    private final HdfsEnvironment hdfsEnvironment;
    private final DirectoryLister directoryLister;
    private final List<QuickStatsBuilder> statsBuilderStrategies;
    private final boolean recursiveDirWalkerEnabled;
    private final ConcurrentHashMap<String, InProgressBuildInfo> inProgressBuilds = new ConcurrentHashMap();
    private final AtomicLong requestCount = new AtomicLong(0L);
    private final AtomicLong succesfulResolveFromCacheCount = new AtomicLong(0L);
    private final AtomicLong succesfulResolveFromProviderCount = new AtomicLong(0L);
    private final long reaperExpiryMillis;
    private final Cache<String, PartitionStatistics> partitionToStatsCache;
    private final NamenodeStats nameNodeStats;
    private final TimeStat buildDuration = new TimeStat(TimeUnit.MILLISECONDS);

    public QuickStatsProvider(HdfsEnvironment hdfsEnvironment, DirectoryLister directoryLister, HiveClientConfig hiveClientConfig, NamenodeStats nameNodeStats, List<QuickStatsBuilder> statsBuilderStrategies) {
        this.hdfsEnvironment = hdfsEnvironment;
        this.directoryLister = directoryLister;
        this.recursiveDirWalkerEnabled = hiveClientConfig.getRecursiveDirWalkerEnabled();
        this.partitionToStatsCache = CacheBuilder.newBuilder().maximumSize(1000000L).expireAfterWrite(hiveClientConfig.getQuickStatsCacheExpiry().roundTo(TimeUnit.SECONDS), TimeUnit.SECONDS).build();
        this.reaperExpiryMillis = hiveClientConfig.getQuickStatsReaperExpiry().toMillis();
        this.nameNodeStats = nameNodeStats;
        this.statsBuilderStrategies = statsBuilderStrategies;
        ExecutorService coreExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"quick-stats-bg-fetch-%s"));
        this.backgroundFetchExecutor = new BoundedExecutor((Executor)coreExecutor, hiveClientConfig.getMaxConcurrentQuickStatsCalls());
        this.backgroundFetchExecutorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)coreExecutor);
    }

    @Managed
    public long getRequestCount() {
        return this.requestCount.get();
    }

    @Managed
    public long getSuccesfulResolveFromCacheCount() {
        return this.succesfulResolveFromCacheCount.get();
    }

    @Managed
    public long getSuccesfulResolveFromProviderCount() {
        return this.succesfulResolveFromProviderCount.get();
    }

    @Managed
    @Nested
    public TimeStat getBuildDuration() {
        return this.buildDuration;
    }

    @Managed
    public Map<String, Instant> getInProgressBuildsSnapshot() {
        return (Map)this.inProgressBuilds.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, v -> ((InProgressBuildInfo)v.getValue()).getBuildStart()));
    }

    public Map<String, PartitionStatistics> getQuickStats(ConnectorSession session, SemiTransactionalHiveMetastore metastore, SchemaTableName table, MetastoreContext metastoreContext, List<String> partitionIds) {
        if (!HiveSessionProperties.isQuickStatsEnabled(session)) {
            return partitionIds.stream().collect(Collectors.toMap(k -> k, v -> PartitionStatistics.empty()));
        }
        CompletableFuture[] partitionQuickStatCompletableFutures = new CompletableFuture[partitionIds.size()];
        for (int counter = 0; counter < partitionIds.size(); ++counter) {
            String partitionId = partitionIds.get(counter);
            partitionQuickStatCompletableFutures[counter] = CompletableFuture.supplyAsync(() -> this.getQuickStats(session, metastore, table, metastoreContext, partitionId), this.backgroundFetchExecutor);
        }
        try {
            CompletableFuture.allOf(partitionQuickStatCompletableFutures).get(this.getQuickStatsInlineBuildTimeoutMillis(session), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            log.error((Throwable)e);
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            log.warn((Throwable)e, "Timeout while building quick stats");
        }
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (int counter = 0; counter < partitionQuickStatCompletableFutures.length; ++counter) {
            String partitionId = partitionIds.get(counter);
            CompletableFuture future = partitionQuickStatCompletableFutures[counter];
            if (future.isDone() && !future.isCancelled() && !future.isCompletedExceptionally()) {
                try {
                    result.put((Object)partitionId, future.get());
                    continue;
                }
                catch (InterruptedException | ExecutionException e) {
                    log.error((Throwable)e, "Failed to get value for a quick stats future which was completed successfully");
                    throw new RuntimeException(e);
                }
            }
            result.put((Object)partitionId, (Object)PartitionStatistics.empty());
        }
        return result.build();
    }

    public PartitionStatistics getQuickStats(ConnectorSession session, SemiTransactionalHiveMetastore metastore, SchemaTableName table, MetastoreContext metastoreContext, String partitionId) {
        if (!HiveSessionProperties.isQuickStatsEnabled(session)) {
            return PartitionStatistics.empty();
        }
        this.requestCount.incrementAndGet();
        String partitionKey = String.join((CharSequence)"/", table.toSchemaTablePrefix().toString(), partitionId);
        PartitionStatistics cachedValue = (PartitionStatistics)this.partitionToStatsCache.getIfPresent((Object)partitionKey);
        if (cachedValue != null) {
            this.succesfulResolveFromCacheCount.incrementAndGet();
            return cachedValue;
        }
        if (this.inProgressBuilds.containsKey(partitionKey)) {
            long backgroundBuildTimeoutMs = HiveSessionProperties.getQuickStatsBackgroundBuildTimeout(session).toMillis();
            if (backgroundBuildTimeoutMs > 0L) {
                return this.waitForInProgressBuild(backgroundBuildTimeoutMs, partitionKey);
            }
            return PartitionStatistics.empty();
        }
        AtomicReference partitionStatisticsCompletableFuture = new AtomicReference();
        this.inProgressBuilds.computeIfAbsent(partitionKey, key -> {
            CompletableFuture<PartitionStatistics> fetchFuture = CompletableFuture.supplyAsync(() -> this.buildQuickStats(partitionKey, partitionId, session, metastore, table, metastoreContext), this.backgroundFetchExecutor);
            partitionStatisticsCompletableFuture.set(fetchFuture);
            return new InProgressBuildInfo(fetchFuture, Instant.now());
        });
        CompletableFuture future = (CompletableFuture)partitionStatisticsCompletableFuture.get();
        if (future != null) {
            future.whenCompleteAsync((r, e) -> this.inProgressBuilds.remove(partitionKey), (Executor)this.inProgressReaperExecutor);
            this.inProgressReaperExecutor.schedule(() -> {
                this.inProgressBuilds.remove(partitionKey);
                future.cancel(true);
            }, this.reaperExpiryMillis, TimeUnit.MILLISECONDS);
            long inlineBuildTimeoutMillis = this.getQuickStatsInlineBuildTimeoutMillis(session);
            if (inlineBuildTimeoutMillis > 0L) {
                try {
                    PartitionStatistics partitionStatistics = (PartitionStatistics)future.get(inlineBuildTimeoutMillis, TimeUnit.MILLISECONDS);
                    this.succesfulResolveFromProviderCount.incrementAndGet();
                    return partitionStatistics;
                }
                catch (InterruptedException | ExecutionException e2) {
                    log.error((Throwable)e2, "Error while building quick stats for partition : %s", new Object[]{partitionId});
                    return PartitionStatistics.empty();
                }
                catch (TimeoutException e3) {
                    log.warn((Throwable)e3, "Timeout while building quick stats for partition : %s", new Object[]{partitionId});
                    session.getRuntimeStats().addMetricValue("QuickStatsProvider/QuickStatsBuildTimeout", RuntimeUnit.NONE, 1L);
                    return PartitionStatistics.empty();
                }
            }
            return PartitionStatistics.empty();
        }
        return this.getQuickStats(session, metastore, table, metastoreContext, partitionId);
    }

    private PartitionStatistics waitForInProgressBuild(long waitTimeMs, String partitionKey) {
        try {
            return this.inProgressBuilds.get(partitionKey).getQuickStatsBuildFuture().get(waitTimeMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return PartitionStatistics.empty();
        }
    }

    @Managed
    @Nested
    public ThreadPoolExecutorMBean getExecutor() {
        return this.backgroundFetchExecutorMBean;
    }

    private long getQuickStatsInlineBuildTimeoutMillis(ConnectorSession session) {
        return HiveSessionProperties.getQuickStatsInlineBuildTimeout(session).toMillis();
    }

    private PartitionStatistics buildQuickStats(String partitionKey, String partitionId, ConnectorSession session, SemiTransactionalHiveMetastore metastore, SchemaTableName table, MetastoreContext metastoreContext) {
        QuickStatsBuilder strategy;
        ExtendedFileSystem fs;
        Path path;
        Optional partition;
        Table resolvedTable = (Table)metastore.getTable(metastoreContext, table.getSchemaName(), table.getTableName()).get();
        if (HivePartition.UNPARTITIONED_ID.getPartitionName().equals(partitionId)) {
            partition = Optional.empty();
            path = new Path(resolvedTable.getStorage().getLocation());
        } else {
            partition = (Optional)metastore.getPartitionsByNames(metastoreContext, table.getSchemaName(), table.getTableName(), (List)ImmutableList.of((Object)new PartitionNameWithVersion(partitionId, Optional.empty()))).get(partitionId);
            Preconditions.checkState((boolean)partition.isPresent(), (String)"getPartitionsByNames returned no partitions for partition with name [%s]", (Object)partitionId);
            path = new Path(((Partition)partition.get()).getStorage().getLocation());
        }
        HdfsContext hdfsContext = new HdfsContext(session, table.getSchemaName(), table.getTableName(), partitionId, false);
        HiveDirectoryContext hiveDirectoryContext = new HiveDirectoryContext(this.recursiveDirWalkerEnabled ? NestedDirectoryPolicy.RECURSE : NestedDirectoryPolicy.IGNORED, HiveSessionProperties.isUseListDirectoryCache(session), HiveSessionProperties.isSkipEmptyFilesEnabled(session), hdfsContext.getIdentity(), HiveUtil.buildDirectoryContextProperties(session), session.getRuntimeStats());
        try {
            fs = this.hdfsEnvironment.getFileSystem(hdfsContext, path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Iterator<HiveFileInfo> fileList = this.directoryLister.list(fs, resolvedTable, path, partition, this.nameNodeStats, hiveDirectoryContext);
        PartitionQuickStats partitionQuickStats = PartitionQuickStats.EMPTY;
        Stopwatch buildStopwatch = Stopwatch.createStarted();
        Iterator<QuickStatsBuilder> iterator = this.statsBuilderStrategies.iterator();
        while (iterator.hasNext() && (partitionQuickStats = (strategy = iterator.next()).buildQuickStats(session, metastore, table, metastoreContext, partitionId, fileList)) == PartitionQuickStats.EMPTY) {
        }
        long buildMillis = buildStopwatch.elapsed(TimeUnit.MILLISECONDS);
        session.getRuntimeStats().addMetricValue("QuickStatsProvider/BuildTimeMS/" + partitionKey, RuntimeUnit.NONE, buildMillis);
        this.buildDuration.add((double)buildMillis, TimeUnit.MILLISECONDS);
        PartitionStatistics partitionStatistics = PartitionQuickStats.convertToPartitionStatistics(partitionQuickStats);
        this.partitionToStatsCache.put((Object)partitionKey, (Object)partitionStatistics);
        return partitionStatistics;
    }

    private static class InProgressBuildInfo {
        private final CompletableFuture<PartitionStatistics> quickStatsBuildFuture;
        private final Instant buildStart;

        public InProgressBuildInfo(CompletableFuture<PartitionStatistics> quickStatsBuildFuture, Instant buildStart) {
            this.quickStatsBuildFuture = quickStatsBuildFuture;
            this.buildStart = buildStart;
        }

        public CompletableFuture<PartitionStatistics> getQuickStatsBuildFuture() {
            return this.quickStatsBuildFuture;
        }

        public Instant getBuildStart() {
            return this.buildStart;
        }
    }
}

