/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.presto.hive.util.CustomSplitConverter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hudi.hadoop.BootstrapBaseFileSplit;

public class HudiBootstrapBaseFileSplitConverter
implements CustomSplitConverter {
    public static final String BOOTSTRAP_FILE_SPLIT_PATH_KEY = "bootstrap_file_split_path";
    public static final String BOOTSTRAP_FILE_SPLIT_START_KEY = "bootstrap_split_start";
    public static final String BOOTSTRAP_FILE_SPLIT_LEN_KEY = "bootstrap_split_len";

    @Override
    public Optional<Map<String, String>> extractCustomSplitInfo(FileSplit split) {
        if (split instanceof BootstrapBaseFileSplit) {
            ImmutableMap.Builder customSplitInfo = new ImmutableMap.Builder();
            BootstrapBaseFileSplit hudiSplit = (BootstrapBaseFileSplit)split;
            customSplitInfo.put((Object)"custom_split_class", (Object)BootstrapBaseFileSplit.class.getName());
            customSplitInfo.put((Object)BOOTSTRAP_FILE_SPLIT_PATH_KEY, (Object)hudiSplit.getBootstrapFileSplit().getPath().toString());
            customSplitInfo.put((Object)BOOTSTRAP_FILE_SPLIT_START_KEY, (Object)String.valueOf(hudiSplit.getBootstrapFileSplit().getStart()));
            customSplitInfo.put((Object)BOOTSTRAP_FILE_SPLIT_LEN_KEY, (Object)String.valueOf(hudiSplit.getBootstrapFileSplit().getLength()));
            return Optional.of(customSplitInfo.build());
        }
        return Optional.empty();
    }

    @Override
    public Optional<FileSplit> recreateFileSplitWithCustomInfo(FileSplit split, Map<String, String> customSplitInfo) throws IOException {
        Objects.requireNonNull(customSplitInfo);
        String customFileSplitClass = customSplitInfo.get("custom_split_class");
        if (!Strings.isNullOrEmpty((String)customFileSplitClass) && BootstrapBaseFileSplit.class.getName().equals(customFileSplitClass)) {
            FileSplit bootstrapFileSplit = new FileSplit(new Path(customSplitInfo.get(BOOTSTRAP_FILE_SPLIT_PATH_KEY)), Long.parseLong(customSplitInfo.get(BOOTSTRAP_FILE_SPLIT_START_KEY)), Long.parseLong(customSplitInfo.get(BOOTSTRAP_FILE_SPLIT_LEN_KEY)), (String[])null);
            split = new BootstrapBaseFileSplit(split, bootstrapFileSplit);
            return Optional.of(split);
        }
        return Optional.empty();
    }
}

