/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hudi;

import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class HudiColumnHandle
implements ColumnHandle {
    private final int id;
    private final String name;
    private final HiveType hiveType;
    private final Optional<String> comment;
    private final ColumnType columnType;

    @JsonCreator
    public HudiColumnHandle(@JsonProperty(value="id") int id, @JsonProperty(value="name") String name, @JsonProperty(value="hiveType") HiveType hiveType, @JsonProperty(value="comment") Optional<String> comment, @JsonProperty(value="columnType") ColumnType columnType) {
        this.id = id;
        this.name = Objects.requireNonNull(name, "name is null");
        this.hiveType = Objects.requireNonNull(hiveType, "hiveType is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
    }

    @JsonProperty
    public int getId() {
        return this.id;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HudiColumnHandle that = (HudiColumnHandle)o;
        return this.id == that.id && Objects.equals(this.name, that.name) && Objects.equals(this.hiveType, that.hiveType) && Objects.equals(this.comment, that.comment) && this.columnType == that.columnType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.hiveType, this.comment, this.columnType});
    }

    @JsonProperty
    public HiveType getHiveType() {
        return this.hiveType;
    }

    @JsonProperty
    public Optional<String> getComment() {
        return this.comment;
    }

    @JsonProperty
    public ColumnType getColumnType() {
        return this.columnType;
    }

    public boolean isRegularColumn() {
        return this.columnType == ColumnType.REGULAR;
    }

    public ColumnMetadata toColumnMetadata(TypeManager typeManager) {
        return ColumnMetadata.builder().setName(this.name).setType(this.hiveType.getType(typeManager)).setExtraInfo(this.getExtraInfo()).build();
    }

    public String toString() {
        return this.id + ":" + this.name + ":" + this.hiveType + ":" + (Object)((Object)this.columnType);
    }

    private Optional<String> getExtraInfo() {
        return this.columnType == ColumnType.PARTITION_KEY ? Optional.of("partition key") : Optional.empty();
    }

    public static enum ColumnType {
        PARTITION_KEY,
        REGULAR;

    }
}

