/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hudi;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import io.airlift.units.DataSize;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class HudiConfig {
    private boolean metadataTableEnabled;
    private boolean sizeBasedSplitWeightsEnabled = true;
    private DataSize standardSplitWeightSize = new DataSize(128.0, DataSize.Unit.MEGABYTE);
    private double minimumAssignedSplitWeight = 0.05;
    private int maxOutstandingSplits = 1000;
    private int splitLoaderParallelism = 4;
    private int splitGeneratorParallelism = 4;

    public boolean isMetadataTableEnabled() {
        return this.metadataTableEnabled;
    }

    @Config(value="hudi.metadata-table-enabled")
    public HudiConfig setMetadataTableEnabled(boolean metadataTableEnabled) {
        this.metadataTableEnabled = metadataTableEnabled;
        return this;
    }

    public boolean isSizeBasedSplitWeightsEnabled() {
        return this.sizeBasedSplitWeightsEnabled;
    }

    @Config(value="hudi.size-based-split-weights-enabled")
    @ConfigDescription(value="Unlike uniform splitting, size-based splitting ensures that each batch of splits has enough data to process. By default, it is enabled to improve performance.")
    public HudiConfig setSizeBasedSplitWeightsEnabled(boolean sizeBasedSplitWeightsEnabled) {
        this.sizeBasedSplitWeightsEnabled = sizeBasedSplitWeightsEnabled;
        return this;
    }

    @NotNull
    public DataSize getStandardSplitWeightSize() {
        return this.standardSplitWeightSize;
    }

    @Config(value="hudi.standard-split-weight-size")
    @ConfigDescription(value="The split size corresponding to the standard weight (1.0) when size based split weights are enabled.")
    public HudiConfig setStandardSplitWeightSize(DataSize standardSplitWeightSize) {
        this.standardSplitWeightSize = standardSplitWeightSize;
        return this;
    }

    @DecimalMax(value="1")
    @DecimalMin(value="0", inclusive=false)
    public @DecimalMax(value="1") @DecimalMin(value="0", inclusive=false) double getMinimumAssignedSplitWeight() {
        return this.minimumAssignedSplitWeight;
    }

    @Config(value="hudi.minimum-assigned-split-weight")
    @ConfigDescription(value="Minimum weight that a split can be assigned when size based split weights are enabled.")
    public HudiConfig setMinimumAssignedSplitWeight(double minimumAssignedSplitWeight) {
        this.minimumAssignedSplitWeight = minimumAssignedSplitWeight;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxOutstandingSplits() {
        return this.maxOutstandingSplits;
    }

    @Config(value="hudi.max-outstanding-splits")
    @ConfigDescription(value="Maximum outstanding splits per batch for query.")
    public HudiConfig setMaxOutstandingSplits(int maxOutstandingSplits) {
        this.maxOutstandingSplits = maxOutstandingSplits;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getSplitGeneratorParallelism() {
        return this.splitGeneratorParallelism;
    }

    @Config(value="hudi.split-generator-parallelism")
    @ConfigDescription(value="Number of threads used to generate splits from partitions.")
    public HudiConfig setSplitGeneratorParallelism(int splitGeneratorParallelism) {
        this.splitGeneratorParallelism = splitGeneratorParallelism;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getSplitLoaderParallelism() {
        return this.splitLoaderParallelism;
    }

    @Config(value="hudi.split-loader-parallelism")
    @ConfigDescription(value="Number of threads used to run background split loader. A single background split loader is needed per query.")
    public HudiConfig setSplitLoaderParallelism(int splitLoaderParallelism) {
        this.splitLoaderParallelism = splitLoaderParallelism;
        return this;
    }
}

