/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hudi;

import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.presto.hive.HiveTransactionHandle;
import com.facebook.presto.hudi.HudiMetadataFactory;
import com.facebook.presto.hudi.HudiSessionProperties;
import com.facebook.presto.hudi.HudiTransactionManager;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorCapabilities;
import com.facebook.presto.spi.connector.ConnectorCommitHandle;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.connector.EmptyConnectorCommitHandle;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class HudiConnector
implements Connector {
    private final LifeCycleManager lifeCycleManager;
    private final HudiTransactionManager transactionManager;
    private final HudiMetadataFactory hudiMetadataFactory;
    private final ConnectorSplitManager splitManager;
    private final ConnectorPageSourceProvider pageSourceProvider;
    private final ConnectorNodePartitioningProvider nodePartitioningProvider;
    private final ConnectorAccessControl accessControl;
    private final HudiSessionProperties hudiSessionProperties;

    public HudiConnector(LifeCycleManager lifeCycleManager, HudiTransactionManager transactionManager, HudiMetadataFactory hudiMetadataFactory, ConnectorSplitManager splitManager, ConnectorPageSourceProvider pageSourceProvider, ConnectorNodePartitioningProvider nodePartitioningProvider, ConnectorAccessControl accessControl, HudiSessionProperties hudiSessionProperties) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.hudiMetadataFactory = Objects.requireNonNull(hudiMetadataFactory, "hudiMetadataFactory is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.nodePartitioningProvider = Objects.requireNonNull(nodePartitioningProvider, "nodePartitioningProvider is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.hudiSessionProperties = Objects.requireNonNull(hudiSessionProperties, "hudiSessionProperties is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.SERIALIZABLE, (IsolationLevel)isolationLevel);
        HiveTransactionHandle transaction = new HiveTransactionHandle();
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.transactionManager.put((ConnectorTransactionHandle)transaction, this.hudiMetadataFactory.create());
        }
        return transaction;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return this.transactionManager.get(transactionHandle);
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
        return this.nodePartitioningProvider;
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.hudiSessionProperties.getSessionProperties();
    }

    public ConnectorAccessControl getAccessControl() {
        return this.accessControl;
    }

    public ConnectorCommitHandle commit(ConnectorTransactionHandle transactionHandle) {
        this.transactionManager.remove(transactionHandle);
        return EmptyConnectorCommitHandle.INSTANCE;
    }

    public void rollback(ConnectorTransactionHandle transactionHandle) {
        this.transactionManager.remove(transactionHandle);
    }

    public boolean isSingleStatementWritesOnly() {
        return true;
    }

    public void shutdown() {
        this.lifeCycleManager.stop();
    }

    public Set<ConnectorCapabilities> getCapabilities() {
        return Sets.immutableEnumSet((Enum)ConnectorCapabilities.NOT_NULL_COLUMN_CONSTRAINT, (Enum[])new ConnectorCapabilities[0]);
    }
}

