/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hudi;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.ColumnConverterProvider;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveColumnConverterProvider;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hudi.HudiColumnHandle;
import com.facebook.presto.hudi.HudiErrorCode;
import com.facebook.presto.hudi.HudiTableHandle;
import com.facebook.presto.hudi.HudiTableLayoutHandle;
import com.facebook.presto.hudi.HudiTableType;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HudiMetadata
implements ConnectorMetadata {
    private static final Logger log = Logger.get(HudiMetadata.class);
    private final ExtendedHiveMetastore metastore;
    private final HdfsEnvironment hdfsEnvironment;
    private final TypeManager typeManager;

    public HudiMetadata(ExtendedHiveMetastore metastore, HdfsEnvironment hdfsEnvironment, TypeManager typeManager) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.metastore.getAllDatabases(HudiMetadata.toMetastoreContext(session));
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Optional hiveTable = this.metastore.getTable(HudiMetadata.toMetastoreContext(session), tableName.getSchemaName(), tableName.getTableName());
        if (!hiveTable.isPresent()) {
            return null;
        }
        Table table = (Table)hiveTable.get();
        String inputFormat = table.getStorage().getStorageFormat().getInputFormat();
        HudiTableType hudiTableType = HudiTableType.fromInputFormat(inputFormat);
        if (hudiTableType == HudiTableType.UNKNOWN) {
            throw new PrestoException((ErrorCodeSupplier)HudiErrorCode.HUDI_UNKNOWN_TABLE_TYPE, "Unknown table type " + inputFormat);
        }
        return new HudiTableHandle(table.getDatabaseName(), table.getTableName(), table.getStorage().getLocation(), hudiTableType);
    }

    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        return Optional.empty();
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        HudiTableHandle handle = (HudiTableHandle)tableHandle;
        Table table = this.getTable(session, tableHandle);
        List<HudiColumnHandle> partitionColumns = this.getPartitionColumnHandles(table);
        List<HudiColumnHandle> dataColumns = this.getDataColumnHandles(table);
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new HudiTableLayoutHandle(handle, dataColumns, partitionColumns, table.getParameters(), (TupleDomain<ColumnHandle>)constraint.getSummary()));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        return this.getTableMetadata(session, ((HudiTableHandle)table).getSchemaTableName());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        MetastoreContext metastoreContext = HudiMetadata.toMetastoreContext(session);
        return this.metastore.getAllTables(metastoreContext, schemaName.get()).orElseGet(() -> this.metastore.getAllDatabases(metastoreContext)).stream().map(table -> new SchemaTableName((String)schemaName.get(), table)).collect(Collectors.toList());
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        Table table = this.getTable(session, tableHandle);
        return (Map)this.allColumnHandles(table).collect(ImmutableMap.toImmutableMap(HudiColumnHandle::getName, Function.identity()));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((HudiColumnHandle)columnHandle).toColumnMetadata(this.typeManager);
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        List<SchemaTableName> tables = prefix.getTableName() != null ? Collections.singletonList(prefix.toSchemaTableName()) : this.listTables(session, Optional.of(prefix.getSchemaName()));
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName table : tables) {
            try {
                columns.put((Object)table, (Object)this.getTableMetadata(session, table).getColumns());
            }
            catch (TableNotFoundException e) {
                log.warn(String.format("table disappeared during listing operation: %s", e.getMessage()));
            }
        }
        return columns.build();
    }

    public ExtendedHiveMetastore getMetastore() {
        return this.metastore;
    }

    private Table getTable(ConnectorSession connectorSession, ConnectorTableHandle tableHandle) {
        MetastoreContext metastoreContext = HudiMetadata.toMetastoreContext(connectorSession);
        HudiTableHandle handle = (HudiTableHandle)tableHandle;
        Optional table = this.metastore.getTable(metastoreContext, handle.getSchemaName(), handle.getTableName());
        Preconditions.checkArgument((boolean)table.isPresent());
        return (Table)table.get();
    }

    private ConnectorTableMetadata getTableMetadata(ConnectorSession session, SchemaTableName tableName) {
        Table table = (Table)this.metastore.getTable(HudiMetadata.toMetastoreContext(session), tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        List columnMetadatas = this.allColumnHandles(table).map(columnHandle -> columnHandle.toColumnMetadata(this.typeManager)).collect(Collectors.toList());
        return new ConnectorTableMetadata(tableName, columnMetadatas);
    }

    private Stream<HudiColumnHandle> allColumnHandles(Table table) {
        return Stream.concat(this.getDataColumnHandles(table).stream(), this.getPartitionColumnHandles(table).stream());
    }

    private List<HudiColumnHandle> getDataColumnHandles(Table table) {
        return HudiMetadata.fromDataColumns(table.getDataColumns());
    }

    private List<HudiColumnHandle> getPartitionColumnHandles(Table table) {
        return HudiMetadata.fromPartitionColumns(table.getPartitionColumns());
    }

    static List<HudiColumnHandle> fromPartitionColumns(List<Column> partitionColumns) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)partitionColumns.size());
        int id = -13;
        for (Column column : partitionColumns) {
            HiveType hiveType = column.getType();
            if (!hiveType.isSupportedType()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Partition key type %s not supported", hiveType));
            }
            builder.add((Object)HudiMetadata.fromPartitionColumn(id, column));
            --id;
        }
        return builder.build();
    }

    static List<HudiColumnHandle> fromDataColumns(List<Column> dataColumns) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int id = 0;
        for (Column column : dataColumns) {
            HiveType hiveType = column.getType();
            if (hiveType.isSupportedType()) {
                builder.add((Object)HudiMetadata.fromDataColumn(id, column));
            }
            ++id;
        }
        return builder.build();
    }

    public static MetastoreContext toMetastoreContext(ConnectorSession session) {
        return new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER);
    }

    private static HudiColumnHandle fromDataColumn(int index, Column column) {
        return new HudiColumnHandle(index, column.getName(), column.getType(), column.getComment(), HudiColumnHandle.ColumnType.REGULAR);
    }

    private static HudiColumnHandle fromPartitionColumn(int index, Column column) {
        return new HudiColumnHandle(index, column.getName(), column.getType(), column.getComment(), HudiColumnHandle.ColumnType.PARTITION_KEY);
    }
}

