/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hudi;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.Utils;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hudi.HudiColumnHandle;
import com.facebook.presto.hudi.HudiErrorCode;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Throwables;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HudiPageSource
implements ConnectorPageSource {
    private final boolean hasPrefilledBlocks;
    private final Block[] prefilledBlocks;
    private final int[] delegateIndexes;
    private final ConnectorPageSource delegate;

    public HudiPageSource(List<HudiColumnHandle> columns, Map<String, String> partitionKeys, ConnectorPageSource delegate, TimeZoneKey timeZoneKey, TypeManager typeManager) {
        int size = Objects.requireNonNull(columns, "columns is null").size();
        Objects.requireNonNull(partitionKeys, "partitionKeys is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.prefilledBlocks = new Block[size];
        this.delegateIndexes = new int[size];
        int outputIndex = 0;
        int delegateIndex = 0;
        boolean hasPrefilledBlocks = false;
        for (HudiColumnHandle column : columns) {
            if (partitionKeys.containsKey(column.getName())) {
                String partitionValue = partitionKeys.get(column.getName());
                Type type = column.getHiveType().getType(typeManager);
                Object prefilledValue = HudiPageSource.deserializePartitionValue(type, partitionValue, column.getName(), timeZoneKey);
                this.prefilledBlocks[outputIndex] = Utils.nativeValueToBlock((Type)type, (Object)prefilledValue);
                this.delegateIndexes[outputIndex] = -1;
                hasPrefilledBlocks = true;
            } else {
                this.delegateIndexes[outputIndex] = delegateIndex++;
            }
            ++outputIndex;
        }
        this.hasPrefilledBlocks = hasPrefilledBlocks;
    }

    public long getCompletedBytes() {
        return this.delegate.getCompletedBytes();
    }

    public long getCompletedPositions() {
        return this.delegate.getCompletedPositions();
    }

    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.delegate.isFinished();
    }

    public Page getNextPage() {
        try {
            Page dataPage = this.delegate.getNextPage();
            if (dataPage == null) {
                return null;
            }
            if (!this.hasPrefilledBlocks) {
                return dataPage;
            }
            int batchSize = dataPage.getPositionCount();
            Block[] blocks = new Block[this.prefilledBlocks.length];
            for (int i = 0; i < this.prefilledBlocks.length; ++i) {
                blocks[i] = this.prefilledBlocks[i] != null ? new RunLengthEncodedBlock(this.prefilledBlocks[i], batchSize) : dataPage.getBlock(this.delegateIndexes[i]);
            }
            return new Page(batchSize, blocks);
        }
        catch (RuntimeException e) {
            this.closeWithSuppression(e);
            Throwables.throwIfInstanceOf((Throwable)e, PrestoException.class);
            throw new PrestoException((ErrorCodeSupplier)HudiErrorCode.HUDI_CURSOR_ERROR, (Throwable)e);
        }
    }

    public void close() {
        try {
            this.delegate.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    public long getSystemMemoryUsage() {
        return this.delegate.getSystemMemoryUsage();
    }

    protected void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (RuntimeException e) {
                if (throwable == e) break block2;
                throwable.addSuppressed(e);
            }
        }
    }

    static Object deserializePartitionValue(Type type, String valueString, String name, TimeZoneKey timeZoneKey) {
        if (valueString == null || "__HIVE_DEFAULT_PARTITION__".equals(valueString)) {
            return null;
        }
        try {
            if (type.equals(BooleanType.BOOLEAN)) {
                if (valueString.equalsIgnoreCase("true")) {
                    return true;
                }
                if (valueString.equalsIgnoreCase("false")) {
                    return false;
                }
                throw new IllegalArgumentException();
            }
            if (type.equals(IntegerType.INTEGER)) {
                return (long)Integer.parseInt(valueString);
            }
            if (type.equals(BigintType.BIGINT)) {
                return Long.parseLong(valueString);
            }
            if (type.equals(RealType.REAL)) {
                return (long)Float.floatToRawIntBits(Float.parseFloat(valueString));
            }
            if (type.equals(DoubleType.DOUBLE)) {
                return Double.parseDouble(valueString);
            }
            if (type.equals(DateType.DATE)) {
                return LocalDate.parse(valueString, DateTimeFormatter.ISO_LOCAL_DATE).toEpochDay();
            }
            if (type instanceof VarcharType) {
                return Slices.utf8Slice((String)valueString);
            }
            if (type.equals(VarbinaryType.VARBINARY)) {
                return Slices.utf8Slice((String)valueString);
            }
            if (Decimals.isShortDecimal((Type)type) || Decimals.isLongDecimal((Type)type)) {
                DecimalType decimalType = (DecimalType)type;
                BigDecimal decimal = new BigDecimal(valueString);
                if ((decimal = decimal.setScale(decimalType.getScale(), 7)).precision() > decimalType.getPrecision()) {
                    throw new IllegalArgumentException();
                }
                BigInteger unscaledValue = decimal.unscaledValue();
                return Decimals.isShortDecimal((Type)type) ? Long.valueOf(unscaledValue.longValue()) : Decimals.encodeUnscaledValue((BigInteger)unscaledValue);
            }
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)HudiErrorCode.HUDI_INVALID_PARTITION_VALUE, String.format("Invalid partition value '%s' for %s partition key: %s", valueString, type.getDisplayName(), name));
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Invalid partition type " + type);
    }
}

