/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hudi;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hudi.HudiColumnHandle;
import com.facebook.presto.hudi.HudiErrorCode;
import com.facebook.presto.hudi.HudiFile;
import com.facebook.presto.hudi.HudiPageSource;
import com.facebook.presto.hudi.HudiParquetPageSources;
import com.facebook.presto.hudi.HudiRecordCursors;
import com.facebook.presto.hudi.HudiSplit;
import com.facebook.presto.hudi.HudiTableLayoutHandle;
import com.facebook.presto.hudi.HudiTableType;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.spi.SplitContext;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class HudiPageSourceProvider
implements ConnectorPageSourceProvider {
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats fileFormatDataSourceStats;
    private final TypeManager typeManager;

    @Inject
    public HudiPageSourceProvider(HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats fileFormatDataSourceStats, TypeManager typeManager) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.fileFormatDataSourceStats = Objects.requireNonNull(fileFormatDataSourceStats, "fileFormatDataSourceStats is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, ConnectorTableLayoutHandle layoutHandle, List<ColumnHandle> columns, SplitContext splitContext) {
        ConnectorPageSource dataColumnPageSource;
        HudiTableLayoutHandle layout = (HudiTableLayoutHandle)layoutHandle;
        HudiSplit hudiSplit = (HudiSplit)split;
        HudiTableType tableType = layout.getTable().getTableType();
        List<HudiColumnHandle> hudiColumnHandles = columns.stream().map(HudiColumnHandle.class::cast).collect(Collectors.toList());
        List<HudiColumnHandle> dataColumns = hudiColumnHandles.stream().filter(HudiColumnHandle::isRegularColumn).collect(Collectors.toList());
        if (tableType == HudiTableType.COW) {
            HudiFile baseFile = hudiSplit.getBaseFile().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)HudiErrorCode.HUDI_CANNOT_OPEN_SPLIT, "Split without base file is invalid"));
            Path path = new Path(baseFile.getPath());
            Configuration configuration = this.hdfsEnvironment.getConfiguration(new HdfsContext(session, layout.getTable().getSchemaName(), layout.getTable().getTableName(), baseFile.getPath(), false), path);
            dataColumnPageSource = HudiParquetPageSources.createParquetPageSource(this.typeManager, this.hdfsEnvironment, session, configuration, path, baseFile.getStart(), baseFile.getLength(), dataColumns, (TupleDomain<HudiColumnHandle>)TupleDomain.all(), this.fileFormatDataSourceStats);
        } else if (tableType == HudiTableType.MOR) {
            Properties schema = MetastoreUtil.getHiveSchema((Storage)hudiSplit.getPartition().getStorage(), HudiPageSourceProvider.toMetastoreColumns(hudiSplit.getPartition().getDataColumns()), HudiPageSourceProvider.toMetastoreColumns(layout.getDataColumns()), layout.getTableParameters(), (String)layout.getTable().getSchemaName(), (String)layout.getTable().getTableName(), (List)((List)layout.getPartitionColumns().stream().map(HudiColumnHandle::getName).collect(ImmutableList.toImmutableList())), (List)((List)layout.getPartitionColumns().stream().map(HudiColumnHandle::getHiveType).collect(ImmutableList.toImmutableList())));
            RecordCursor recordCursor = HudiRecordCursors.createRealtimeRecordCursor(this.hdfsEnvironment, session, schema, hudiSplit, dataColumns, ZoneId.of("UTC"), this.typeManager);
            List types = (List)dataColumns.stream().map(column -> column.getHiveType().getType(this.typeManager)).collect(ImmutableList.toImmutableList());
            dataColumnPageSource = new RecordPageSource(types, recordCursor);
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Could not create page source for table type " + (Object)((Object)tableType));
        }
        return new HudiPageSource(hudiColumnHandles, hudiSplit.getPartition().getKeyValues(), dataColumnPageSource, session.getSqlFunctionProperties().getTimeZoneKey(), this.typeManager);
    }

    private static List<Column> toMetastoreColumns(List<HudiColumnHandle> hudiColumnHandles) {
        return (List)hudiColumnHandles.stream().map(column -> new Column(column.getName(), column.getHiveType(), Optional.empty(), Optional.empty())).collect(ImmutableList.toImmutableList());
    }
}

