/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hudi;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hudi.HudiColumnHandle;
import com.facebook.presto.hudi.HudiMetadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class HudiPartitionManager {
    private final TypeManager typeManager;

    @Inject
    public HudiPartitionManager(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public List<String> getEffectivePartitions(ConnectorSession connectorSession, ExtendedHiveMetastore metastore, String schemaName, String tableName, TupleDomain<ColumnHandle> tupleDomain) {
        MetastoreContext metastoreContext = HudiMetadata.toMetastoreContext(connectorSession);
        Optional table = metastore.getTable(metastoreContext, schemaName, tableName);
        Verify.verify((boolean)table.isPresent());
        List partitionColumns = ((Table)table.get()).getPartitionColumns();
        if (partitionColumns.isEmpty()) {
            return ImmutableList.of((Object)"");
        }
        HashMap partitionPredicate = new HashMap();
        Map domains = (Map)tupleDomain.getDomains().orElse(ImmutableMap.of());
        List<HudiColumnHandle> hudiColumnHandles = HudiMetadata.fromPartitionColumns(partitionColumns);
        for (int i = 0; i < hudiColumnHandles.size(); ++i) {
            HudiColumnHandle column = hudiColumnHandles.get(i);
            Column partitionColumn = (Column)partitionColumns.get(i);
            if (domains.containsKey(column)) {
                partitionPredicate.put(partitionColumn, domains.get(column));
                continue;
            }
            partitionPredicate.put(partitionColumn, Domain.all((Type)column.getHiveType().getType(this.typeManager)));
        }
        return metastore.getPartitionNamesByFilter(metastoreContext, schemaName, tableName, partitionPredicate);
    }
}

