/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hudi;

import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hudi.HudiColumnHandle;
import com.facebook.presto.hudi.HudiErrorCode;
import com.facebook.presto.hudi.HudiFile;
import com.facebook.presto.hudi.HudiSplit;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import io.airlift.compress.lzo.LzoCodec;
import io.airlift.compress.lzo.LzopCodec;
import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hadoop.realtime.HoodieRealtimeFileSplit;

class HudiRecordCursors {
    private HudiRecordCursors() {
    }

    public static RecordCursor createRealtimeRecordCursor(HdfsEnvironment hdfsEnvironment, ConnectorSession session, Properties schema, HudiSplit split, List<HudiColumnHandle> dataColumns, ZoneId hiveStorageTimeZone, TypeManager typeManager) {
        Objects.requireNonNull(session, "session is null");
        Preconditions.checkArgument((boolean)dataColumns.stream().allMatch(HudiRecordCursors::isRegularColumn), (Object)"dataColumns contains non regular column");
        HudiFile baseFile = HudiRecordCursors.getHudiBaseFile(split);
        Path path = new Path(baseFile.getPath());
        HdfsContext context = new HdfsContext(session, split.getTable().getSchemaName(), split.getTable().getTableName(), baseFile.getPath(), false);
        Configuration conf = null;
        try {
            conf = hdfsEnvironment.getFileSystem(context, path).getConf();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HudiErrorCode.HUDI_FILESYSTEM_ERROR, "Could not open file system for " + split.getTable(), (Throwable)e);
        }
        Configuration configuration = conf;
        return (RecordCursor)hdfsEnvironment.doAs(session.getUser(), () -> {
            RecordReader<?, ?> recordReader;
            RecordReader<?, ?> reader = recordReader = HudiRecordCursors.createRecordReader(configuration, schema, split, dataColumns);
            return com.facebook.presto.hive.HudiRecordCursors.createRecordCursor(configuration, path, reader, baseFile.getLength(), schema, dataColumns, hiveStorageTimeZone, typeManager);
        });
    }

    private static RecordReader<?, ?> createRecordReader(Configuration configuration, Properties schema, HudiSplit split, List<HudiColumnHandle> dataColumns) {
        JobConf jobConf = new JobConf(configuration);
        jobConf.setBoolean("hive.io.file.read.all.columns", false);
        jobConf.set("hive.io.file.readcolumn.ids", HudiRecordCursors.join(dataColumns, HudiColumnHandle::getId));
        jobConf.set("hive.io.file.readcolumn.names", HudiRecordCursors.join(dataColumns, HudiColumnHandle::getName));
        schema.stringPropertyNames().forEach(name -> jobConf.set(name, schema.getProperty((String)name)));
        HudiRecordCursors.refineCompressionCodecs((Configuration)jobConf);
        String inputFormatName = split.getPartition().getStorage().getStorageFormat().getInputFormat();
        InputFormat<?, ?> inputFormat = HudiRecordCursors.createInputFormat((Configuration)jobConf, inputFormatName);
        try {
            HudiFile baseFile = HudiRecordCursors.getHudiBaseFile(split);
            Path path = new Path(baseFile.getPath());
            FileSplit fileSplit = new FileSplit(path, baseFile.getStart(), baseFile.getLength(), (String[])null);
            List logFiles = split.getLogFiles().stream().map(file -> new HoodieLogFile(file.getPath())).collect(Collectors.toList());
            String tablePath = split.getTable().getPath();
            HoodieRealtimeFileSplit hudiSplit = new HoodieRealtimeFileSplit(fileSplit, tablePath, logFiles, split.getInstantTime(), false, Option.empty());
            return inputFormat.getRecordReader((InputSplit)hudiSplit, jobConf, Reporter.NULL);
        }
        catch (IOException e) {
            String msg = String.format("Error opening Hive split %s using %s: %s", split, inputFormatName, MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e.getClass().getName()));
            throw new PrestoException((ErrorCodeSupplier)HudiErrorCode.HUDI_CANNOT_OPEN_SPLIT, msg, (Throwable)e);
        }
    }

    private static InputFormat<?, ?> createInputFormat(Configuration conf, String inputFormat) {
        try {
            Class clazz = conf.getClassByName(inputFormat);
            Class<InputFormat> cls = clazz.asSubclass(InputFormat.class);
            return (InputFormat)ReflectionUtils.newInstance(cls, (Configuration)conf);
        }
        catch (ClassNotFoundException | RuntimeException e) {
            throw new PrestoException((ErrorCodeSupplier)HudiErrorCode.HUDI_CANNOT_OPEN_SPLIT, "Unable to create input format " + inputFormat, (Throwable)e);
        }
    }

    private static void refineCompressionCodecs(Configuration conf) {
        ArrayList codecs = Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)conf.get("io.compression.codecs", "")));
        if (!codecs.contains(LzoCodec.class.getName())) {
            codecs.add(0, LzoCodec.class.getName());
        }
        if (!codecs.contains(LzopCodec.class.getName())) {
            codecs.add(0, LzopCodec.class.getName());
        }
        conf.set("io.compression.codecs", String.join((CharSequence)",", codecs));
    }

    private static <T, V> String join(List<T> list, Function<T, V> extractor) {
        return Joiner.on((char)',').join(list.stream().map(extractor).iterator());
    }

    private static boolean isRegularColumn(HudiColumnHandle column) {
        return column.getColumnType() == HudiColumnHandle.ColumnType.REGULAR;
    }

    private static HudiFile getHudiBaseFile(HudiSplit hudiSplit) {
        if (hudiSplit.getBaseFile().isPresent()) {
            return hudiSplit.getBaseFile().get();
        }
        return hudiSplit.getLogFiles().get(0);
    }
}

