/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hudi;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hudi.HudiColumnHandle;
import com.facebook.presto.hudi.HudiErrorCode;
import com.facebook.presto.hudi.HudiMetadata;
import com.facebook.presto.hudi.HudiPartition;
import com.facebook.presto.hudi.HudiPartitionManager;
import com.facebook.presto.hudi.HudiSessionProperties;
import com.facebook.presto.hudi.HudiSplitSource;
import com.facebook.presto.hudi.HudiTableHandle;
import com.facebook.presto.hudi.HudiTableLayoutHandle;
import com.facebook.presto.hudi.HudiTransactionManager;
import com.facebook.presto.hudi.split.ForHudiBackgroundSplitLoader;
import com.facebook.presto.hudi.split.ForHudiSplitAsyncQueue;
import com.facebook.presto.hudi.split.ForHudiSplitSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.HoodieTimer;

public class HudiSplitManager
implements ConnectorSplitManager {
    private static final Logger log = Logger.get(HudiSplitManager.class);
    private final HdfsEnvironment hdfsEnvironment;
    private final HudiTransactionManager hudiTransactionManager;
    private final HudiPartitionManager hudiPartitionManager;
    private final ExecutorService asyncQueueExecutor;
    private final ScheduledExecutorService splitLoaderExecutorService;
    private final ExecutorService splitGeneratorExecutorService;

    @Inject
    public HudiSplitManager(HdfsEnvironment hdfsEnvironment, HudiTransactionManager hudiTransactionManager, HudiPartitionManager hudiPartitionManager, @ForHudiSplitAsyncQueue ExecutorService asyncQueueExecutor, @ForHudiSplitSource ScheduledExecutorService splitLoaderExecutorService, @ForHudiBackgroundSplitLoader ExecutorService splitGeneratorExecutorService) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.hudiTransactionManager = Objects.requireNonNull(hudiTransactionManager, "hudiTransactionManager is null");
        this.hudiPartitionManager = Objects.requireNonNull(hudiPartitionManager, "hudiPartitionManager is null");
        this.asyncQueueExecutor = Objects.requireNonNull(asyncQueueExecutor, "asyncQueueExecutor is null");
        this.splitLoaderExecutorService = Objects.requireNonNull(splitLoaderExecutorService, "splitLoaderExecutorService is null");
        this.splitGeneratorExecutorService = Objects.requireNonNull(splitGeneratorExecutorService, "splitGeneratorExecutorService is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableLayoutHandle layoutHandle, ConnectorSplitManager.SplitSchedulingContext splitSchedulingContext) {
        ExtendedHiveMetastore metastore = ((HudiMetadata)this.hudiTransactionManager.get(transaction)).getMetastore();
        HudiTableLayoutHandle layout = (HudiTableLayoutHandle)layoutHandle;
        HudiTableHandle table = layout.getTable();
        HoodieTimer timer = new HoodieTimer().startTimer();
        List<String> partitions = this.hudiPartitionManager.getEffectivePartitions(session, metastore, table.getSchemaName(), table.getTableName(), layout.getTupleDomain());
        log.debug("Took %d ms to get %d partitions", new Object[]{timer.endTimer(), partitions.size()});
        if (partitions.isEmpty()) {
            return new FixedSplitSource((Iterable)ImmutableList.of());
        }
        ExtendedFileSystem fs = this.getFileSystem(session, table);
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().enable(HudiSessionProperties.isHudiMetadataTableEnabled(session)).build();
        Configuration conf = fs.getConf();
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(conf).setBasePath(table.getPath()).build();
        HoodieTimeline timeline = metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
        String timestamp = (String)timeline.lastInstant().map(HoodieInstant::getTimestamp).orElse(null);
        if (timestamp == null) {
            return new FixedSplitSource((Iterable)ImmutableList.of());
        }
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext(conf);
        HoodieTableFileSystemView fsView = FileSystemViewManager.createInMemoryFileSystemViewWithTimeline((HoodieEngineContext)engineContext, (HoodieTableMetaClient)metaClient, (HoodieMetadataConfig)metadataConfig, (HoodieTimeline)timeline);
        return new HudiSplitSource(session, metastore, layout, fsView, partitions, timestamp, this.asyncQueueExecutor, this.splitLoaderExecutorService, this.splitGeneratorExecutorService, HudiSessionProperties.getMaxOutstandingSplits(session));
    }

    private ExtendedFileSystem getFileSystem(ConnectorSession session, HudiTableHandle table) {
        HdfsContext hdfsContext = new HdfsContext(session, table.getSchemaName(), table.getTableName(), table.getPath(), false);
        try {
            return this.hdfsEnvironment.getFileSystem(hdfsContext, new Path(table.getPath()));
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HudiErrorCode.HUDI_FILESYSTEM_ERROR, "Could not open file system for " + table, (Throwable)e);
        }
    }

    public static HudiPartition getHudiPartition(ExtendedHiveMetastore metastore, MetastoreContext context, HudiTableLayoutHandle tableLayout, String partitionName) {
        String databaseName = tableLayout.getTable().getSchemaName();
        String tableName = tableLayout.getTable().getTableName();
        List<HudiColumnHandle> partitionColumns = tableLayout.getPartitionColumns();
        if (partitionColumns.isEmpty()) {
            Table table = (Table)metastore.getTable(context, databaseName, tableName).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)HudiErrorCode.HUDI_INVALID_METADATA, String.format("Table %s.%s expected but not found", databaseName, tableName)));
            return new HudiPartition(partitionName, (List<String>)ImmutableList.of(), (Map<String, String>)ImmutableMap.of(), table.getStorage(), tableLayout.getDataColumns());
        }
        List partitionValues = MetastoreUtil.extractPartitionValues((String)partitionName);
        Preconditions.checkArgument((partitionColumns.size() == partitionValues.size() ? 1 : 0) != 0, (Object)String.format("Invalid partition name %s for partition columns %s", partitionName, partitionColumns));
        Partition partition = (Partition)metastore.getPartition(context, databaseName, tableName, partitionValues).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)HudiErrorCode.HUDI_INVALID_METADATA, String.format("Partition %s expected but not found", partitionName)));
        Map<String, String> keyValues = HudiSplitManager.zipPartitionKeyValues(partitionColumns, partitionValues);
        return new HudiPartition(partitionName, partitionValues, keyValues, partition.getStorage(), HudiMetadata.fromDataColumns(partition.getColumns()));
    }

    private static Map<String, String> zipPartitionKeyValues(List<HudiColumnHandle> partitionColumns, List<String> partitionValues) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Streams.forEachPair(partitionColumns.stream(), partitionValues.stream(), (column, value) -> builder.put((Object)column.getName(), value));
        return builder.build();
    }
}

