/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hudi;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.hudi.HudiColumnHandle;
import com.facebook.presto.hudi.HudiTableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HudiTableLayoutHandle
implements ConnectorTableLayoutHandle {
    private final HudiTableHandle table;
    private final List<HudiColumnHandle> dataColumns;
    private final List<HudiColumnHandle> partitionColumns;
    private final Map<String, String> tableParameters;
    private final TupleDomain<ColumnHandle> tupleDomain;

    @JsonCreator
    public HudiTableLayoutHandle(@JsonProperty(value="table") HudiTableHandle table, @JsonProperty(value="dataColumns") List<HudiColumnHandle> dataColumns, @JsonProperty(value="partitionColumns") List<HudiColumnHandle> partitionColumns, @JsonProperty(value="tableParameters") Map<String, String> tableParameters, @JsonProperty(value="tupleDomain") TupleDomain<ColumnHandle> tupleDomain) {
        this.table = Objects.requireNonNull(table, "table is null");
        this.dataColumns = Objects.requireNonNull(dataColumns, "dataColumns is null");
        this.partitionColumns = Objects.requireNonNull(partitionColumns, "partitionColumns is null");
        this.tableParameters = Objects.requireNonNull(tableParameters, "tableParameters is null");
        this.tupleDomain = Objects.requireNonNull(tupleDomain, "tupleDomain is null");
    }

    @JsonProperty
    public HudiTableHandle getTable() {
        return this.table;
    }

    @JsonProperty
    public List<HudiColumnHandle> getDataColumns() {
        return this.dataColumns;
    }

    @JsonProperty
    public List<HudiColumnHandle> getPartitionColumns() {
        return this.partitionColumns;
    }

    @JsonProperty
    public Map<String, String> getTableParameters() {
        return this.tableParameters;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getTupleDomain() {
        return this.tupleDomain;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HudiTableLayoutHandle that = (HudiTableLayoutHandle)o;
        return Objects.equals(this.table, that.table) && Objects.equals(this.tupleDomain, that.tupleDomain);
    }

    public int hashCode() {
        return Objects.hash(this.table, this.tupleDomain);
    }

    public String toString() {
        return this.table.toString();
    }
}

